/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.dev.colorchooser.ColorChooser;
import org.gephi.ui.components.JColorButton;
import org.gephi.visualization.VizController;
import org.gephi.visualization.VizModel;
import org.openide.util.NbBundle;

public class EdgeSettingsPanel
extends JPanel {
    private ColorChooser edgeBothSelectionColorChooser;
    private JButton edgeColorButton;
    private ColorChooser edgeInSelectionColorChooser;
    private ColorChooser edgeOutSelectionColorChooser;
    private JLabel labelBoth;
    private JLabel labelEdgeColor;
    private JLabel labelIn;
    private JLabel labelOut;
    private JLabel labelScale;
    private JPanel scalePanel;
    private JSlider scaleSlider;
    private JCheckBox selectionColorCheckbox;
    private JPanel selectionColorPanel;
    private JCheckBox showEdgesCheckbox;
    private JCheckBox sourceNodeColorCheckbox;

    public EdgeSettingsPanel() {
        this.initComponents();
    }

    public void setup() {
        VizModel vizModel = VizController.getInstance().getVizModel();
        vizModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("init")) {
                    EdgeSettingsPanel.this.refreshSharedConfig();
                } else if (evt.getPropertyName().equals("edgeHasUniColor")) {
                    EdgeSettingsPanel.this.refreshSharedConfig();
                } else if (evt.getPropertyName().equals("showEdges")) {
                    EdgeSettingsPanel.this.refreshSharedConfig();
                } else if (evt.getPropertyName().equals("edgeUniColor")) {
                    EdgeSettingsPanel.this.refreshSharedConfig();
                } else if (evt.getPropertyName().equals("edgeSelectionColor")) {
                    EdgeSettingsPanel.this.refreshSharedConfig();
                } else if (evt.getPropertyName().equals("edgeInSelectionColor")) {
                    EdgeSettingsPanel.this.refreshSharedConfig();
                } else if (evt.getPropertyName().equals("edgeOutSelectionColor")) {
                    EdgeSettingsPanel.this.refreshSharedConfig();
                } else if (evt.getPropertyName().equals("edgeBothSelectionColor")) {
                    EdgeSettingsPanel.this.refreshSharedConfig();
                } else if (evt.getPropertyName().equals("edgeScale")) {
                    EdgeSettingsPanel.this.refreshSharedConfig();
                }
            }
        });
        this.refreshSharedConfig();
        this.showEdgesCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VizModel vizModel = VizController.getInstance().getVizModel();
                vizModel.setShowEdges(EdgeSettingsPanel.this.showEdgesCheckbox.isSelected());
                EdgeSettingsPanel.this.setEnable(true);
            }
        });
        ((JColorButton)this.edgeColorButton).addPropertyChangeListener(JColorButton.EVENT_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                VizModel vizModel = VizController.getInstance().getVizModel();
                vizModel.setEdgeUniColor(((JColorButton)EdgeSettingsPanel.this.edgeColorButton).getColorArray());
            }
        });
        this.sourceNodeColorCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VizModel vizModel = VizController.getInstance().getVizModel();
                vizModel.setEdgeHasUniColor(!EdgeSettingsPanel.this.sourceNodeColorCheckbox.isSelected());
            }
        });
        this.selectionColorCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VizModel vizModel = VizController.getInstance().getVizModel();
                vizModel.setEdgeSelectionColor(EdgeSettingsPanel.this.selectionColorCheckbox.isSelected());
            }
        });
        this.edgeInSelectionColorChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VizModel vizModel = VizController.getInstance().getVizModel();
                vizModel.setEdgeInSelectionColor(EdgeSettingsPanel.this.edgeInSelectionColorChooser.getColor().getComponents(null));
            }
        });
        this.edgeBothSelectionColorChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VizModel vizModel = VizController.getInstance().getVizModel();
                vizModel.setEdgeBothSelectionColor(EdgeSettingsPanel.this.edgeBothSelectionColorChooser.getColor().getComponents(null));
            }
        });
        this.edgeOutSelectionColorChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VizModel vizModel = VizController.getInstance().getVizModel();
                vizModel.setEdgeOutSelectionColor(EdgeSettingsPanel.this.edgeOutSelectionColorChooser.getColor().getComponents(null));
            }
        });
        this.scaleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VizModel vizModel = VizController.getInstance().getVizModel();
                if (vizModel.getEdgeScale() != (float)EdgeSettingsPanel.this.scaleSlider.getValue() / 10.0f + 0.1f) {
                    vizModel.setEdgeScale((float)EdgeSettingsPanel.this.scaleSlider.getValue() / 10.0f + 0.1f);
                }
            }
        });
    }

    private void refreshSharedConfig() {
        VizModel vizModel = VizController.getInstance().getVizModel();
        this.setEnable(!vizModel.isDefaultModel());
        if (vizModel.isDefaultModel()) {
            return;
        }
        if (this.showEdgesCheckbox.isSelected() != vizModel.isShowEdges()) {
            this.showEdgesCheckbox.setSelected(vizModel.isShowEdges());
        }
        float[] edgeCol = vizModel.getEdgeUniColor();
        ((JColorButton)this.edgeColorButton).setColor(new Color(edgeCol[0], edgeCol[1], edgeCol[2], edgeCol[3]));
        if (this.sourceNodeColorCheckbox.isSelected() != !vizModel.isEdgeHasUniColor()) {
            this.sourceNodeColorCheckbox.setSelected(!vizModel.isEdgeHasUniColor());
        }
        if (this.selectionColorCheckbox.isSelected() != vizModel.isEdgeSelectionColor()) {
            this.selectionColorCheckbox.setSelected(vizModel.isEdgeSelectionColor());
        }
        Color in = new Color(ColorSpace.getInstance(1000), vizModel.getEdgeInSelectionColor(), 1.0f);
        Color out = new Color(ColorSpace.getInstance(1000), vizModel.getEdgeOutSelectionColor(), 1.0f);
        Color both = new Color(ColorSpace.getInstance(1000), vizModel.getEdgeBothSelectionColor(), 1.0f);
        if (!this.edgeInSelectionColorChooser.getColor().equals(in)) {
            this.edgeInSelectionColorChooser.setColor(in);
        }
        if (!this.edgeBothSelectionColorChooser.getColor().equals(both)) {
            this.edgeBothSelectionColorChooser.setColor(both);
        }
        if (!this.edgeOutSelectionColorChooser.getColor().equals(out)) {
            this.edgeOutSelectionColorChooser.setColor(out);
        }
        if ((float)this.scaleSlider.getValue() / 10.0f + 0.1f != vizModel.getEdgeScale()) {
            this.scaleSlider.setValue((int)((vizModel.getEdgeScale() - 0.1f) * 10.0f));
        }
    }

    private void setEnable(boolean enable) {
        this.showEdgesCheckbox.setEnabled(enable);
        this.edgeColorButton.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.sourceNodeColorCheckbox.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.labelEdgeColor.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.scaleSlider.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.labelScale.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.selectionColorCheckbox.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.edgeInSelectionColorChooser.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.selectionColorCheckbox.isSelected());
        this.edgeBothSelectionColorChooser.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.selectionColorCheckbox.isSelected());
        this.edgeOutSelectionColorChooser.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.selectionColorCheckbox.isSelected());
        this.labelIn.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.selectionColorCheckbox.isSelected());
        this.labelOut.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.selectionColorCheckbox.isSelected());
        this.labelBoth.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.selectionColorCheckbox.isSelected());
    }

    private void initComponents() {
        this.showEdgesCheckbox = new JCheckBox();
        this.labelEdgeColor = new JLabel();
        this.edgeColorButton = new JColorButton(Color.BLACK, false, true);
        this.sourceNodeColorCheckbox = new JCheckBox();
        this.selectionColorPanel = new JPanel();
        this.selectionColorCheckbox = new JCheckBox();
        this.edgeInSelectionColorChooser = new ColorChooser();
        this.edgeOutSelectionColorChooser = new ColorChooser();
        this.edgeBothSelectionColorChooser = new ColorChooser();
        this.labelIn = new JLabel();
        this.labelOut = new JLabel();
        this.labelBoth = new JLabel();
        this.scalePanel = new JPanel();
        this.labelScale = new JLabel();
        this.scaleSlider = new JSlider();
        this.showEdgesCheckbox.setFont(new Font("Tahoma", 1, 11));
        this.showEdgesCheckbox.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.showEdgesCheckbox.text"));
        this.labelEdgeColor.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.labelEdgeColor.text"));
        this.edgeColorButton.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.edgeColorButton.text"));
        this.sourceNodeColorCheckbox.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.sourceNodeColorCheckbox.text"));
        this.sourceNodeColorCheckbox.setBorder(null);
        this.sourceNodeColorCheckbox.setHorizontalAlignment(2);
        this.sourceNodeColorCheckbox.setHorizontalTextPosition(2);
        this.sourceNodeColorCheckbox.setMargin(new Insets(2, 0, 2, 2));
        this.selectionColorPanel.setOpaque(false);
        this.selectionColorPanel.setLayout(new GridBagLayout());
        this.selectionColorCheckbox.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.selectionColorCheckbox.text"));
        this.selectionColorCheckbox.setToolTipText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.selectionColorCheckbox.toolTipText"));
        this.selectionColorCheckbox.setHorizontalAlignment(2);
        this.selectionColorCheckbox.setHorizontalTextPosition(2);
        this.selectionColorCheckbox.setMaximumSize(new Dimension(160, 18));
        this.selectionColorCheckbox.setMinimumSize(new Dimension(160, 18));
        this.selectionColorCheckbox.setPreferredSize(new Dimension(160, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.selectionColorPanel.add((Component)this.selectionColorCheckbox, gridBagConstraints);
        this.edgeInSelectionColorChooser.setMinimumSize(new Dimension(14, 14));
        this.edgeInSelectionColorChooser.setPreferredSize(new Dimension(14, 14));
        this.edgeInSelectionColorChooser.setToolTipText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.edgeInSelectionColorChooser.toolTipText"));
        GroupLayout edgeInSelectionColorChooserLayout = new GroupLayout((Container)this.edgeInSelectionColorChooser);
        this.edgeInSelectionColorChooser.setLayout((LayoutManager)edgeInSelectionColorChooserLayout);
        edgeInSelectionColorChooserLayout.setHorizontalGroup(edgeInSelectionColorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        edgeInSelectionColorChooserLayout.setVerticalGroup(edgeInSelectionColorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.selectionColorPanel.add((Component)this.edgeInSelectionColorChooser, gridBagConstraints);
        this.edgeOutSelectionColorChooser.setMinimumSize(new Dimension(14, 14));
        this.edgeOutSelectionColorChooser.setPreferredSize(new Dimension(14, 14));
        this.edgeOutSelectionColorChooser.setToolTipText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.edgeOutSelectionColorChooser.toolTipText"));
        GroupLayout edgeOutSelectionColorChooserLayout = new GroupLayout((Container)this.edgeOutSelectionColorChooser);
        this.edgeOutSelectionColorChooser.setLayout((LayoutManager)edgeOutSelectionColorChooserLayout);
        edgeOutSelectionColorChooserLayout.setHorizontalGroup(edgeOutSelectionColorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        edgeOutSelectionColorChooserLayout.setVerticalGroup(edgeOutSelectionColorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.selectionColorPanel.add((Component)this.edgeOutSelectionColorChooser, gridBagConstraints);
        this.edgeBothSelectionColorChooser.setMinimumSize(new Dimension(14, 14));
        this.edgeBothSelectionColorChooser.setPreferredSize(new Dimension(14, 14));
        this.edgeBothSelectionColorChooser.setToolTipText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.edgeBothSelectionColorChooser.toolTipText"));
        GroupLayout edgeBothSelectionColorChooserLayout = new GroupLayout((Container)this.edgeBothSelectionColorChooser);
        this.edgeBothSelectionColorChooser.setLayout((LayoutManager)edgeBothSelectionColorChooserLayout);
        edgeBothSelectionColorChooserLayout.setHorizontalGroup(edgeBothSelectionColorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        edgeBothSelectionColorChooserLayout.setVerticalGroup(edgeBothSelectionColorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.selectionColorPanel.add((Component)this.edgeBothSelectionColorChooser, gridBagConstraints);
        this.labelIn.setFont(new Font("Tahoma", 0, 10));
        this.labelIn.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.labelIn.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.selectionColorPanel.add((Component)this.labelIn, gridBagConstraints);
        this.labelOut.setFont(new Font("Tahoma", 0, 10));
        this.labelOut.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.labelOut.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 10, 0, 0);
        this.selectionColorPanel.add((Component)this.labelOut, gridBagConstraints);
        this.labelBoth.setFont(new Font("Tahoma", 0, 10));
        this.labelBoth.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.labelBoth.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.selectionColorPanel.add((Component)this.labelBoth, gridBagConstraints);
        this.scalePanel.setOpaque(false);
        this.scalePanel.setLayout(new GridBagLayout());
        this.labelScale.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.labelScale.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 2, 0);
        this.scalePanel.add((Component)this.labelScale, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.scalePanel.add((Component)this.scaleSlider, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelEdgeColor).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.edgeColorButton, -2, 24, -2)).addComponent(this.sourceNodeColorCheckbox)).addGap(28, 28, 28).addComponent(this.scalePanel, -2, 130, -2).addGap(18, 18, 18).addComponent(this.selectionColorPanel, -2, 176, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.showEdgesCheckbox))).addContainerGap(146, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addComponent(this.showEdgesCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelEdgeColor)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(32, 32, 32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.edgeColorButton, -2, 24, -2).addGap(13, 13, 13).addComponent(this.sourceNodeColorCheckbox)).addComponent(this.scalePanel, -1, 61, Short.MAX_VALUE).addComponent(this.selectionColorPanel, -1, 61, Short.MAX_VALUE)))).addContainerGap()));
    }
}

