/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.export;

import java.io.IOException;
import java.io.Writer;
import javax.swing.table.TableModel;
import org.netbeans.modules.profiler.snaptracer.TracerProgressObject;
import org.netbeans.modules.profiler.snaptracer.impl.export.Exporter;

final class XMLExporter
extends Exporter {
    private float step = 1.0f;
    private int lastStep = 0;

    XMLExporter() {
    }

    @Override
    protected int getSteps(TableModel tableModel) {
        int n = tableModel.getRowCount();
        if (n > 300) {
            this.step = 300.0f / (float)n;
            n = 300;
        }
        return n;
    }

    @Override
    protected void writeHeader(TableModel tableModel, String string, Writer writer, TracerProgressObject tracerProgressObject) throws IOException {
        XMLExporter.writeLine(writer, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        XMLExporter.writeLine(writer, "<ExportedView Name=\"" + string + "\">");
    }

    @Override
    protected void writeData(TableModel tableModel, String string, Writer writer, TracerProgressObject tracerProgressObject) throws IOException {
        int n;
        int n2 = tableModel.getColumnCount();
        int n3 = tableModel.getRowCount();
        XMLExporter.writeLine(writer, "  <TableData NumRows=\"" + n3 + "\" NumColumns=\"" + n2 + "\">");
        XMLExporter.writeLine(writer, "    <TableHeader>");
        for (n = 0; n < n2; ++n) {
            XMLExporter.writeLine(writer, "      <TableColumn>" + tableModel.getColumnName(n) + "</TableColumn>");
        }
        XMLExporter.writeLine(writer, "    </TableHeader>");
        XMLExporter.writeLine(writer, "    <TableBody>");
        for (n = 0; n < n3; ++n) {
            int n4;
            XMLExporter.writeLine(writer, "      <TableRow>");
            for (n4 = 0; n4 < n2; ++n4) {
                XMLExporter.writeLine(writer, "        <TableColumn>" + tableModel.getValueAt(n, n4) + "</TableColumn>");
            }
            XMLExporter.writeLine(writer, "      </TableRow>");
            if (tracerProgressObject.isFinished()) break;
            if (this.step == 1.0f) {
                tracerProgressObject.addStep();
                continue;
            }
            n4 = (int)((float)n * this.step);
            if (n4 <= this.lastStep) continue;
            tracerProgressObject.addStep();
            this.lastStep = n4;
        }
        XMLExporter.writeLine(writer, "    </TableBody>");
        XMLExporter.writeLine(writer, "  </TableData>");
    }

    @Override
    protected void writeFooter(TableModel tableModel, String string, Writer writer, TracerProgressObject tracerProgressObject) throws IOException {
        XMLExporter.writeLine(writer, "</ExportedView>");
    }
}

