/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.util.ArrayList;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.panels.FileSelectRootMethodsPanel;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public abstract class BaseSelectRootMethodsAction
extends NodeAction {
    public BaseSelectRootMethodsAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return Bundle.LBL_SelectRootMethodsAction();
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        return true;
    }

    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return;
        }
        final DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return;
        }
        new NBSwingWorker(){
            String className = null;
            Lookup.Provider project = null;
            ProfilingSettings[] projectSettings = null;

            protected void doInBackground() {
                this.className = BaseSelectRootMethodsAction.this.getFileClassName(JavaProfilerSource.createFrom((FileObject)dataObject.getPrimaryFile()));
                if (this.className != null) {
                    this.project = ProjectUtilities.getProject((FileObject)dataObject.getPrimaryFile());
                    this.projectSettings = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)this.project).getProfilingSettings();
                }
            }

            protected void done() {
                if (this.className != null) {
                    ArrayList<ProfilingSettings> arrayList = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings profilingSettings : this.projectSettings) {
                        if (!ProfilingSettings.isCPUSettings((int)profilingSettings.getProfilingType())) continue;
                        arrayList.add(profilingSettings);
                    }
                    ProfilingSettings profilingSettings = IDEUtils.selectSettings(16, arrayList.toArray(new ProfilingSettings[arrayList.size()]), null);
                    if (profilingSettings == null) {
                        return;
                    }
                    ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = FileSelectRootMethodsPanel.getDefault().getRootMethods(dataObject.getPrimaryFile(), profilingSettings.getInstrumentationRootMethods());
                    if (sourceCodeSelectionArray == null) {
                        return;
                    }
                    profilingSettings.addRootMethods(sourceCodeSelectionArray);
                    if (arrayList.contains(profilingSettings)) {
                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])this.projectSettings, (ProfilingSettings)profilingSettings, (Lookup.Provider)this.project);
                    } else {
                        ProfilingSettings[] profilingSettingsArray = new ProfilingSettings[this.projectSettings.length + 1];
                        System.arraycopy(this.projectSettings, 0, profilingSettingsArray, 0, this.projectSettings.length);
                        profilingSettingsArray[this.projectSettings.length] = profilingSettings;
                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])profilingSettingsArray, (ProfilingSettings)profilingSettings, (Lookup.Provider)this.project);
                    }
                } else {
                    ProfilerDialogs.displayError((String)Bundle.SelectRootMethodsAction_NoClassFoundMsg());
                }
            }
        }.execute();
    }

    protected abstract String getFileClassName(JavaProfilerSource var1);
}

