/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.OsmPrimitiveAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public abstract class AbstractRelationAction
extends AbstractAction
implements OsmPrimitiveAction {
    protected transient Collection<Relation> relations = Collections.emptySet();

    protected static final Collection<Relation> getRelations(Collection<? extends OsmPrimitive> primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return Collections.emptySet();
        }
        return new SubclassFilteredCollection(primitives, Relation.class::isInstance);
    }

    @Override
    public void setPrimitives(Collection<? extends OsmPrimitive> primitives) {
        this.relations = AbstractRelationAction.getRelations(primitives);
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
        this.setEnabled(!this.relations.isEmpty());
    }

    protected final boolean canDownload() {
        if (this.relations.isEmpty()) {
            return false;
        }
        DataSet ds = this.relations.iterator().next().getDataSet();
        return !Main.isOffline(OnlineResource.OSM_API) && ds != null && !ds.isLocked() && !DownloadPolicy.BLOCKED.equals((Object)ds.getDownloadPolicy());
    }
}

