/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DeletedStateConflictResolveCommand
extends ConflictResolveCommand {
    private final Conflict<? extends OsmPrimitive> conflict;
    private final MergeDecisionType decision;

    public DeletedStateConflictResolveCommand(Conflict<? extends OsmPrimitive> conflict, MergeDecisionType decision) {
        super(conflict.getMy().getDataSet());
        this.conflict = conflict;
        this.decision = decision;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Resolve conflicts in deleted state in {0}", this.conflict.getMy().getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (this.decision.equals((Object)MergeDecisionType.KEEP_MINE)) {
            if (this.conflict.getMy().isDeleted() || this.conflict.isMyDeleted()) {
                this.deleteMy();
            }
        } else if (this.decision.equals((Object)MergeDecisionType.KEEP_THEIR)) {
            if (this.conflict.getTheir().isDeleted()) {
                this.deleteMy();
            } else {
                this.conflict.getMy().setDeleted(false);
            }
        } else {
            throw new IllegalStateException(I18n.tr("Cannot resolve undecided conflict.", new Object[0]));
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    private void deleteMy() {
        Set<OsmPrimitive> referrers = this.getAffectedDataSet().unlinkReferencesToPrimitive(this.conflict.getMy());
        for (OsmPrimitive p : referrers) {
            if (p.isNew() || p.isDeleted()) continue;
            p.setModified(true);
        }
        this.conflict.getMy().setDeleted(true);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.conflict.getMy());
        modified.addAll(this.conflict.getMy().getReferrers());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.conflict, this.decision});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DeletedStateConflictResolveCommand that = (DeletedStateConflictResolveCommand)obj;
        return this.decision == that.decision && Objects.equals(this.conflict, that.conflict);
    }
}

