/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.widgets.DateEditorWithSlider;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class DateFilterPanel
extends JPanel {
    private final DateEditorWithSlider dateFrom = new DateEditorWithSlider(I18n.tr("From", new Object[0]));
    private final DateEditorWithSlider dateTo = new DateEditorWithSlider(I18n.tr("To", new Object[0]));
    private final JCheckBox noTimestampCb = new JCheckBox(I18n.tr("No timestamp", new Object[0]));
    private final transient GpxLayer layer;
    private transient ActionListener filterAppliedListener;
    private final String prefDate0;
    private final String prefDateMin;
    private final String prefDateMax;
    private final Timer t = new Timer(200, e -> this.applyFilter());

    public DateFilterPanel(GpxLayer layer, String preferencePrefix, boolean enabled) {
        super(new GridBagLayout());
        this.prefDate0 = preferencePrefix + ".showzerotimestamp";
        this.prefDateMin = preferencePrefix + ".mintime";
        this.prefDateMax = preferencePrefix + ".maxtime";
        this.layer = layer;
        Date[] bounds = layer.data.getMinMaxTimeForAllTracks();
        Date startTime = bounds.length == 0 ? Date.from(ZonedDateTime.of(2000, 1, 1, 0, 0, 0, 0, ZoneId.systemDefault()).toInstant()) : bounds[0];
        Date endTime = bounds.length == 0 ? new Date() : bounds[1];
        this.dateFrom.setDate(startTime);
        this.dateTo.setDate(endTime);
        this.dateFrom.setRange(startTime, endTime);
        this.dateTo.setRange(startTime, endTime);
        this.add((Component)this.noTimestampCb, GBC.std().grid(1, 1).insets(0, 0, 5, 0));
        this.add((Component)this.dateFrom, GBC.std().grid(2, 1).fill(2));
        this.add((Component)this.dateTo, GBC.eol().grid(3, 1).fill(2));
        this.setEnabled(enabled);
        ChangeListener changeListener = e -> {
            if (this.isEnabled()) {
                this.applyFilterWithDelay();
            }
        };
        this.dateFrom.addDateListener(changeListener);
        this.dateTo.addDateListener(changeListener);
        this.noTimestampCb.addChangeListener(changeListener);
    }

    public void applyFilterWithDelay() {
        if (this.t.isRunning()) {
            this.t.restart();
        } else {
            this.t.start();
        }
    }

    public void applyFilter() {
        this.t.stop();
        this.filterTracksByDate();
        if (this.filterAppliedListener != null) {
            this.filterAppliedListener.actionPerformed(null);
        }
    }

    public void saveInPrefs() {
        Config.getPref().putLong(this.prefDateMin, this.dateFrom.getDate().getTime());
        Config.getPref().putLong(this.prefDateMax, this.dateTo.getDate().getTime());
        Config.getPref().putBoolean(this.prefDate0, this.noTimestampCb.isSelected());
    }

    public void loadFromPrefs() {
        long t2;
        long t1 = Config.getPref().getLong(this.prefDateMin, 0L);
        if (t1 != 0L) {
            this.dateFrom.setDate(new Date(t1));
        }
        if ((t2 = Config.getPref().getLong(this.prefDateMax, 0L)) != 0L) {
            this.dateTo.setDate(new Date(t2));
        }
        this.noTimestampCb.setSelected(Config.getPref().getBoolean(this.prefDate0, false));
    }

    public void setFilterAppliedListener(ActionListener filterAppliedListener) {
        this.filterAppliedListener = filterAppliedListener;
    }

    private void filterTracksByDate() {
        Date from = this.dateFrom.getDate();
        Date to = this.dateTo.getDate();
        this.layer.filterTracksByDate(from, to, this.noTimestampCb.isSelected());
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }
}

