/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class ObjectProxyCache<T, A> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectProxyCache.class);
    private static final int DEFAULT_SEGMENTS = 16;
    private static final int DEFAULT_SEGMENT_SIZE = 8;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int MAX_CAPACITY = 0x40000000;
    private static final int MAX_SEGMENTS = 65536;
    private static final int VULTURE_RUN_FREQ_SECONDS = 5;
    private static int _nextId = 0;
    private final ReferenceType referenceType;
    private final Segment<T, A>[] segments;
    private final int segmentShift;
    private final int segmentMask;
    private Thread vulture;
    private final int id;

    private static synchronized int nextId() {
        return ++_nextId;
    }

    public ObjectProxyCache() {
        this(16, 8, ReferenceType.WEAK);
    }

    public ObjectProxyCache(ReferenceType refType) {
        this(16, 8, refType);
    }

    public ObjectProxyCache(int numSegments, int initialSegCapacity, ReferenceType refType) {
        int cap;
        int ssize;
        if (numSegments <= 0 || initialSegCapacity <= 0 || refType == null) {
            throw new IllegalArgumentException();
        }
        this.id = ObjectProxyCache.nextId();
        this.referenceType = refType;
        if (numSegments > 65536) {
            numSegments = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < numSegments; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 24 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialSegCapacity > 0x40000000) {
            initialSegCapacity = 0x40000000;
        }
        for (cap = 1; cap < initialSegCapacity; cap <<= 1) {
        }
        int i2 = ssize;
        while (--i2 >= 0) {
            this.segments[i2] = new Segment(cap, this);
        }
        try {
            this.vulture = new Thread("ObjectProxyCache " + this.id + " vulture"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        boolean dump2;
                        try {
                            1.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        boolean bl = dump2 = ObjectProxyCache.this.size() > 200;
                        if (dump2) {
                            LOG.debug("***Vulture {} waking, stats:", ObjectProxyCache.this.id);
                            LOG.debug(ObjectProxyCache.this.stats(), new Object[0]);
                        }
                        int i2 = ObjectProxyCache.this.segments.length;
                        while (--i2 >= 0) {
                            Segment seg = ObjectProxyCache.this.segments[i2];
                            seg.lock();
                            try {
                                seg.expunge();
                            }
                            finally {
                                seg.unlock();
                            }
                            1.yield();
                        }
                        if (!dump2) continue;
                        LOG.debug("***Vulture {} sleeping, stats:", ObjectProxyCache.this.id);
                        LOG.debug(ObjectProxyCache.this.stats(), new Object[0]);
                    }
                }
            };
            this.vulture.setDaemon(true);
        }
        catch (SecurityException e) {
            this.vulture = null;
        }
    }

    public abstract T allocateProxy(Object var1, A var2);

    public T get(Object javaObject) {
        if (javaObject == null) {
            return null;
        }
        int hash2 = ObjectProxyCache.hash(javaObject);
        return this.segmentFor(hash2).get(javaObject, hash2);
    }

    public T getOrCreate(Object javaObject, A allocator) {
        if (javaObject == null || allocator == null) {
            return null;
        }
        int hash2 = ObjectProxyCache.hash(javaObject);
        return this.segmentFor(hash2).getOrCreate(javaObject, hash2, allocator);
    }

    public void put(Object javaObject, T proxy2) {
        if (javaObject == null || proxy2 == null) {
            return;
        }
        int hash2 = ObjectProxyCache.hash(javaObject);
        this.segmentFor(hash2).put(javaObject, hash2, proxy2);
    }

    private static int hash(Object javaObject) {
        int h = System.identityHashCode(javaObject);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private Segment<T, A> segmentFor(int hash2) {
        return this.segments[hash2 >>> this.segmentShift & this.segmentMask];
    }

    public int size() {
        int size2 = 0;
        for (Segment<T, A> seg : this.segments) {
            size2 += seg.tableSize;
        }
        return size2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stats() {
        StringBuilder b2 = new StringBuilder();
        int n = 0;
        int size2 = 0;
        int alloc = 0;
        b2.append("Segments: ").append(this.segments.length).append("\n");
        for (Segment<T, A> seg : this.segments) {
            int ssize = 0;
            int salloc = 0;
            seg.lock();
            try {
                ssize = ((Segment)seg).count();
                salloc = seg.entryTable.length;
            }
            finally {
                seg.unlock();
            }
            size2 += ssize;
            alloc += salloc;
            b2.append("seg[").append(n++).append("]:  size: ").append(ssize).append("  alloc: ").append(salloc).append("\n");
        }
        b2.append("Total: size: ").append(size2).append("  alloc: ").append(alloc).append("\n");
        return b2.toString();
    }

    static class Segment<T, A>
    extends ReentrantLock {
        final ObjectProxyCache<T, A> cache;
        final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
        volatile Entry<T>[] entryTable;
        int tableSize;
        int threshold;

        Segment(int capacity, ObjectProxyCache<T, A> cache) {
            this.threshold = (int)((float)capacity * 0.75f);
            this.entryTable = Entry.newArray(capacity);
            this.cache = cache;
        }

        private void expunge() {
            EntryRef ref;
            Entry<T>[] table = this.entryTable;
            ReferenceQueue<Object> queue = this.referenceQueue;
            block0: while ((ref = (EntryRef)((Object)queue.poll())) != null) {
                int hash2 = ref.hash();
                Entry<T> e = table[hash2 & table.length - 1];
                while (e != null) {
                    if (hash2 == e.hash && (ref == e.objectRef || ref == e.proxyRef)) {
                        this.remove(table, hash2, e);
                        continue block0;
                    }
                    e = e.next;
                }
            }
        }

        private void remove(Entry<T>[] table, int hash2, Entry<T> e) {
            Entry<T> first2;
            int index2 = hash2 & table.length - 1;
            Entry<T> n = first2 = table[index2];
            while (n != null) {
                if (n == e) {
                    Entry newFirst = n.next;
                    Entry<T> p2 = first2;
                    while (p2 != n) {
                        newFirst = new Entry(p2.objectRef, p2.hash, p2.proxyRef, newFirst);
                        p2 = p2.next;
                    }
                    table[index2] = newFirst;
                    --this.tableSize;
                    this.entryTable = table;
                    return;
                }
                n = n.next;
            }
        }

        private int count() {
            int count2 = 0;
            for (Entry<T> e : this.entryTable) {
                while (e != null) {
                    ++count2;
                    e = e.next;
                }
            }
            return count2;
        }

        private Entry<T>[] rehash() {
            assert (this.tableSize == this.count()) : "tableSize " + this.tableSize + " != count() " + this.count();
            Entry<T>[] oldTable = this.entryTable;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return oldTable;
            }
            int newCapacity = oldCapacity << 1;
            int sizeMask = newCapacity - 1;
            this.threshold = (int)((float)newCapacity * 0.75f);
            Entry<T>[] newTable = Entry.newArray(newCapacity);
            int i2 = oldCapacity;
            while (--i2 >= 0) {
                int k;
                Entry<T> e = oldTable[i2];
                if (e == null) continue;
                int idx = e.hash & sizeMask;
                Entry next2 = e.next;
                if (next2 == null) {
                    newTable[idx] = e;
                    continue;
                }
                int lastIdx = idx;
                Entry<T> lastRun = e;
                Entry last2 = next2;
                while (last2 != null) {
                    k = last2.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last2;
                    }
                    last2 = last2.next;
                }
                newTable[lastIdx] = lastRun;
                Entry<T> p2 = e;
                while (p2 != lastRun) {
                    k = p2.hash & sizeMask;
                    Entry m = new Entry(p2.objectRef, p2.hash, p2.proxyRef, newTable[k]);
                    newTable[k] = m;
                    p2 = p2.next;
                }
            }
            this.entryTable = newTable;
            return newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(Object object, int hash2, T proxy2) {
            this.lock();
            try {
                this.expunge();
                int potentialNewSize = this.tableSize + 1;
                Entry<T>[] table = potentialNewSize > this.threshold ? this.rehash() : this.entryTable;
                int index2 = hash2 & table.length - 1;
                Entry<T> e = table[index2];
                while (e != null) {
                    if (hash2 == e.hash && object == e.objectRef.get()) {
                        if (proxy2 == e.proxyRef.get()) {
                            return;
                        }
                        this.remove(table, hash2, e);
                        --potentialNewSize;
                        break;
                    }
                    e = e.next;
                }
                table[index2] = e = new Entry<T>(object, hash2, proxy2, ((ObjectProxyCache)this.cache).referenceType, table[index2], this.referenceQueue);
                this.tableSize = potentialNewSize;
                this.entryTable = table;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T getOrCreate(Object object, int hash2, A allocator) {
            Object proxy2;
            Entry<T>[] table = this.entryTable;
            Entry<T> e = this.entryTable[hash2 & table.length - 1];
            while (e != null) {
                if (hash2 == e.hash && object == e.objectRef.get()) {
                    proxy2 = e.proxyRef.get();
                    if (proxy2 == null) break;
                    return proxy2;
                }
                e = e.next;
            }
            this.lock();
            try {
                this.expunge();
                int potentialNewSize = this.tableSize + 1;
                table = potentialNewSize > this.threshold ? this.rehash() : this.entryTable;
                int index2 = hash2 & table.length - 1;
                Entry<T> e2 = table[index2];
                while (e2 != null) {
                    if (hash2 == e2.hash && object == e2.objectRef.get()) {
                        proxy2 = e2.proxyRef.get();
                        if (proxy2 != null) {
                            Object t = proxy2;
                            return t;
                        }
                        this.remove(table, hash2, e2);
                        --potentialNewSize;
                        break;
                    }
                    e2 = e2.next;
                }
                proxy2 = this.cache.allocateProxy(object, allocator);
                table[index2] = e2 = new Entry(object, hash2, proxy2, ((ObjectProxyCache)this.cache).referenceType, table[index2], this.referenceQueue);
                this.tableSize = potentialNewSize;
                this.entryTable = table;
                Object t = proxy2;
                return t;
            }
            finally {
                this.unlock();
            }
        }

        T get(Object object, int hash2) {
            Entry<T>[] table = this.entryTable;
            Entry<T> e = this.entryTable[hash2 & table.length - 1];
            while (e != null) {
                if (hash2 == e.hash && object == e.objectRef.get()) {
                    return e.proxyRef.get();
                }
                e = e.next;
            }
            return null;
        }

        static final <T, A> Segment<T, A>[] newArray(int size2) {
            return new Segment[size2];
        }
    }

    static class Entry<T> {
        final EntryRef<Object> objectRef;
        final int hash;
        final EntryRef<T> proxyRef;
        final Entry<T> next;

        Entry(Object object, int hash2, T proxy2, ReferenceType type2, Entry<T> next2, ReferenceQueue<Object> queue) {
            this.hash = hash2;
            this.next = next2;
            if (type2 == ReferenceType.WEAK) {
                this.objectRef = new WeakEntryRef<Object>(hash2, object, queue);
                this.proxyRef = new WeakEntryRef<T>(hash2, proxy2, queue);
            } else {
                this.objectRef = new SoftEntryRef<Object>(hash2, object, queue);
                this.proxyRef = new SoftEntryRef<T>(hash2, proxy2, queue);
            }
        }

        Entry(EntryRef<Object> objectRef, int hash2, EntryRef<T> proxyRef, Entry<T> next2) {
            this.objectRef = objectRef;
            this.hash = hash2;
            this.proxyRef = proxyRef;
            this.next = next2;
        }

        static final <T> Entry<T>[] newArray(int size2) {
            return new Entry[size2];
        }
    }

    private static final class SoftEntryRef<T>
    extends SoftReference<T>
    implements EntryRef<T> {
        final int hash;

        SoftEntryRef(int hash2, T rawObject, ReferenceQueue<Object> queue) {
            super(rawObject, queue);
            this.hash = hash2;
        }

        @Override
        public int hash() {
            return this.hash;
        }
    }

    private static final class WeakEntryRef<T>
    extends WeakReference<T>
    implements EntryRef<T> {
        final int hash;

        WeakEntryRef(int hash2, T rawObject, ReferenceQueue<Object> queue) {
            super(rawObject, queue);
            this.hash = hash2;
        }

        @Override
        public int hash() {
            return this.hash;
        }
    }

    private static interface EntryRef<T> {
        public T get();

        public int hash();
    }

    public static enum ReferenceType {
        WEAK,
        SOFT;

    }
}

