/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview.attributeview;

import freemind.modes.attributes.Attribute;
import freemind.view.mindmapview.attributeview.AttributeTableModelDecoratorAdapter;
import freemind.view.mindmapview.attributeview.AttributeView;
import javax.swing.event.ChangeEvent;

class ExtendedAttributeTableModelDecorator
extends AttributeTableModelDecoratorAdapter {
    int newRow = Integer.MAX_VALUE;
    private static final int AFTER_LAST_ROW = Integer.MAX_VALUE;

    public ExtendedAttributeTableModelDecorator(AttributeView attrView) {
        super(attrView);
    }

    @Override
    public int getRowCount() {
        if (this.newRow == Integer.MAX_VALUE) {
            return this.nodeAttributeModel.getRowCount();
        }
        return this.nodeAttributeModel.getRowCount() + 1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < this.newRow) {
            return this.nodeAttributeModel.getValueAt(row, col);
        }
        if (row == this.newRow) {
            return "";
        }
        return this.nodeAttributeModel.getValueAt(row - 1, col);
    }

    public void insertRow(int index) {
        this.newRow = index;
        this.fireTableRowsInserted(index, index);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (row != this.newRow) {
            int rowInModel = row < this.newRow ? row : row - 1;
            return this.nodeAttributeModel.isCellEditable(rowInModel, col);
        }
        return col == 0;
    }

    public Object removeRow(int index) {
        return this.nodeAttributeModel.removeRow(index);
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        if (row != this.newRow) {
            if (col == 1 || o.toString().length() > 0) {
                int rowInModel = row < this.newRow ? row : row - 1;
                this.nodeAttributeModel.setValueAt(o, rowInModel, col);
            }
            return;
        }
        this.newRow = Integer.MAX_VALUE;
        this.fireTableRowsDeleted(row, row);
        if (col == 0 && o != null && o.toString().length() > 0) {
            this.nodeAttributeModel.insertRow(row, o.toString(), "");
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireTableDataChanged();
    }

    @Override
    public void editingCanceled() {
        if (this.newRow != Integer.MAX_VALUE) {
            int row = this.newRow;
            this.newRow = Integer.MAX_VALUE;
            this.fireTableRowsDeleted(row, row);
        }
    }

    @Override
    public boolean areAttributesVisible() {
        return this.getRowCount() != 0;
    }

    public void moveRowUp(int row) {
        Attribute attribute = (Attribute)this.nodeAttributeModel.removeRow(row);
        this.nodeAttributeModel.insertRow(row - 1, attribute.getName(), attribute.getValue());
    }

    public void moveRowDown(int row) {
        Attribute attribute = (Attribute)this.nodeAttributeModel.removeRow(row);
        this.nodeAttributeModel.insertRow(row + 1, attribute.getName(), attribute.getValue());
    }
}

