/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.io;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Serializable;
import java.net.URI;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.model.IOListenerManager;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.io.AutoMappedRepositoryIRIMapper;
import org.protege.editor.owl.model.io.ProgressDialogOntologyLoaderListener;
import org.protege.editor.owl.model.io.UserResolvedIRIMapper;
import org.protege.editor.owl.model.io.WebConnectionIRIMapper;
import org.protege.editor.owl.ui.util.ProgressDialog;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.parameters.OntologyCopy;
import org.semanticweb.owlapi.util.PriorityCollection;
import org.semanticweb.owlapi.util.SimpleIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyLoader {
    private final Logger logger = LoggerFactory.getLogger(OntologyLoader.class);
    private final OWLModelManager modelManager;
    private final UserResolvedIRIMapper userResolvedIRIMapper;
    private final ProgressDialog dlg = new ProgressDialog();
    private final ListeningExecutorService ontologyLoadingService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());

    public OntologyLoader(OWLModelManager modelManager, UserResolvedIRIMapper userResolvedIRIMapper) {
        this.modelManager = modelManager;
        this.userResolvedIRIMapper = userResolvedIRIMapper;
    }

    public Optional<OWLOntology> loadOntology(URI documentUri) throws OWLOntologyCreationException {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("The ontology loader must be called from the Event Dispatch Thread");
        }
        return this.loadOntologyInOtherThread(documentUri);
    }

    private Optional<OWLOntology> loadOntologyInOtherThread(URI uri) throws OWLOntologyCreationException {
        ListenableFuture result = this.ontologyLoadingService.submit(() -> {
            try {
                Optional<OWLOntology> optional = this.loadOntologyInternal(uri);
                return optional;
            }
            finally {
                this.dlg.setVisible(false);
            }
        });
        this.dlg.setVisible(true);
        try {
            return (Optional)result.get();
        }
        catch (InterruptedException e) {
            return Optional.empty();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof OWLOntologyCreationException) {
                throw (OWLOntologyCreationException)e.getCause();
            }
            this.logger.error("An error occurred whilst loading the ontology at {}. Cause: {}", (Object)e.getCause().getMessage());
            return Optional.empty();
        }
    }

    private OWLOntologyManager getOntologyManager() {
        return this.modelManager.getOWLOntologyManager();
    }

    private Optional<OWLOntology> loadOntologyInternal(URI documentURI) throws OWLOntologyCreationException {
        OWLOntologyManager loadingManager = OWLManager.createConcurrentOWLOntologyManager();
        PriorityCollection iriMappers = loadingManager.getIRIMappers();
        iriMappers.clear();
        iriMappers.add((Serializable[])new OWLOntologyIRIMapper[]{this.userResolvedIRIMapper});
        iriMappers.add((Serializable[])new OWLOntologyIRIMapper[]{new WebConnectionIRIMapper()});
        iriMappers.add((Serializable[])new OWLOntologyIRIMapper[]{new AutoMappedRepositoryIRIMapper(this.modelManager.getOntologyCatalogManager())});
        loadingManager.addOntologyLoaderListener((OWLOntologyLoaderListener)new ProgressDialogOntologyLoaderListener(this.dlg, this.logger));
        OWLOntologyLoaderConfiguration configuration = new OWLOntologyLoaderConfiguration();
        configuration = configuration.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
        IRIDocumentSource documentSource = new IRIDocumentSource(IRI.create((URI)documentURI));
        OWLOntology ontology = loadingManager.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)documentSource, configuration);
        HashSet<OWLOntology> alreadyLoadedOntologies = new HashSet<OWLOntology>();
        for (OWLOntology loadedOntology : loadingManager.getOntologies()) {
            if (!this.modelManager.getOntologies().contains(loadedOntology)) {
                OWLOntologyManager modelManager = this.getOntologyManager();
                this.fireBeforeLoad(loadedOntology, documentURI);
                modelManager.copyOntology(loadedOntology, OntologyCopy.MOVE);
                this.fireAfterLoad(loadedOntology, documentURI);
                continue;
            }
            alreadyLoadedOntologies.add(loadedOntology);
        }
        if (!alreadyLoadedOntologies.isEmpty()) {
            this.displayOntologiesAlreadyLoadedMessage(alreadyLoadedOntologies);
        }
        this.modelManager.setActiveOntology(ontology);
        this.modelManager.fireEvent(EventType.ONTOLOGY_LOADED);
        OWLOntologyID id = ontology.getOntologyID();
        if (!id.isAnonymous()) {
            this.getOntologyManager().getIRIMappers().add((Serializable[])new OWLOntologyIRIMapper[]{new SimpleIRIMapper((IRI)id.getDefaultDocumentIRI().get(), IRI.create((URI)documentURI))});
        }
        return Optional.of(ontology);
    }

    private void displayOntologiesAlreadyLoadedMessage(Set<OWLOntology> alreadyLoadedOntologies) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        sb.append("The following ontologies are already loaded in this workspace<br><br>");
        for (OWLOntology alreadyLoadedOntology : alreadyLoadedOntologies) {
            String ren = this.modelManager.getRendering((OWLObject)alreadyLoadedOntology);
            sb.append("<b>");
            sb.append(ren);
            sb.append("</b><br>");
        }
        sb.append("<br>");
        sb.append("They have not been replaced/overwritten");
        sb.append("</body></html>");
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, sb.toString(), "Workspace already contains loaded ontologies", 2));
    }

    private void fireBeforeLoad(OWLOntology loadedOntology, URI documentURI) {
        if (this.modelManager instanceof IOListenerManager) {
            ((IOListenerManager)((Object)this.modelManager)).fireAfterLoadEvent(loadedOntology.getOntologyID(), documentURI);
        }
    }

    private void fireAfterLoad(OWLOntology loadedOntology, URI documentURI) {
        if (this.modelManager instanceof IOListenerManager) {
            ((IOListenerManager)((Object)this.modelManager)).fireAfterLoadEvent(loadedOntology.getOntologyID(), documentURI);
        }
    }
}

