/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Utils;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class ArrayMapField
extends JTable {
    private final int _vectorSize;
    private DefaultTableModel _model;
    private Vector<String> _columnNames;
    private boolean _editable = false;
    private boolean _substituteKey;
    private Editor _editor;

    public ArrayMapField(Editor editor, boolean substituteKey, String ... columns) {
        this._editor = editor;
        this._substituteKey = substituteKey;
        this._vectorSize = columns.length;
        this._columnNames = new Vector(this._vectorSize);
        for (String name : columns) {
            this._columnNames.add(name);
        }
        assert (this._vectorSize > 2);
        int fontSize = this.getFont().getSize();
        int minRowHeight = fontSize + fontSize / 3;
        if (this.rowHeight < minRowHeight) {
            this.setRowHeight(minRowHeight);
        }
        AbstractAction deleteRow = new AbstractAction("Delete selected row(s)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ArrayMapField.this._editable) {
                    int selectedRow;
                    if (ArrayMapField.this.isEditing()) {
                        ArrayMapField.this.getCellEditor().stopCellEditing();
                    }
                    while ((selectedRow = ArrayMapField.this.getSelectedRow()) != -1) {
                        ArrayMapField.this._model.removeRow(selectedRow);
                    }
                }
            }
        };
        this.getActionMap().put("delete", deleteRow);
        this.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
    }

    public void set(Map<String, String[]> map, Utils.Resolver resolver, boolean editable) {
        this._editable = editable;
        assert (this._vectorSize > 2);
        Vector vector = new Vector(map.size());
        for (Map.Entry<String, String[]> p : map.entrySet()) {
            Vector<String> row = new Vector<String>(this._vectorSize);
            if (this._substituteKey) {
                row.add(Utils.substitute(p.getKey(), resolver));
            } else {
                row.add(p.getKey());
            }
            for (String val : p.getValue()) {
                row.add(Utils.substitute(val, resolver));
            }
            vector.add(row);
        }
        if (this._editable) {
            Vector<String> newRow = new Vector<String>(this._vectorSize);
            for (int i = 0; i < this._vectorSize; ++i) {
                newRow.add("");
            }
            vector.add(newRow);
        }
        this._model = new DefaultTableModel(vector, this._columnNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return ArrayMapField.this._editable;
            }
        };
        this._model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (ArrayMapField.this._editable) {
                    Object lastKey = ArrayMapField.this._model.getValueAt(ArrayMapField.this._model.getRowCount() - 1, 0);
                    if (lastKey != null && !lastKey.equals("")) {
                        Object[] emptyRow = new Object[ArrayMapField.this._vectorSize];
                        for (int i = 0; i < ArrayMapField.this._vectorSize; ++i) {
                            emptyRow[i] = "";
                        }
                        ArrayMapField.this._model.addRow(emptyRow);
                    }
                    ArrayMapField.this._editor.updated();
                }
            }
        });
        this.setModel(this._model);
        this.setCellSelectionEnabled(this._editable);
        this.setOpaque(this._editable);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(this._editable);
    }

    public TreeMap<String, String[]> get() {
        assert (this._editable);
        assert (this._vectorSize > 2);
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        Vector<Vector> vector = this._model.getDataVector();
        TreeMap<String, String[]> result = new TreeMap<String, String[]>();
        for (Vector row : vector) {
            String key = (String)row.elementAt(0);
            if (key == null || (key = key.trim()).equals("")) continue;
            String[] val = new String[this._vectorSize - 1];
            for (int i = 1; i < this._vectorSize; ++i) {
                val[i - 1] = (String)row.elementAt(i);
                if (val[i - 1] != null) continue;
                val[i - 1] = "";
            }
            result.put(key, val);
        }
        return result;
    }
}

