#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: idris
version: 1.2.0
id: idris-1.2.0-IYQBlRf4cwhILdXAkJiXmo
key: idris-1.2.0-IYQBlRf4cwhILdXAkJiXmo
license: BSD3
maintainer: Edwin Brady <eb@cs.st-andrews.ac.uk>
stability: Beta
homepage: http://www.idris-lang.org/
synopsis: Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <http://www.idris-lang.org/documentation>.
    Features include:
    .
    * Full, first class, dependent types with dependent pattern matching
    .
    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings
    .
    * Interfaces (similar to type classes), monad comprehensions
    .
    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs
    .
    * Totality checking
    .
    * Coinductive types
    .
    * Indentation significant syntax, extensible syntax
    .
    * Cumulative universes
    .
    * Simple foreign function interface (to C)
    .
    * Hugs style interactive environment
category: Compilers/Interpreters, Dependent Types
author: Edwin Brady
exposed: True
indefinite: False
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System
hidden-modules: Util.Pretty Util.Net Paths_idris Version_idris
                Tools_idris
abi: b079f27e14e142a383f8a379dc621e6c
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/idris-1.2.0
library-dirs: /usr/lib/ghc-8.2.2/site-local/idris-1.2.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/idris
hs-libraries: HSidris-1.2.0-IYQBlRf4cwhILdXAkJiXmo
extra-libraries:
    gmp
depends:
    base-4.10.1.0 aeson-1.2.4.0-IxpmF2XxtfM2bzjPAR2gMF
    annotated-wl-pprint-0.7.0-8APeXc1MGYdCeWTvpg0wB3
    ansi-terminal-0.7.1.1-G9WTxmkEIHS8T5XM1ZnzRT
    ansi-wl-pprint-0.6.8.2-7yGyojXGz04K9UP4nqZeWn array-0.5.2.0
    base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be binary-0.8.5.1
    blaze-html-0.9.0.1-LSl5YsnAOxGGQxRTreTaG0
    blaze-markup-0.8.2.1-EXmhw0576TBGsUq0laKKM2 bytestring-0.10.8.2
    cheapskate-0.1.1-1zW0P7tmQjmKYmOGz5lzf8
    code-page-0.1.3-IgAXwLwH8aZ3hxp3qvXSZY containers-0.5.10.2
    deepseq-1.4.3.0 directory-1.3.0.2 filepath-1.4.1.2
    fingertree-0.1.3.1-F9ScKsAdn1n6OkakzqLTRD haskeline-0.7.4.0
    ieee754-0.8.0-B9FdsnFZjDO5G55ttUSqU0
    megaparsec-6.4.1-1B4BJpnciCf7JxJ5BUJb6O
    mtl-2.2.2-8XubxMJDT8QLsstvlNotkc
    network-2.6.3.5-BVJHDRdh5LJ4pgucNKJkuJ
    optparse-applicative-0.14.2.0-4EjMcggDo0Z7yLeV5c5OSC pretty-1.1.3.3
    process-1.6.1.0 regex-tdfa-1.2.3-CHlPHhA7z5QKh4VX6QrcGf
    safe-0.3.15-EroU33EYnr02fGSZYGiX97
    split-0.2.3.3-BN2ylJ9hXZBIaY8HiUVge7
    terminal-size-0.3.2.1-Hhm9bf6iOprEc6nFG30gJq
    text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz time-1.8.0.2
    transformers-0.5.2.0 uniplate-1.6.12-By8lBp5iSPwHN1UdSjtyhe
    unordered-containers-0.2.9.0-AIQ8bV884oMFcq0To2pA1G
    utf8-string-1.0.1.1-7sQ7eR5H5ED7poickls5aO
    vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA
    vector-binary-instances-0.2.4-9GLvtLCFX6MFM1VnkZHO1y
    zip-archive-0.3.2.4-1FiEK2C8QoDBrVcZXFgSdU
    fsnotify-0.2.1.1-I7K4if6wM4qFJ1D5dNxZZa
    async-2.1.1.1-8ROwjo1yVqvF3cWHtq6DEd unix-2.7.2.2
    libffi-0.1-9BCKWMADPWqE9LZxtKazhb
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             aeson-1.2.4.0-IxpmF2XxtfM2bzjPAR2gMF=117e2ccb320a02562b7dab8dac8cab03
             annotated-wl-pprint-0.7.0-8APeXc1MGYdCeWTvpg0wB3=35fd3aae23b03330e6bc1f380b51de35
             ansi-terminal-0.7.1.1-G9WTxmkEIHS8T5XM1ZnzRT=0aa3d84ed37feddcfc4971478d436776
             ansi-wl-pprint-0.6.8.2-7yGyojXGz04K9UP4nqZeWn=aaa526befd51a63f6a2b80e6ced721af
             array-0.5.2.0=567646df31883e5d21d17233cc6e3caf
             base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be=fd5db0dc9688093c1ac2c3223371478e
             binary-0.8.5.1=33c677d3ced9a5afbc7b354509494653
             blaze-html-0.9.0.1-LSl5YsnAOxGGQxRTreTaG0=49a468374da15ee6981f2dc0c5ca6996
             blaze-markup-0.8.2.1-EXmhw0576TBGsUq0laKKM2=2957175f80d486950ba665dd719601e4
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             cheapskate-0.1.1-1zW0P7tmQjmKYmOGz5lzf8=f38cbd31f0a9407be42744613421c106
             code-page-0.1.3-IgAXwLwH8aZ3hxp3qvXSZY=684b55603f33f30e7e939e28620d2579
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             fingertree-0.1.3.1-F9ScKsAdn1n6OkakzqLTRD=d7351ce314efe14eb0244de484921c11
             haskeline-0.7.4.0=1141a9f24dba7d57fb2023df1fd20c51
             ieee754-0.8.0-B9FdsnFZjDO5G55ttUSqU0=b8bb49b8cfa609e010a6613d88ba1169
             megaparsec-6.4.1-1B4BJpnciCf7JxJ5BUJb6O=f29a1e1b2fbc0b6b4949e39e771ff041
             mtl-2.2.2-8XubxMJDT8QLsstvlNotkc=9d788b97813db77c2d48570ade6e04a9
             network-2.6.3.5-BVJHDRdh5LJ4pgucNKJkuJ=82fe21e10301e2e4d8701392ba21a740
             optparse-applicative-0.14.2.0-4EjMcggDo0Z7yLeV5c5OSC=1b28ef73138451f4af2701ae722f9a7c
             pretty-1.1.3.3=229bcf5342145ac1755207fe83d29780
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             regex-tdfa-1.2.3-CHlPHhA7z5QKh4VX6QrcGf=a83a97ef601ac09093211c7caba46a6b
             safe-0.3.15-EroU33EYnr02fGSZYGiX97=604c7b7c109a34b58d71795df287548a
             split-0.2.3.3-BN2ylJ9hXZBIaY8HiUVge7=b6b8499789ca23888d2f286cbdde6707
             terminal-size-0.3.2.1-Hhm9bf6iOprEc6nFG30gJq=174597e2a271e4c1c922655d8cb9e8c9
             text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz=29872508833c96394f0471371217bab0
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             uniplate-1.6.12-By8lBp5iSPwHN1UdSjtyhe=243b511ea6e7b49156b7e9f3cef198b3
             unordered-containers-0.2.9.0-AIQ8bV884oMFcq0To2pA1G=5c8877e146af6c27c44eb74d4cb22e80
             utf8-string-1.0.1.1-7sQ7eR5H5ED7poickls5aO=4a40da384793deade7b4b9c9224acdb7
             vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA=137c9db50bf637e10c6e6dd9e685ce59
             vector-binary-instances-0.2.4-9GLvtLCFX6MFM1VnkZHO1y=5033c8d46aed7f8dae765b399d10d471
             zip-archive-0.3.2.4-1FiEK2C8QoDBrVcZXFgSdU=f39c0255893d57bf82756d47e0ccf927
             fsnotify-0.2.1.1-I7K4if6wM4qFJ1D5dNxZZa=4b51b8f38397150f3791b0e2b688870a
             async-2.1.1.1-8ROwjo1yVqvF3cWHtq6DEd=987aeec331bd3d9d85b408736a8805c6
             unix-2.7.2.2=3df01ca0d7640dab598065ff1b1cffeb
             libffi-0.1-9BCKWMADPWqE9LZxtKazhb=d7755092063e29c6e776975d440c087c
haddock-interfaces: /usr/share/doc/idris/html/idris.haddock
haddock-html: /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

