/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Map;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M34;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.script.SV;

public class Escape {
    public static String escapeColor(int argb) {
        return argb == 0 ? null : "[x" + Escape.getHexColorFromRGB(argb) + "]";
    }

    public static String getHexColorFromRGB(int argb) {
        if (argb == 0) {
            return null;
        }
        String r = "00" + Integer.toHexString(argb >> 16 & 0xFF);
        r = r.substring(r.length() - 2);
        String g = "00" + Integer.toHexString(argb >> 8 & 0xFF);
        g = g.substring(g.length() - 2);
        String b = "00" + Integer.toHexString(argb & 0xFF);
        b = b.substring(b.length() - 2);
        return r + g + b;
    }

    public static String eP(T3 xyz) {
        if (xyz == null) {
            return "null";
        }
        return "{" + xyz.x + " " + xyz.y + " " + xyz.z + "}";
    }

    public static String matrixToScript(Object m) {
        return PT.replaceAllCharacters(m.toString(), "\n\r ", "").replace('\t', ' ');
    }

    public static String eP4(P4 x) {
        return "{" + x.x + " " + x.y + " " + x.z + " " + x.w + "}";
    }

    public static String drawQuat(Quat q, String prefix, String id, P3 ptCenter, float scale) {
        String strV = " VECTOR " + Escape.eP(ptCenter) + " ";
        if (scale == 0.0f) {
            scale = 1.0f;
        }
        return "draw " + prefix + "x" + id + strV + Escape.eP(q.getVectorScaled(0, scale)) + " color red\n" + "draw " + prefix + "y" + id + strV + Escape.eP(q.getVectorScaled(1, scale)) + " color green\n" + "draw " + prefix + "z" + id + strV + Escape.eP(q.getVectorScaled(2, scale)) + " color blue\n";
    }

    public static String e(Object x) {
        if (x == null) {
            return "null";
        }
        if (PT.isNonStringPrimitive(x)) {
            return x.toString();
        }
        if (x instanceof String) {
            return PT.esc((String)x);
        }
        if (x instanceof Lst) {
            return Escape.eV((Lst)x);
        }
        if (x instanceof Map) {
            return Escape.escapeMap((Map)x);
        }
        if (x instanceof BS) {
            return Escape.eBS((BS)x);
        }
        if (x instanceof P4) {
            return Escape.eP4((P4)x);
        }
        if (x instanceof T3) {
            return Escape.eP((T3)x);
        }
        if (AU.isAP(x)) {
            return Escape.eAP((T3[])x);
        }
        if (AU.isAS(x)) {
            return Escape.eAS((String[])x, true);
        }
        if (x instanceof M34) {
            return PT.rep(PT.rep(x.toString(), "[\n  ", "["), "] ]", "]]");
        }
        if (x instanceof A4) {
            A4 a = (A4)x;
            return "{" + a.x + " " + a.y + " " + a.z + " " + (float)((double)a.angle * 180.0 / Math.PI) + "}";
        }
        if (x instanceof Quat) {
            return ((Quat)x).toString();
        }
        String s = PT.nonArrayString(x);
        return s == null ? PT.toJSON(null, x) : s;
    }

    public static String eV(Lst<SV> list) {
        if (list == null) {
            return PT.esc("");
        }
        SB s = new SB();
        s.append("[");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(Escape.escapeNice(((SV)list.get(i)).asString()));
        }
        s.append("]");
        return s.toString();
    }

    public static String escapeMap(Map<String, Object> ht) {
        SB sb = new SB();
        sb.append("{ ");
        String sep = "";
        for (Map.Entry<String, Object> entry : ht.entrySet()) {
            String key = entry.getKey();
            sb.append(sep).append(PT.esc(key)).appendC(':');
            Object val = entry.getValue();
            if (!(val instanceof SV)) {
                val = SV.getVariable(val);
            }
            sb.append(((SV)val).escape());
            sep = ",";
        }
        sb.append(" }");
        return sb.toString();
    }

    public static String escapeFloatA(float[] f, boolean asArray) {
        if (asArray) {
            return PT.toJSON(null, f);
        }
        SB sb = new SB();
        for (int i = 0; i < f.length; ++i) {
            if (i > 0) {
                sb.appendC('\n');
            }
            sb.appendF(f[i]);
        }
        return sb.toString();
    }

    public static String escapeFloatAA(float[][] f, boolean addSemi) {
        SB sb = new SB();
        String eol = addSemi ? ";\n" : "\n";
        for (int i = 0; i < f.length; ++i) {
            if (f[i] == null) continue;
            if (i > 0) {
                sb.append(eol);
            }
            for (int j = 0; j < f[i].length; ++j) {
                sb.appendF(f[i][j]).appendC('\t');
            }
        }
        return sb.toString();
    }

    public static String escapeFloatAAA(float[][][] f, boolean addSemi) {
        String eol;
        SB sb = new SB();
        String string = eol = addSemi ? ";\n" : "\n";
        if (f[0] == null || f[0][0] == null) {
            return "0 0 0" + eol;
        }
        sb.appendI(f.length).append(" ").appendI(f[0].length).append(" ").appendI(f[0][0].length);
        for (int i = 0; i < f.length; ++i) {
            if (f[i] == null) continue;
            sb.append(eol);
            for (int j = 0; j < f[i].length; ++j) {
                if (f[i][j] == null) continue;
                sb.append(eol);
                for (int k = 0; k < f[i][j].length; ++k) {
                    sb.appendF(f[i][j][k]).appendC('\t');
                }
            }
        }
        return sb.toString();
    }

    public static String eAS(String[] list, boolean nicely) {
        if (list == null) {
            return PT.esc("");
        }
        SB s = new SB();
        s.append("[");
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(nicely ? Escape.escapeNice(list[i]) : PT.esc(list[i]));
        }
        s.append("]");
        return s.toString();
    }

    public static String eAI(int[] ilist) {
        if (ilist == null) {
            return PT.esc("");
        }
        SB s = new SB();
        s.append("[");
        for (int i = 0; i < ilist.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.appendI(ilist[i]);
        }
        return s.append("]").toString();
    }

    public static String eAD(double[] dlist) {
        if (dlist == null) {
            return PT.esc("");
        }
        SB s = new SB();
        s.append("[");
        for (int i = 0; i < dlist.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.appendD(dlist[i]);
        }
        return s.append("]").toString();
    }

    public static String eAF(float[] flist) {
        if (flist == null) {
            return PT.esc("");
        }
        SB s = new SB();
        s.append("[");
        for (int i = 0; i < flist.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.appendF(flist[i]);
        }
        return s.append("]").toString();
    }

    public static String eAP(T3[] plist) {
        if (plist == null) {
            return PT.esc("");
        }
        SB s = new SB();
        s.append("[");
        for (int i = 0; i < plist.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(Escape.eP(plist[i]));
        }
        return s.append("]").toString();
    }

    private static String escapeNice(String s) {
        if (s == null) {
            return "null";
        }
        float f = PT.parseFloatStrict(s);
        return Float.isNaN(f) ? PT.esc(s) : s;
    }

    public static Object uABsM(String s) {
        if (s.charAt(0) == '{') {
            return Escape.uP(s);
        }
        if ((Escape.isStringArray(s) || s.startsWith("[{") && s.indexOf("[{") == s.lastIndexOf("[{")) && s.indexOf(44) < 0 && s.indexOf(46) < 0 && s.indexOf(45) < 0) {
            return BS.unescape(s);
        }
        if (s.startsWith("[[")) {
            return Escape.unescapeMatrix(s);
        }
        return s;
    }

    public static boolean isStringArray(String s) {
        return s.startsWith("({") && s.lastIndexOf("({") == 0 && s.indexOf("})") == s.length() - 2;
    }

    public static Object uP(String strPoint) {
        int nPoints;
        if (strPoint == null || strPoint.length() == 0) {
            return strPoint;
        }
        String str = strPoint.replace('\n', ' ').trim();
        if (str.charAt(0) != '{' || str.charAt(str.length() - 1) != '}') {
            return strPoint;
        }
        float[] points = new float[5];
        str = str.substring(1, str.length() - 1);
        int[] next = new int[1];
        for (nPoints = 0; nPoints < 5; ++nPoints) {
            points[nPoints] = PT.parseFloatNext(str, next);
            if (!Float.isNaN(points[nPoints])) continue;
            if (next[0] >= str.length() || str.charAt(next[0]) != ',') break;
            next[0] = next[0] + 1;
            --nPoints;
        }
        if (nPoints == 3) {
            return P3.new3(points[0], points[1], points[2]);
        }
        if (nPoints == 4) {
            return P4.new4(points[0], points[1], points[2], points[3]);
        }
        return strPoint;
    }

    public static Object unescapeMatrix(String strMatrix) {
        int nPoints;
        if (strMatrix == null || strMatrix.length() == 0) {
            return strMatrix;
        }
        String str = strMatrix.replace('\n', ' ').trim();
        if (str.lastIndexOf("[[") != 0 || str.indexOf("]]") != str.length() - 2) {
            return strMatrix;
        }
        float[] points = new float[16];
        str = str.substring(2, str.length() - 2).replace('[', ' ').replace(']', ' ').replace(',', ' ');
        int[] next = new int[1];
        for (nPoints = 0; nPoints < 16; ++nPoints) {
            points[nPoints] = PT.parseFloatNext(str, next);
            if (Float.isNaN(points[nPoints])) break;
        }
        if (!Float.isNaN(PT.parseFloatNext(str, next))) {
            return strMatrix;
        }
        if (nPoints == 9) {
            return M3.newA9(points);
        }
        if (nPoints == 16) {
            return M4.newA16(points);
        }
        return strMatrix;
    }

    public static String eBS(BS bs) {
        return BS.escape(bs, '(', ')');
    }

    public static String eBond(BS bs) {
        return BS.escape(bs, '[', ']');
    }

    public static String toReadable(String name, Object info) {
        SB sb = new SB();
        String sep = "";
        if (info == null) {
            return "null";
        }
        if (PT.isNonStringPrimitive(info)) {
            return Escape.packageReadable(name, null, info.toString());
        }
        if (info instanceof String) {
            return Escape.packageReadable(name, null, PT.esc((String)info));
        }
        if (info instanceof SV) {
            return Escape.packageReadable(name, null, ((SV)info).escape());
        }
        if (AU.isAS(info)) {
            sb.append("[");
            int imax = ((String[])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(PT.esc(((String[])info)[i]));
                sep = ",";
            }
            sb.append("]");
            return Escape.packageReadableSb(name, "String[" + imax + "]", sb);
        }
        if (AU.isAI(info)) {
            sb.append("[");
            int imax = ((int[])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).appendI(((int[])info)[i]);
                sep = ",";
            }
            sb.append("]");
            return Escape.packageReadableSb(name, "int[" + imax + "]", sb);
        }
        if (AU.isAF(info)) {
            sb.append("[");
            int imax = ((float[])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).appendF(((float[])info)[i]);
                sep = ",";
            }
            sb.append("]");
            return Escape.packageReadableSb(name, "float[" + imax + "]", sb);
        }
        if (AU.isAD(info)) {
            sb.append("[");
            int imax = ((double[])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).appendD(((double[])info)[i]);
                sep = ",";
            }
            sb.append("]");
            return Escape.packageReadableSb(name, "double[" + imax + "]", sb);
        }
        if (AU.isAP(info)) {
            sb.append("[");
            int imax = ((T3[])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.eP(((T3[])info)[i]));
                sep = ",";
            }
            sb.append("]");
            return Escape.packageReadableSb(name, "point3f[" + imax + "]", sb);
        }
        if (AU.isASS(info)) {
            sb.append("[");
            int imax = ((String[][])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.toReadable(null, ((String[][])info)[i]));
                sep = ",\n";
            }
            sb.append("]");
            return Escape.packageReadableSb(name, "String[" + imax + "][]", sb);
        }
        if (AU.isAII(info)) {
            sb.append("[");
            int imax = ((int[][])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.toReadable(null, ((int[][])info)[i]));
                sep = ",";
            }
            sb.append("]");
            return Escape.packageReadableSb(name, "int[" + imax + "][]", sb);
        }
        if (AU.isAFF(info)) {
            sb.append("[\n");
            int imax = ((float[][])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.toReadable(null, ((float[][])info)[i]));
                sep = ",\n";
            }
            sb.append("]");
            return Escape.packageReadableSb(name, "float[][]", sb);
        }
        if (AU.isADD(info)) {
            sb.append("[\n");
            int imax = ((double[][])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.toReadable(null, ((double[][])info)[i]));
                sep = ",\n";
            }
            sb.append("]");
            return Escape.packageReadableSb(name, "double[][]", sb);
        }
        if (info instanceof Lst) {
            int imax = ((Lst)info).size();
            for (int i = 0; i < imax; ++i) {
                sb.append(Escape.toReadable(name + "[" + (i + 1) + "]", ((Lst)info).get(i)));
            }
            return Escape.packageReadableSb(name, "List[" + imax + "]", sb);
        }
        if (info instanceof M34 || info instanceof T3 || info instanceof P4 || info instanceof A4) {
            sb.append(Escape.e(info));
            return Escape.packageReadableSb(name, null, sb);
        }
        if (info instanceof Map) {
            for (String key : ((Map)info).keySet()) {
                sb.append(Escape.toReadable((name == null ? "" : name + ".") + key, ((Map)info).get(key)));
            }
            return sb.toString();
        }
        return Escape.packageReadable(name, null, PT.toJSON(null, info));
    }

    private static String packageReadableSb(String infoName, String infoType, SB sb) {
        return Escape.packageReadable(infoName, infoType, sb.toString());
    }

    private static String packageReadable(String infoName, String infoType, String info) {
        String s;
        String string = s = infoType == null ? "" : infoType + "\t";
        if (infoName == null) {
            return s + info;
        }
        return "\n" + infoName + "\t" + (infoType == null ? "" : "*" + infoType + "\t") + info;
    }

    public static String escapeModelFileNumber(int iv) {
        return "" + iv / 1000000 + "." + iv % 1000000;
    }

    public static String encapsulateData(String name, Object data, int depth) {
        String s;
        switch (depth) {
            case 1: {
                s = Escape.escapeFloatA((float[])data, false) + ";\n";
                break;
            }
            case 2: {
                s = Escape.escapeFloatAA((float[][])data, true) + ";\n";
                break;
            }
            case 3: {
                s = Escape.escapeFloatAAA((float[][][])data, true) + ";\n";
                break;
            }
            default: {
                s = data.toString();
            }
        }
        return "  DATA \"" + name + "\"\n" + s + "    END \"" + name + "\";\n";
    }

    public static String unescapeUnicode(String s) {
        int ichMax = s.length();
        SB sb = SB.newN(ichMax);
        int ich = 0;
        while (ich < ichMax) {
            char ch;
            if ((ch = s.charAt(ich++)) == '\\' && ich < ichMax) {
                ch = s.charAt(ich++);
                switch (ch) {
                    case 'u': {
                        char chT;
                        int hexit;
                        if (ich >= ichMax) break;
                        int unicode = 0;
                        int k = 4;
                        while (--k >= 0 && ich < ichMax && (hexit = Escape.getHexitValue(chT = s.charAt(ich))) >= 0) {
                            unicode <<= 4;
                            unicode += hexit;
                            ++ich;
                        }
                        ch = (char)unicode;
                    }
                }
            }
            sb.appendC(ch);
        }
        return sb.toString();
    }

    public static int getHexitValue(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return 10 + ch - 97;
        }
        if (ch >= 'A' && ch <= 'F') {
            return 10 + ch - 65;
        }
        return -1;
    }

    public static String[] unescapeStringArray(String data) {
        if (data == null || !data.startsWith("[") || !data.endsWith("]")) {
            return null;
        }
        Lst<String> v = new Lst<String>();
        int[] next = new int[]{1};
        while (next[0] < data.length()) {
            String s = PT.getQuotedStringNext(data, next);
            if (s == null) {
                return null;
            }
            v.addLast(PT.rep(s, "\\\"", "\""));
            while (next[0] < data.length() && data.charAt(next[0]) != '\"') {
                next[0] = next[0] + 1;
            }
        }
        return v.toArray(new String[v.size()]);
    }

    public static boolean isAV(Object x) {
        return x instanceof SV[];
    }

    public static Object escapeHelical(String id, int tokType, P3 a, P3 b, T3[] pts) {
        switch (tokType) {
            case 134217751: {
                return pts == null ? new P3() : pts[0];
            }
            case 1073741854: 
            case 1665140738: {
                return pts == null ? new V3() : pts[tokType == 1073741854 ? 1 : 2];
            }
            case 0x8000001: {
                return Float.valueOf(pts == null ? Float.NaN : pts[3].x);
            }
            case 135176: {
                return pts == null ? "" : "draw ID \"" + id + "\" VECTOR " + Escape.eP(pts[0]) + " " + Escape.eP(pts[1]) + " color " + (pts[3].x < 0.0f ? "{255.0 200.0 0.0}" : "{255.0 0.0 128.0}");
            }
            case 1745489939: {
                return (pts == null ? "" : "measure " + Escape.eP(a) + Escape.eP(pts[0]) + Escape.eP(pts[4])) + Escape.eP(b);
            }
        }
        return pts == null ? new T3[]{} : pts;
    }
}

