/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports.missing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.MissingImportHandler;
import org.protege.editor.owl.model.library.OntologyCatalogManager;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.XmlBaseContext;
import org.protege.xmlcatalog.entry.Entry;
import org.protege.xmlcatalog.entry.UriEntry;
import org.semanticweb.owlapi.model.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingImportHandlerUI
implements MissingImportHandler {
    private final Logger logger = LoggerFactory.getLogger(MissingImportHandlerUI.class);
    private final OWLEditorKit owlEditorKit;

    public MissingImportHandlerUI(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
    }

    public IRI getDocumentIRI(IRI ontologyIRI) {
        FutureTask<IRI> futureTask = new FutureTask<IRI>(() -> {
            int ret = JOptionPane.showConfirmDialog(null, "<html><body>The system couldn't locate the ontology:<br><font color=\"blue\">" + ontologyIRI.toString() + "</font><br><br>Would you like to attempt to resolve the missing import?</body></html>", "Resolve missing import?", 0, 2);
            if (ret != 0) {
                return null;
            }
            UIHelper helper = new UIHelper(this.owlEditorKit);
            File file = helper.chooseOWLFile("Please select an ontology file");
            if (file == null) {
                return ontologyIRI;
            }
            this.updateActiveCatalog(ontologyIRI, file);
            return IRI.create((File)file);
        });
        SwingUtilities.invokeLater(futureTask);
        try {
            return futureTask.get();
        }
        catch (InterruptedException e) {
            this.logger.debug("Resolve import task interrupted");
            return null;
        }
        catch (ExecutionException e) {
            this.logger.error("An exception was thrown whilst the user was resolving a missing import: {}", (Object)e.getCause().getMessage());
            return null;
        }
    }

    private void updateActiveCatalog(IRI ontologyIRI, File file) {
        OntologyCatalogManager catalogManager = this.owlEditorKit.getOWLModelManager().getOntologyCatalogManager();
        XMLCatalog activeCatalog = catalogManager.getActiveCatalog();
        if (activeCatalog == null) {
            return;
        }
        URI relativeFile = CatalogUtilities.relativize((URI)file.toURI(), (XmlBaseContext)activeCatalog);
        activeCatalog.addEntry(0, (Entry)new UriEntry("User Entered Import Resolution", (XmlBaseContext)activeCatalog, ontologyIRI.toString(), relativeFile, null));
        File catalogLocation = new File(activeCatalog.getXmlBaseContext().getXmlBase());
        try {
            CatalogUtilities.save((XMLCatalog)activeCatalog, (File)catalogLocation);
        }
        catch (IOException e) {
            this.logger.error("Could not save user supplied import redirection to catalog.", (Throwable)e);
        }
    }
}

