/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.attributeactors;

import freemind.controller.Controller;
import freemind.controller.MapModuleManager;
import freemind.controller.filter.util.SortedComboBoxModel;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.attributes.AttributeRegistry;
import freemind.modes.attributes.AttributeRegistryElement;
import freemind.view.MapModule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

class ImportAttributesDialog
extends JDialog
implements TreeSelectionListener {
    private JTree tree;
    private JScrollPane scrollPane;
    private DefaultMutableTreeNode topNode;
    private AttributeRegistry currentAttributes;
    MyRenderer renderer = null;
    private DefaultTreeModel treeModel;
    private Component parentComponent;
    private Controller c;

    public ImportAttributesDialog(Controller c, Component parentComponent) {
        super(c.getJFrame(), Resources.getInstance().getResourceString("attributes_import"), true);
        this.c = c;
        this.parentComponent = parentComponent;
        TreeNodeInfo nodeInfo = new TreeNodeInfo(Resources.getInstance().getResourceString("attribute_top"));
        this.topNode = new DefaultMutableTreeNode(nodeInfo);
        this.treeModel = new DefaultTreeModel(this.topNode);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.tree);
        this.scrollPane.setPreferredSize(new Dimension(600, 300));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        Box buttons = Box.createHorizontalBox();
        buttons.setBorder(new EmptyBorder(5, 5, 5, 5));
        JButton okBtn = new JButton();
        Tools.setLabelAndMnemonic(okBtn, Resources.getInstance().getResourceString("ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportAttributesDialog.this.performImport(ImportAttributesDialog.this.topNode);
                ImportAttributesDialog.this.dispose();
            }
        });
        JButton cancelBtn = new JButton();
        Tools.setLabelAndMnemonic(cancelBtn, Resources.getInstance().getResourceString("cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportAttributesDialog.this.dispose();
            }
        });
        buttons.add(Box.createHorizontalGlue());
        buttons.add(okBtn);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(cancelBtn);
        buttons.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)buttons, "South");
        Tools.addEscapeActionToDialog(this);
    }

    @Override
    public void show() {
        this.createMapSubTrees(this.topNode);
        if (this.topNode.getChildCount() == 0) {
            JOptionPane.showMessageDialog(this.parentComponent, Resources.getInstance().getResourceString("attributes_no_import_candidates_found"), this.getTitle(), 1);
            return;
        }
        this.treeModel.reload();
        if (this.renderer == null) {
            this.renderer = new MyRenderer();
        }
        this.tree.setCellRenderer(this.renderer);
        this.setLocationRelativeTo(this.parentComponent);
        this.pack();
        super.show();
    }

    private void performImport(DefaultMutableTreeNode node) {
        TreeNodeInfo info = (TreeNodeInfo)node.getUserObject();
        if (info.getSelected() == 2) {
            return;
        }
        String name = info.getInfo();
        boolean attributeNameRegistered = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (childNode.isLeaf()) {
                TreeNodeInfo childInfo;
                if (!attributeNameRegistered) {
                    attributeNameRegistered = true;
                    if (-1 == this.currentAttributes.indexOf(name)) {
                        this.currentAttributes.getAttributeController().performRegistryAttribute(name);
                        int index = this.currentAttributes.indexOf(name);
                        this.currentAttributes.getAttributeController().performSetRestriction(index, ((AttributeTreeNodeInfo)info).isRestricted());
                    }
                }
                if ((childInfo = (TreeNodeInfo)childNode.getUserObject()).getSelected() != 0) continue;
                String value = childInfo.getInfo();
                this.currentAttributes.getAttributeController().performRegistryAttributeValue(name, value);
                continue;
            }
            this.performImport(childNode);
        }
    }

    private void createMapSubTrees(DefaultMutableTreeNode top) {
        top.removeAllChildren();
        TreeNodeInfo topInfo = (TreeNodeInfo)top.getUserObject();
        topInfo.setSelected(2);
        MapModuleManager mapModuleManager = this.c.getMapModuleManager();
        MindMap currentMap = mapModuleManager.getMapModule().getModel();
        this.currentAttributes = currentMap.getRegistry().getAttributes();
        for (Map.Entry entry : mapModuleManager.getMapModules().entrySet()) {
            String nextmapName = entry.getKey().toString();
            MapModule nextMapModule = (MapModule)entry.getValue();
            MindMap nextMap = nextMapModule.getModel();
            if (nextMap == currentMap) continue;
            TreeNodeInfo treeNodeInfo = new TreeNodeInfo(nextmapName);
            DefaultMutableTreeNode mapInfo = new DefaultMutableTreeNode(treeNodeInfo);
            this.createAttributeSubTrees(mapInfo, nextMap.getRegistry().getAttributes());
            if (mapInfo.getChildCount() == 0) continue;
            top.add(mapInfo);
        }
    }

    private void createAttributeSubTrees(DefaultMutableTreeNode mapInfo, AttributeRegistry attributes) {
        for (int i = 0; i < attributes.size(); ++i) {
            AttributeRegistryElement element = attributes.getElement(i);
            AttributeTreeNodeInfo treeNodeInfo = new AttributeTreeNodeInfo(element.getKey().toString(), element.isRestricted());
            DefaultMutableTreeNode attributeInfo = new DefaultMutableTreeNode(treeNodeInfo);
            this.createValueSubTrees(attributeInfo, element, this.currentAttributes);
            if (attributeInfo.getChildCount() == 0) continue;
            mapInfo.add(attributeInfo);
        }
    }

    private void createValueSubTrees(DefaultMutableTreeNode attributeInfo, AttributeRegistryElement element, AttributeRegistry currentAttributes) {
        String attributeName = element.getKey().toString();
        SortedComboBoxModel values = element.getValues();
        for (int i = 0; i < values.getSize(); ++i) {
            Object nextElement = values.getElementAt(i);
            if (currentAttributes.exist(attributeName, nextElement)) continue;
            TreeNodeInfo treeNodeInfo = new TreeNodeInfo(nextElement.toString());
            DefaultMutableTreeNode valueInfo = new DefaultMutableTreeNode(treeNodeInfo);
            attributeInfo.add(valueInfo);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        int newSelectionType;
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        TreeNodeInfo info = (TreeNodeInfo)selectedNode.getUserObject();
        switch (info.getSelected()) {
            case 0: {
                newSelectionType = 2;
                break;
            }
            default: {
                newSelectionType = 0;
            }
        }
        this.setSelectionType(selectedNode, newSelectionType);
        this.setParentSelectionType(selectedNode, newSelectionType);
        this.tree.clearSelection();
    }

    private void setParentSelectionType(DefaultMutableTreeNode selectedNode, int newSelectionType) {
        TreeNode parentNode = selectedNode.getParent();
        if (parentNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableParentNode = (DefaultMutableTreeNode)parentNode;
        TreeNodeInfo info = (TreeNodeInfo)defaultMutableParentNode.getUserObject();
        if (newSelectionType == 1) {
            if (info.getSelected() != 1) {
                info.setSelected(1);
                this.treeModel.nodeChanged(defaultMutableParentNode);
            }
            this.setParentSelectionType(defaultMutableParentNode, 1);
            return;
        }
        for (int i = 0; i < defaultMutableParentNode.getChildCount(); ++i) {
            TreeNodeInfo childInfo = (TreeNodeInfo)((DefaultMutableTreeNode)defaultMutableParentNode.getChildAt(i)).getUserObject();
            if (childInfo.getSelected() == newSelectionType) continue;
            if (info.getSelected() != 1) {
                info.setSelected(1);
                this.treeModel.nodeChanged(defaultMutableParentNode);
            }
            this.setParentSelectionType(defaultMutableParentNode, 1);
            return;
        }
        if (info.getSelected() != newSelectionType) {
            info.setSelected(newSelectionType);
            this.treeModel.nodeChanged(defaultMutableParentNode);
        }
        this.setParentSelectionType(defaultMutableParentNode, newSelectionType);
    }

    private void setSelectionType(TreeNode selectedNode, int newSelectionType) {
        TreeNodeInfo info = (TreeNodeInfo)((DefaultMutableTreeNode)selectedNode).getUserObject();
        if (info.getSelected() != newSelectionType) {
            info.setSelected(newSelectionType);
            this.treeModel.nodeChanged(selectedNode);
        }
        for (int i = 0; i < selectedNode.getChildCount(); ++i) {
            this.setSelectionType(selectedNode.getChildAt(i), newSelectionType);
        }
    }

    private static class MyRenderer
    extends DefaultTreeCellRenderer {
        static final Icon iconFull = MindIcon.factory("button_ok").getIcon();
        static final Icon iconPartial = MindIcon.factory("forward").getIcon();
        static final Icon iconNotSelected = MindIcon.factory("button_cancel").getIcon();

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, false, expanded, leaf, row, false);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            TreeNodeInfo info = (TreeNodeInfo)node.getUserObject();
            switch (info.getSelected()) {
                case 0: {
                    this.setIcon(iconFull);
                    break;
                }
                case 1: {
                    this.setIcon(iconPartial);
                    break;
                }
                case 2: {
                    this.setIcon(iconNotSelected);
                }
            }
            return this;
        }
    }

    private static class AttributeTreeNodeInfo
    extends TreeNodeInfo {
        private boolean restricted;

        public AttributeTreeNodeInfo(String info, boolean restricted) {
            super(info);
            this.restricted = restricted;
        }

        boolean isRestricted() {
            return this.restricted;
        }
    }

    private static class TreeNodeInfo {
        private String info;
        private static final int FULL_SELECTED = 0;
        private static final int PARTIAL_SELECTED = 1;
        private static final int NOT_SELECTED = 2;
        private int selected;

        public TreeNodeInfo(String info) {
            this.info = info;
            this.selected = 2;
        }

        int getSelected() {
            return this.selected;
        }

        void setSelected(int selected) {
            this.selected = selected;
        }

        String getInfo() {
            return this.info;
        }

        public String toString() {
            return this.info;
        }
    }
}

