/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.text;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.ControlFlowException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.text.DiffLog;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public abstract class BlockSupport {
    public static final Key<Boolean> DO_NOT_REPARSE_INCREMENTALLY = Key.create("DO_NOT_REPARSE_INCREMENTALLY");
    public static final Key<Pair<ASTNode, CharSequence>> TREE_TO_BE_REPARSED = Key.create("TREE_TO_BE_REPARSED");
    public static final int INCREMENTAL_REPARSE_DEPTH_LIMIT = Registry.intValue("psi.incremental.reparse.depth.limit");
    public static final Key<Boolean> TREE_DEPTH_LIMIT_EXCEEDED = Key.create("TREE_IS_TOO_DEEP");

    public static BlockSupport getInstance(Project project) {
        return ServiceManager.getService(project, BlockSupport.class);
    }

    public abstract void reparseRange(@NotNull PsiFile var1, int var2, int var3, @NonNls @NotNull CharSequence var4) throws IncorrectOperationException;

    @NotNull
    public abstract DiffLog reparseRange(@NotNull PsiFile var1, @NotNull FileASTNode var2, @NotNull TextRange var3, @NotNull CharSequence var4, @NotNull ProgressIndicator var5, @NotNull CharSequence var6) throws IncorrectOperationException;

    public static boolean isTooDeep(UserDataHolder element) {
        return element != null && Boolean.TRUE.equals(element.getUserData(TREE_DEPTH_LIMIT_EXCEEDED));
    }

    public static class ReparsedSuccessfullyException
    extends RuntimeException
    implements ControlFlowException {
        private final DiffLog myDiffLog;

        public ReparsedSuccessfullyException(@NotNull DiffLog diffLog) {
            if (diffLog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffLog", "org/jetbrains/kotlin/com/intellij/psi/text/BlockSupport$ReparsedSuccessfullyException", "<init>"));
            }
            this.myDiffLog = diffLog;
        }

        @NotNull
        public DiffLog getDiffLog() {
            DiffLog diffLog = this.myDiffLog;
            if (diffLog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/text/BlockSupport$ReparsedSuccessfullyException", "getDiffLog"));
            }
            return diffLog;
        }

        @Override
        @NotNull
        public synchronized Throwable fillInStackTrace() {
            ReparsedSuccessfullyException reparsedSuccessfullyException = this;
            if (reparsedSuccessfullyException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/text/BlockSupport$ReparsedSuccessfullyException", "fillInStackTrace"));
            }
            return reparsedSuccessfullyException;
        }
    }
}

