/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import com.google.common.collect.Maps;
import java.util.Map;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.DefaultCachedMetadata;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.DefaultModuleMetadataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleComponentAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCacheEntry;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.util.BuildCommencedTimeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryModuleMetadataCache
implements ModuleMetadataCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultModuleMetadataCache.class);
    protected final BuildCommencedTimeProvider timeProvider;
    private Map<ModuleComponentAtRepositoryKey, ModuleMetadataCache.CachedMetadata> inMemoryCache = Maps.newConcurrentMap();

    public InMemoryModuleMetadataCache(BuildCommencedTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    @Override
    public ModuleMetadataCache.CachedMetadata getCachedModuleDescriptor(ModuleComponentRepository repository, ModuleComponentIdentifier componentId) {
        ModuleComponentAtRepositoryKey key = this.createKey(repository, componentId);
        return this.get(key);
    }

    protected ModuleMetadataCache.CachedMetadata get(ModuleComponentAtRepositoryKey key) {
        return this.inMemoryCache.get(key);
    }

    @Override
    public ModuleMetadataCache.CachedMetadata cacheMissing(ModuleComponentRepository repository, ModuleComponentIdentifier id) {
        LOGGER.debug("Recording absence of module descriptor in cache: {} [changing = {}]", (Object)id, (Object)false);
        ModuleComponentAtRepositoryKey key = this.createKey(repository, id);
        ModuleMetadataCacheEntry entry = ModuleMetadataCacheEntry.forMissingModule(this.timeProvider.getCurrentTime());
        DefaultCachedMetadata cachedMetaData = new DefaultCachedMetadata(entry, null, this.timeProvider);
        this.store(key, entry, cachedMetaData);
        return cachedMetaData;
    }

    @Override
    public ModuleMetadataCache.CachedMetadata cacheMetaData(ModuleComponentRepository repository, ModuleComponentIdentifier id, ModuleComponentResolveMetadata metadata) {
        LOGGER.debug("Recording module descriptor in cache: {} [changing = {}]", (Object)metadata.getComponentId(), (Object)metadata.isChanging());
        ModuleComponentAtRepositoryKey key = this.createKey(repository, id);
        ModuleMetadataCacheEntry entry = this.createEntry(metadata);
        DefaultCachedMetadata cachedMetaData = new DefaultCachedMetadata(entry, metadata, this.timeProvider);
        this.store(key, entry, cachedMetaData);
        return cachedMetaData;
    }

    protected void store(ModuleComponentAtRepositoryKey key, ModuleMetadataCacheEntry entry, ModuleMetadataCache.CachedMetadata cachedMetaData) {
        this.inMemoryCache.put(key, cachedMetaData);
    }

    private ModuleComponentAtRepositoryKey createKey(ModuleComponentRepository repository, ModuleComponentIdentifier id) {
        return new ModuleComponentAtRepositoryKey(repository.getId(), id);
    }

    private ModuleMetadataCacheEntry createEntry(ModuleComponentResolveMetadata metaData) {
        return ModuleMetadataCacheEntry.forMetaData(metaData, this.timeProvider.getCurrentTime());
    }
}

