/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DefaultDependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependencyToAll;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;

public class ClassSetAnalysis {
    private final ClassSetAnalysisData data;

    public ClassSetAnalysis(ClassSetAnalysisData data) {
        this.data = data;
    }

    public DependentsSet getRelevantDependents(Iterable<String> classes, IntSet constants) {
        LinkedHashSet result = null;
        for (String cls : classes) {
            DependentsSet d = this.getRelevantDependents(cls, constants);
            if (d.isDependencyToAll()) {
                return d;
            }
            Set<String> dependentClasses = d.getDependentClasses();
            if (dependentClasses.isEmpty()) continue;
            if (result == null) {
                result = Sets.newLinkedHashSet();
            }
            result.addAll(dependentClasses);
        }
        return result == null ? DefaultDependentsSet.EMPTY : new DefaultDependentsSet(result);
    }

    public DependentsSet getRelevantDependents(String className, IntSet constants) {
        DependentsSet deps = this.data.getDependents(className);
        if (deps != null && deps.isDependencyToAll()) {
            return deps;
        }
        if (deps == null && constants.isEmpty()) {
            return DefaultDependentsSet.EMPTY;
        }
        if (!constants.isEmpty()) {
            return DependencyToAll.INSTANCE;
        }
        HashSet<String> result = new HashSet<String>();
        if (deps != null && !deps.isDependencyToAll()) {
            this.recurseDependents(new HashSet<String>(), result, deps.getDependentClasses());
        }
        result.remove(className);
        return new DefaultDependentsSet(result);
    }

    public boolean isDependencyToAll(String className) {
        DependentsSet deps = this.data.getDependents(className);
        return deps != null && deps.isDependencyToAll();
    }

    private void recurseDependents(Set<String> visited, Set<String> result, Set<String> dependentClasses) {
        for (String d : dependentClasses) {
            DependentsSet currentDependents;
            if (!visited.add(d)) continue;
            if (!d.contains("$")) {
                result.add(d);
            }
            if ((currentDependents = this.data.getDependents(d)) == null || currentDependents.isDependencyToAll()) continue;
            this.recurseDependents(visited, result, currentDependents.getDependentClasses());
        }
    }

    public ClassSetAnalysisData getData() {
        return this.data;
    }
}

