/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.jar.LocalJarClasspathSnapshotStore;

public class PreviousCompilation {
    private ClassSetAnalysis analysis;
    private LocalJarClasspathSnapshotStore classpathSnapshotStore;
    private final JarSnapshotCache jarSnapshotCache;
    private Map<File, JarSnapshot> jarSnapshots;

    public PreviousCompilation(ClassSetAnalysis analysis, LocalJarClasspathSnapshotStore classpathSnapshotStore, JarSnapshotCache jarSnapshotCache) {
        this.analysis = analysis;
        this.classpathSnapshotStore = classpathSnapshotStore;
        this.jarSnapshotCache = jarSnapshotCache;
    }

    public DependentsSet getDependents(Set<String> allClasses, IntSet constants) {
        return this.analysis.getRelevantDependents(allClasses, constants);
    }

    public String getClassName(String path) {
        return this.analysis.getData().getClassNameForFile(path);
    }

    public JarSnapshot getJarSnapshot(File file) {
        if (this.jarSnapshots == null) {
            JarClasspathSnapshotData data = this.classpathSnapshotStore.get();
            this.jarSnapshots = this.jarSnapshotCache.getJarSnapshots(data.getJarHashes());
        }
        return this.jarSnapshots.get(file);
    }

    public DependentsSet getDependents(String className, IntSet newConstants) {
        IntOpenHashSet constants = new IntOpenHashSet((IntCollection)this.analysis.getData().getConstants(className));
        constants.removeAll((IntCollection)newConstants);
        return this.analysis.getRelevantDependents(className, (IntSet)constants);
    }

    public Map<File, JarSnapshot> getJarSnapshots() {
        if (this.jarSnapshots == null) {
            JarClasspathSnapshotData data = this.classpathSnapshotStore.get();
            this.jarSnapshots = this.jarSnapshotCache.getJarSnapshots(data.getJarHashes());
        }
        return Collections.unmodifiableMap(this.jarSnapshots);
    }
}

