/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependencyInternal;

public class DefaultIvyDependency
implements IvyDependencyInternal {
    private final String organisation;
    private final String module;
    private final String revision;
    private final String confMapping;
    private final boolean transitive;
    private final List<DependencyArtifact> artifacts = new ArrayList<DependencyArtifact>();
    private final List<ExcludeRule> excludeRules = new ArrayList<ExcludeRule>();

    public DefaultIvyDependency(String organisation, String module, String revision, String confMapping, boolean transitive) {
        this.organisation = organisation;
        this.module = module;
        this.revision = revision;
        this.confMapping = confMapping;
        this.transitive = transitive;
    }

    public DefaultIvyDependency(String organisation, String module, String revision, String confMapping, boolean transitive, Collection<DependencyArtifact> artifacts) {
        this(organisation, module, revision, confMapping, transitive);
        this.artifacts.addAll(artifacts);
    }

    public DefaultIvyDependency(String organisation, String module, String revision, String confMapping, boolean transitive, Collection<DependencyArtifact> artifacts, Collection<ExcludeRule> excludeRules) {
        this(organisation, module, revision, confMapping, transitive, artifacts);
        this.excludeRules.addAll(excludeRules);
    }

    public DefaultIvyDependency(ExternalDependency dependency, String confMapping) {
        this(dependency.getGroup(), dependency.getName(), dependency.getVersionConstraint().getPreferredVersion(), confMapping, dependency.isTransitive(), dependency.getArtifacts(), dependency.getExcludeRules());
    }

    @Override
    public String getOrganisation() {
        return this.organisation;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public String getConfMapping() {
        return this.confMapping;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public Iterable<DependencyArtifact> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public Iterable<ExcludeRule> getExcludeRules() {
        return this.excludeRules;
    }
}

