/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultImmutableAttributes
implements ImmutableAttributes,
AttributeValue<Object> {
    private static final Comparator<Attribute<?>> ATTRIBUTE_NAME_COMPARATOR = new Comparator<Attribute<?>>(){

        @Override
        public int compare(Attribute<?> o1, Attribute<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    final Attribute<?> attribute;
    final Isolatable<?> value;
    private final ImmutableMap<Attribute<?>, DefaultImmutableAttributes> hierarchy;
    private final ImmutableMap<String, DefaultImmutableAttributes> hierarchyByName;
    private final int hashCode;

    DefaultImmutableAttributes() {
        this.attribute = null;
        this.value = null;
        this.hashCode = 0;
        this.hierarchy = ImmutableMap.of();
        this.hierarchyByName = ImmutableMap.of();
    }

    DefaultImmutableAttributes(DefaultImmutableAttributes parent, Attribute<?> key, Isolatable<?> value) {
        this.attribute = key;
        this.value = value;
        LinkedHashMap hierarchy = Maps.newLinkedHashMap();
        hierarchy.putAll(parent.hierarchy);
        hierarchy.put(this.attribute, this);
        this.hierarchy = ImmutableMap.copyOf((Map)hierarchy);
        LinkedHashMap hierarchyByName = Maps.newLinkedHashMap();
        hierarchyByName.putAll(parent.hierarchyByName);
        hierarchyByName.put(this.attribute.getName(), this);
        this.hierarchyByName = ImmutableMap.copyOf((Map)hierarchyByName);
        int hashCode = parent.hashCode();
        hashCode = 31 * hashCode + this.attribute.hashCode();
        this.hashCode = hashCode = 31 * hashCode + value.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultImmutableAttributes that = (DefaultImmutableAttributes)o;
        if (this.hierarchy.size() != that.hierarchy.size()) {
            return false;
        }
        for (Map.Entry entry : this.hierarchy.entrySet()) {
            if (((DefaultImmutableAttributes)entry.getValue()).value.isolate().equals(that.getAttribute((Attribute)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public ImmutableSet<Attribute<?>> keySet() {
        return this.hierarchy.keySet();
    }

    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        throw new UnsupportedOperationException("Mutation of attributes is not allowed");
    }

    public <T> T getAttribute(Attribute<T> key) {
        Isolatable<T> isolatable = this.getIsolatableAttribute(key);
        return isolatable == null ? null : (T)isolatable.isolate();
    }

    protected <T> Isolatable<T> getIsolatableAttribute(Attribute<T> key) {
        DefaultImmutableAttributes attributes = (DefaultImmutableAttributes)this.hierarchy.get(key);
        return attributes == null ? null : attributes.value;
    }

    @Override
    public <T> AttributeValue<T> findEntry(Attribute<T> key) {
        DefaultImmutableAttributes attributes = (DefaultImmutableAttributes)this.hierarchy.get(key);
        return attributes == null ? MISSING : attributes;
    }

    @Override
    public AttributeValue<?> findEntry(String key) {
        DefaultImmutableAttributes attributes = (DefaultImmutableAttributes)this.hierarchyByName.get((Object)key);
        return attributes == null ? MISSING : attributes;
    }

    @Override
    public Object get() {
        return this.value.isolate();
    }

    @Override
    @Nullable
    private <S> S coerce(Class<S> type) {
        Isolatable<S> converted;
        if (this.value != null && (converted = this.value.coerce(type)) != null) {
            return converted.isolate();
        }
        return null;
    }

    @Override
    public <S> S coerce(Attribute<S> otherAttribute) {
        Class attributeType = otherAttribute.getType();
        if (attributeType.isAssignableFrom(this.attribute.getType())) {
            return (S)this.get();
        }
        S converted = this.coerce(attributeType);
        if (converted != null) {
            return converted;
        }
        String foundType = this.get().getClass().getName();
        if (foundType.equals(attributeType.getName())) {
            foundType = foundType + " with a different ClassLoader";
        }
        throw new IllegalArgumentException(String.format("Unexpected type for attribute '%s' provided. Expected a value of type %s but found a value of type %s.", this.attribute.getName(), attributeType.getName(), foundType));
    }

    @Override
    public boolean isPresent() {
        return this.attribute != null;
    }

    public boolean isEmpty() {
        return this.attribute == null;
    }

    public boolean contains(Attribute<?> key) {
        return this.hierarchy.containsKey(key);
    }

    @Override
    public ImmutableAttributes asImmutable() {
        return this;
    }

    public AttributeContainer getAttributes() {
        return this;
    }

    public String toString() {
        TreeMap sorted = new TreeMap(ATTRIBUTE_NAME_COMPARATOR);
        for (Map.Entry entry : this.hierarchy.entrySet()) {
            sorted.put((Attribute<?>)entry.getKey(), ((DefaultImmutableAttributes)entry.getValue()).value.isolate());
        }
        return ((Object)sorted).toString();
    }
}

