/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.LoadProjectsBuildOperationType;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyingBuildLoader
implements BuildLoader {
    private final BuildLoader buildLoader;
    private final BuildOperationExecutor buildOperationExecutor;
    private static final Comparator<LoadProjectsBuildOperationType.Result.Project> PROJECT_COMPARATOR = new Comparator<LoadProjectsBuildOperationType.Result.Project>(){

        @Override
        public int compare(LoadProjectsBuildOperationType.Result.Project o1, LoadProjectsBuildOperationType.Result.Project o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public NotifyingBuildLoader(BuildLoader buildLoader, BuildOperationExecutor buildOperationExecutor) {
        this.buildLoader = buildLoader;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(final SettingsInternal settings, final GradleInternal gradle) {
        try {
            this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<Void>(){

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)"Load projects").progressDisplayName("Loading projects").details((Object)new LoadProjectsBuildOperationType.Details(){

                        public String getBuildPath() {
                            return gradle.getIdentityPath().toString();
                        }
                    });
                }

                public Void call(BuildOperationContext context) {
                    NotifyingBuildLoader.this.buildLoader.load(settings, gradle);
                    context.setResult((Object)NotifyingBuildLoader.this.createOperationResult(gradle));
                    return null;
                }
            });
        }
        finally {
            gradle.getBuildListenerBroadcaster().projectsLoaded((Gradle)gradle);
        }
    }

    private BuildStructureOperationResult createOperationResult(GradleInternal gradle) {
        String buildPath = gradle.getIdentityPath().toString();
        LoadProjectsBuildOperationType.Result.Project rootProject = this.convert(gradle.getRootProject());
        return new BuildStructureOperationResult(rootProject, buildPath);
    }

    private LoadProjectsBuildOperationType.Result.Project convert(Project project) {
        return new BuildStructureOperationProject(project.getName(), project.getPath(), ((ProjectInternal)project).getIdentityPath().toString(), project.getProjectDir().getAbsolutePath(), project.getBuildFile().getAbsolutePath(), this.convert(project.getChildProjects().values()));
    }

    private Set<LoadProjectsBuildOperationType.Result.Project> convert(Iterable<Project> children) {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PROJECT_COMPARATOR);
        for (Project child : children) {
            builder.add((Object)this.convert(child));
        }
        return builder.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildStructureOperationProject
    implements LoadProjectsBuildOperationType.Result.Project {
        private final String name;
        private final String path;
        private final String identityPath;
        private final String projectDir;
        private final String buildFile;
        private final Set<LoadProjectsBuildOperationType.Result.Project> children;

        public BuildStructureOperationProject(String name, String path, String identityPath, String projectDir, String buildFile, Set<LoadProjectsBuildOperationType.Result.Project> children) {
            this.name = name;
            this.path = path;
            this.identityPath = identityPath;
            this.projectDir = projectDir;
            this.buildFile = buildFile;
            this.children = children;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getIdentityPath() {
            return this.identityPath;
        }

        @Override
        public String getProjectDir() {
            return this.projectDir;
        }

        @Override
        public String getBuildFile() {
            return this.buildFile;
        }

        @Override
        public Set<LoadProjectsBuildOperationType.Result.Project> getChildren() {
            return this.children;
        }
    }

    private static class BuildStructureOperationResult
    implements LoadProjectsBuildOperationType.Result {
        private final LoadProjectsBuildOperationType.Result.Project rootProject;
        private final String buildPath;

        public BuildStructureOperationResult(LoadProjectsBuildOperationType.Result.Project rootProject, String buildPath) {
            this.rootProject = rootProject;
            this.buildPath = buildPath;
        }

        public LoadProjectsBuildOperationType.Result.Project getRootProject() {
            return this.rootProject;
        }

        public String getBuildPath() {
            return this.buildPath;
        }
    }
}

