/*
 * Decompiled with CFR 0.152.
 */
package Glacier2;

import Glacier2.RouterPrx;
import Glacier2.RouterPrxHelper;
import Glacier2.SessionNotExistException;
import Glacier2.SessionPrx;
import Ice.ACMHeartbeat;
import Ice.CloseCallback;
import Ice.Connection;
import Ice.ConnectionLostException;
import Ice.ConnectionRefusedException;
import Ice.Holder;
import Ice.Identity;
import Ice.InitializationData;
import Ice.IntOptional;
import Ice.LocalException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.OperationNotExistException;
import Ice.Optional;
import Ice.RequestFailedException;
import Ice.SignalPolicy;
import Ice.StringSeqHolder;
import Ice.TimeoutException;
import Ice.UnknownLocalException;
import Ice.Util;
import IceInternal.Ex;
import java.util.UUID;

public abstract class Application
extends Ice.Application {
    private static ObjectAdapter _adapter;
    private static RouterPrx _router;
    private static SessionPrx _session;
    private static String _category;

    public Application() {
    }

    public Application(SignalPolicy signalPolicy) {
        super(signalPolicy);
    }

    public abstract SessionPrx createSession();

    public abstract int runWithSession(String[] var1) throws RestartSessionException;

    public void sessionDestroyed() {
    }

    @Override
    public final int run(String[] args) {
        assert (false);
        return 0;
    }

    public static void restart() throws RestartSessionException {
        throw new RestartSessionException();
    }

    public static RouterPrx router() {
        return _router;
    }

    public static SessionPrx session() {
        return _session;
    }

    public static String categoryForClient() throws SessionNotExistException {
        if (_router == null) {
            throw new SessionNotExistException();
        }
        return _category;
    }

    public static Identity createCallbackIdentity(String name) throws SessionNotExistException {
        return new Identity(name, Application.categoryForClient());
    }

    public static ObjectPrx addWithUUID(Ice.Object servant) throws SessionNotExistException {
        return Application.objectAdapter().add(servant, Application.createCallbackIdentity(UUID.randomUUID().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectAdapter objectAdapter() throws SessionNotExistException {
        if (_router == null) {
            throw new SessionNotExistException();
        }
        Object object = _mutex;
        synchronized (object) {
            if (_adapter == null) {
                _adapter = Application.communicator().createObjectAdapterWithRouter("", _router);
                _adapter.activate();
            }
        }
        return _adapter;
    }

    @Override
    protected int doMain(StringSeqHolder argHolder, InitializationData initData) {
        InitializationData id;
        StringSeqHolder h;
        boolean restart;
        initData.properties.setProperty("Ice.RetryIntervals", "-1");
        Holder<Integer> ret = new Holder<Integer>();
        do {
            id = initData.clone();
            id.properties = id.properties._clone();
            h = new StringSeqHolder();
            h.value = ((String[])argHolder.value).clone();
        } while (restart = this.doMain(h, id, ret));
        return (Integer)ret.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doMain(StringSeqHolder argHolder, InitializationData initData, Holder<Integer> status) {
        boolean sessionCreated;
        boolean restart;
        block38: {
            _callbackInProgress = false;
            _destroyed = false;
            _interrupted = false;
            restart = false;
            status.value = 0;
            sessionCreated = false;
            try {
                _communicator = Util.initialize(argHolder, initData);
                _router = RouterPrxHelper.uncheckedCast(Application.communicator().getDefaultRouter());
                if (_router == null) {
                    Util.getProcessLogger().error("no glacier2 router configured");
                    status.value = 1;
                    break block38;
                }
                if (_signalPolicy == SignalPolicy.HandleSignals) {
                    Application.destroyOnInterrupt();
                }
                try {
                    _session = this.createSession();
                    sessionCreated = true;
                }
                catch (LocalException ex) {
                    Util.getProcessLogger().error(Ex.toString(ex));
                    status.value = 1;
                }
                if (!sessionCreated) break block38;
                int acmTimeout = 0;
                try {
                    acmTimeout = _router.getACMTimeout();
                }
                catch (OperationNotExistException operationNotExistException) {
                    // empty catch block
                }
                if (acmTimeout <= 0) {
                    acmTimeout = (int)_router.getSessionTimeout();
                }
                if (acmTimeout > 0) {
                    Connection connection = _router.ice_getCachedConnection();
                    assert (connection != null);
                    connection.setACM(new IntOptional(acmTimeout), null, new Optional<ACMHeartbeat>(ACMHeartbeat.HeartbeatAlways));
                    connection.setCloseCallback(new CloseCallbackI());
                }
                _category = _router.getCategoryForClient();
                status.value = this.runWithSession((String[])argHolder.value);
            }
            catch (RestartSessionException ex) {
                restart = true;
            }
            catch (ConnectionRefusedException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                restart = true;
            }
            catch (ConnectionLostException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                restart = true;
            }
            catch (UnknownLocalException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                restart = true;
            }
            catch (RequestFailedException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                restart = true;
            }
            catch (TimeoutException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                restart = true;
            }
            catch (LocalException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                status.value = 1;
            }
            catch (Exception ex) {
                Util.getProcessLogger().error("unknown exception:\n" + Ex.toString(ex));
                status.value = 1;
            }
            catch (Error err2) {
                Util.getProcessLogger().error("Java error:\n" + Ex.toString(err2));
                status.value = 1;
            }
        }
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            Application.defaultInterrupt();
        }
        Object err2 = _mutex;
        synchronized (err2) {
            while (_callbackInProgress) {
                try {
                    _mutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (_destroyed) {
                _communicator = null;
            } else {
                _destroyed = true;
            }
        }
        if (sessionCreated && _router != null) {
            try {
                _router.destroySession();
            }
            catch (ConnectionLostException err2) {
            }
            catch (SessionNotExistException err2) {
            }
            catch (Throwable ex) {
                Util.getProcessLogger().error("unexpected exception when destroying the session:\n" + Ex.toString(ex));
            }
            _router = null;
        }
        if (_communicator != null) {
            _communicator.destroy();
            _communicator = null;
        }
        Object object = _mutex;
        synchronized (object) {
            if (_appHook != null) {
                _appHook.done();
            }
        }
        _adapter = null;
        _router = null;
        _session = null;
        _category = null;
        return restart;
    }

    private class CloseCallbackI
    implements CloseCallback {
        private CloseCallbackI() {
        }

        @Override
        public void closed(Connection con) {
            Application.this.sessionDestroyed();
        }
    }

    public static class RestartSessionException
    extends Exception {
    }
}

