/* Generated by wayland-scanner 1.14.0 */

#ifndef SURFACE_EXTENSION_SERVER_PROTOCOL_H
#define SURFACE_EXTENSION_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_surface_extension The surface_extension protocol
 * @section page_ifaces_surface_extension Interfaces
 * - @subpage page_iface_qt_surface_extension - 
 * - @subpage page_iface_qt_extended_surface - 
 * @section page_copyright_surface_extension Copyright
 * <pre>
 *
 * Copyright (C) 2015 The Qt Company Ltd.
 * Contact: http://www.qt.io/licensing/
 *
 * This file is part of the plugins of the Qt Toolkit.
 *
 * $QT_BEGIN_LICENSE:BSD$
 * You may use this file under the terms of the BSD license as follows:
 *
 * "Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in
 * the documentation and/or other materials provided with the
 * distribution.
 * * Neither the name of The Qt Company Ltd nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
 *
 * $QT_END_LICENSE$
 * </pre>
 */
struct qt_extended_surface;
struct qt_surface_extension;
struct wl_surface;

/**
 * @page page_iface_qt_surface_extension qt_surface_extension
 * @section page_iface_qt_surface_extension_api API
 * See @ref iface_qt_surface_extension.
 */
/**
 * @defgroup iface_qt_surface_extension The qt_surface_extension interface
 */
extern const struct wl_interface qt_surface_extension_interface;
/**
 * @page page_iface_qt_extended_surface qt_extended_surface
 * @section page_iface_qt_extended_surface_api API
 * See @ref iface_qt_extended_surface.
 */
/**
 * @defgroup iface_qt_extended_surface The qt_extended_surface interface
 */
extern const struct wl_interface qt_extended_surface_interface;

/**
 * @ingroup iface_qt_surface_extension
 * @struct qt_surface_extension_interface
 */
struct qt_surface_extension_interface {
	/**
	 */
	void (*get_extended_surface)(struct wl_client *client,
				     struct wl_resource *resource,
				     uint32_t id,
				     struct wl_resource *surface);
};


/**
 * @ingroup iface_qt_surface_extension
 */
#define QT_SURFACE_EXTENSION_GET_EXTENDED_SURFACE_SINCE_VERSION 1

#ifndef QT_EXTENDED_SURFACE_ORIENTATION_ENUM
#define QT_EXTENDED_SURFACE_ORIENTATION_ENUM
enum qt_extended_surface_orientation {
	QT_EXTENDED_SURFACE_ORIENTATION_PRIMARYORIENTATION = 0,
	QT_EXTENDED_SURFACE_ORIENTATION_PORTRAITORIENTATION = 1,
	QT_EXTENDED_SURFACE_ORIENTATION_LANDSCAPEORIENTATION = 2,
	QT_EXTENDED_SURFACE_ORIENTATION_INVERTEDPORTRAITORIENTATION = 4,
	QT_EXTENDED_SURFACE_ORIENTATION_INVERTEDLANDSCAPEORIENTATION = 8,
};
#endif /* QT_EXTENDED_SURFACE_ORIENTATION_ENUM */

#ifndef QT_EXTENDED_SURFACE_WINDOWFLAG_ENUM
#define QT_EXTENDED_SURFACE_WINDOWFLAG_ENUM
enum qt_extended_surface_windowflag {
	QT_EXTENDED_SURFACE_WINDOWFLAG_OVERRIDESSYSTEMGESTURES = 1,
	QT_EXTENDED_SURFACE_WINDOWFLAG_STAYSONTOP = 2,
	QT_EXTENDED_SURFACE_WINDOWFLAG_BYPASSWINDOWMANAGER = 4,
};
#endif /* QT_EXTENDED_SURFACE_WINDOWFLAG_ENUM */

/**
 * @ingroup iface_qt_extended_surface
 * @struct qt_extended_surface_interface
 */
struct qt_extended_surface_interface {
	/**
	 */
	void (*update_generic_property)(struct wl_client *client,
					struct wl_resource *resource,
					const char *name,
					struct wl_array *value);
	/**
	 */
	void (*set_content_orientation_mask)(struct wl_client *client,
					     struct wl_resource *resource,
					     int32_t orientation);
	/**
	 */
	void (*set_window_flags)(struct wl_client *client,
				 struct wl_resource *resource,
				 int32_t flags);
	/**
	 */
	void (*raise)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 */
	void (*lower)(struct wl_client *client,
		      struct wl_resource *resource);
};

#define QT_EXTENDED_SURFACE_ONSCREEN_VISIBILITY 0
#define QT_EXTENDED_SURFACE_SET_GENERIC_PROPERTY 1
#define QT_EXTENDED_SURFACE_CLOSE 2

/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_ONSCREEN_VISIBILITY_SINCE_VERSION 1
/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_SET_GENERIC_PROPERTY_SINCE_VERSION 1
/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_CLOSE_SINCE_VERSION 1

/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_UPDATE_GENERIC_PROPERTY_SINCE_VERSION 1
/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_SET_CONTENT_ORIENTATION_MASK_SINCE_VERSION 1
/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_SET_WINDOW_FLAGS_SINCE_VERSION 1
/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_RAISE_SINCE_VERSION 1
/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_LOWER_SINCE_VERSION 1

/**
 * @ingroup iface_qt_extended_surface
 * Sends an onscreen_visibility event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_extended_surface_send_onscreen_visibility(struct wl_resource *resource_, int32_t visible)
{
	wl_resource_post_event(resource_, QT_EXTENDED_SURFACE_ONSCREEN_VISIBILITY, visible);
}

/**
 * @ingroup iface_qt_extended_surface
 * Sends an set_generic_property event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_extended_surface_send_set_generic_property(struct wl_resource *resource_, const char *name, struct wl_array *value)
{
	wl_resource_post_event(resource_, QT_EXTENDED_SURFACE_SET_GENERIC_PROPERTY, name, value);
}

/**
 * @ingroup iface_qt_extended_surface
 * Sends an close event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_extended_surface_send_close(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, QT_EXTENDED_SURFACE_CLOSE);
}

#ifdef  __cplusplus
}
#endif

#endif
