/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.ir.IRScope;
import org.jruby.util.ConvertBytes;

public class SexpMaker {
    private static final AtomicLong JITTED_METHOD_NUMBER = new AtomicLong();

    public static String sha1(IRScope scope) {
        MessageDigest sha1;
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
        DigestBuilder db = new DigestBuilder(sha1);
        db.append(scope.getName());
        db.append('\n');
        db.append(JITTED_METHOD_NUMBER.getAndIncrement());
        byte[] digest2 = db.d.digest();
        return new String(ConvertBytes.twosComplementToHexBytes(digest2, false));
    }

    private static class DigestBuilder
    implements Builder {
        MessageDigest d;

        DigestBuilder(MessageDigest digest2) {
            this.d = digest2;
        }

        @Override
        public Builder append(Object o) {
            this.append(o.toString());
            return this;
        }

        @Override
        public Builder append(String str) {
            this.d.update(str.getBytes());
            return this;
        }

        @Override
        public Builder append(boolean b2) {
            this.append((byte)(b2 ? 1 : 0));
            return this;
        }

        @Override
        public Builder append(char ch) {
            this.d.update((byte)(ch >> 8));
            this.d.update((byte)ch);
            return this;
        }

        @Override
        public Builder append(int i2) {
            this.append((char)(i2 >> 16));
            this.append((char)i2);
            return this;
        }

        @Override
        public Builder append(long l) {
            this.append((int)(l >> 32));
            this.append((int)l);
            return this;
        }

        @Override
        public Builder append(double d) {
            this.append(Double.doubleToLongBits(d));
            return this;
        }
    }

    private static interface Builder {
        public Builder append(String var1);

        public Builder append(char var1);

        public Builder append(int var1);

        public Builder append(Object var1);

        public Builder append(boolean var1);

        public Builder append(long var1);

        public Builder append(double var1);
    }
}

