/* include/linux/wlan_plat.h
 *
 * Copyright (C) 2010 Google, Inc.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#ifndef _LINUX_WLAN_PLAT_H_
#define _LINUX_WLAN_PLAT_H_

#define WLAN_PLAT_NODFS_FLAG	0x01
#define WLAN_PLAT_AP_FLAG	0x02

struct wifi_platform_data {
	int (*set_power)(struct wifi_platform_data *pdata, int val);
	int (*set_reset)(struct wifi_platform_data *pdata, int val);
	int (*set_carddetect)(struct wifi_platform_data *pdata, int val);
	void *(*mem_prealloc)(struct wifi_platform_data *pdata,
			      int section, unsigned long size);
	int (*get_mac_addr)(struct wifi_platform_data *pdata,
			    unsigned char *buf);
	int (*get_wake_irq)(struct wifi_platform_data *pdata);
	void *(*get_country_code)(struct wifi_platform_data *pdata,
				  char *ccode, u32 flags);
#ifdef CONFIG_PARTIALRESUME
#define WIFI_PR_INIT			0
#define WIFI_PR_NOTIFY_RESUME		1
#define WIFI_PR_VOTE_FOR_RESUME		2
#define WIFI_PR_VOTE_FOR_SUSPEND	3
#define WIFI_PR_WAIT_FOR_READY		4
	bool (*partial_resume)(struct wifi_platform_data *pdata, int action);
#endif
};

#endif
