/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.openide.util.lookup.implspi.ServiceLoaderLine;

public abstract class AbstractServiceProviderProcessor
extends AbstractProcessor {
    private final Map<Filer, Map<String, SortedSet<ServiceLoaderLine>>> outputFilesByProcessor = new WeakHashMap<Filer, Map<String, SortedSet<ServiceLoaderLine>>>();
    private final Map<Filer, Map<String, List<Element>>> originatingElementsByProcessor = new WeakHashMap<Filer, Map<String, List<Element>>>();
    private final Map<TypeElement, Boolean> verifiedClasses = new WeakHashMap<TypeElement, Boolean>();

    protected AbstractServiceProviderProcessor() {
        if (this.getClass().getName().equals("org.netbeans.modules.openide.util.ServiceProviderProcessor")) {
            return;
        }
        if (this.getClass().getName().equals("org.netbeans.modules.openide.util.URLStreamHandlerRegistrationProcessor")) {
            return;
        }
        if (this.getClass().getName().equals("org.netbeans.modules.openide.util.NamedServiceProcessor")) {
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.errorRaised()) {
            return false;
        }
        if (roundEnv.processingOver()) {
            this.writeServices();
            this.outputFilesByProcessor.clear();
            this.originatingElementsByProcessor.clear();
            return true;
        }
        return this.handleProcess(annotations, roundEnv);
    }

    protected abstract boolean handleProcess(Set<? extends TypeElement> var1, RoundEnvironment var2);

    protected final void register(Element el, Class<? extends Annotation> annotation, TypeMirror type, String path, int position, String ... supersedes) {
        if (el.getKind() != ElementKind.CLASS) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, annotation.getName() + " is not applicable to a " + (Object)((Object)el.getKind()), el);
            return;
        }
        if (el.getEnclosingElement().getKind() == ElementKind.CLASS && !el.getModifiers().contains((Object)Modifier.STATIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Inner class needs to be static to be annotated with @ServiceProvider", el);
            return;
        }
        TypeElement clazz = (TypeElement)el;
        String impl = this.processingEnv.getElementUtils().getBinaryName(clazz).toString();
        String xface = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.processingEnv.getTypeUtils().asElement(type)).toString();
        if (!this.processingEnv.getTypeUtils().isAssignable(clazz.asType(), type)) {
            AnnotationMirror ann = this.findAnnotationMirror(clazz, annotation);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, impl + " is not assignable to " + xface, clazz, ann, this.findAnnotationValue(ann, "service"));
            return;
        }
        String rsrc = (path.length() > 0 ? "META-INF/namedservices/" + path + "/" : "META-INF/services/") + xface;
        Boolean verify = this.verifiedClasses.get(clazz);
        if (verify == null) {
            verify = this.verifyServiceProviderSignature(clazz, annotation);
            this.verifiedClasses.put(clazz, verify);
        }
        if (!verify.booleanValue()) {
            return;
        }
        this.registerImpl(clazz, impl, rsrc, position, supersedes);
    }

    protected final void register(Element el, String path) {
        TypeElement clazz = (TypeElement)el;
        String impl = this.processingEnv.getElementUtils().getBinaryName(clazz).toString();
        this.registerImpl(clazz, impl, path, Integer.MAX_VALUE, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerImpl(TypeElement clazz, String impl, String rsrc, int position, String ... supersedes) {
        SortedSet<ServiceLoaderLine> lines;
        List<Element> origEls;
        Filer filer = this.processingEnv.getFiler();
        Map<String, List<Element>> originatingElements = this.originatingElementsByProcessor.get(filer);
        if (originatingElements == null) {
            originatingElements = new HashMap<String, List<Element>>();
            this.originatingElementsByProcessor.put(filer, originatingElements);
        }
        if ((origEls = originatingElements.get(rsrc)) == null) {
            origEls = new ArrayList<Element>();
            originatingElements.put(rsrc, origEls);
        }
        origEls.add(clazz);
        Map<String, SortedSet<ServiceLoaderLine>> outputFiles = this.outputFilesByProcessor.get(filer);
        if (outputFiles == null) {
            outputFiles = new HashMap<String, SortedSet<ServiceLoaderLine>>();
            this.outputFilesByProcessor.put(filer, outputFiles);
        }
        if ((lines = outputFiles.get(rsrc)) == null) {
            lines = new TreeSet<ServiceLoaderLine>();
            try {
                try {
                    FileObject in = filer.getResource(StandardLocation.SOURCE_PATH, "", rsrc);
                    in.openInputStream().close();
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot generate " + rsrc + " because it already exists in sources: " + in.toUri());
                    return;
                }
                catch (NullPointerException in) {
                }
                catch (FileNotFoundException | NoSuchFileException in) {
                    // empty catch block
                }
                try {
                    FileObject in = filer.getResource(StandardLocation.CLASS_OUTPUT, "", rsrc);
                    try (InputStream is = in.openInputStream();){
                        ServiceLoaderLine.parse(new InputStreamReader(is, "UTF-8"), lines);
                    }
                }
                catch (FileNotFoundException | NoSuchFileException in) {}
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, x.toString());
                return;
            }
            outputFiles.put(rsrc, lines);
        }
        lines.add(new ServiceLoaderLine(impl, position, supersedes));
    }

    private AnnotationMirror findAnnotationMirror(Element element, Class<? extends Annotation> annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.processingEnv.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement()).contentEquals(annotation.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    private AnnotationValue findAnnotationValue(AnnotationMirror annotation, String name) {
        if (annotation != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().contentEquals(name)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private boolean verifyServiceProviderSignature(TypeElement clazz, Class<? extends Annotation> annotation) {
        AnnotationMirror ann = this.findAnnotationMirror(clazz, annotation);
        if (!clazz.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must be public", clazz, ann);
            return false;
        }
        if (clazz.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must not be abstract", clazz, ann);
            return false;
        }
        if (clazz.getEnclosingElement().getKind() != ElementKind.PACKAGE && !clazz.getModifiers().contains((Object)Modifier.STATIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must be static", clazz, ann);
            return false;
        }
        boolean hasDefaultCtor = false;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(clazz.getEnclosedElements())) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
            hasDefaultCtor = true;
            break;
        }
        if (!hasDefaultCtor) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must have a public no-argument constructor", clazz, ann);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServices() {
        for (Map.Entry<Filer, Map<String, SortedSet<ServiceLoaderLine>>> outputFiles : this.outputFilesByProcessor.entrySet()) {
            Filer filer = outputFiles.getKey();
            for (Map.Entry<String, SortedSet<ServiceLoaderLine>> entry : outputFiles.getValue().entrySet()) {
                try {
                    FileObject out = filer.createResource(StandardLocation.CLASS_OUTPUT, "", entry.getKey(), this.originatingElementsByProcessor.get(filer).get(entry.getKey()).toArray(new Element[0]));
                    try (OutputStream os = out.openOutputStream();){
                        PrintWriter w = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
                        for (ServiceLoaderLine line : entry.getValue()) {
                            line.write(w);
                        }
                        w.flush();
                        w.close();
                    }
                }
                catch (IOException x) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write to " + entry.getKey() + ": " + x.toString());
                }
            }
        }
    }

    @Deprecated
    protected final void register(TypeElement el, Class<? extends Annotation> annotation, TypeMirror type, String path, int position, String[] supersedes) {
        this.register((Element)el, annotation, type, path, position, supersedes);
    }
}

