# - Find the lxqt-globalkeys include and library dirs and define a some macros
#
# The module defines the following variables
#  LXQT_GLOBALKEYS_FOUND         - Set to TRUE if all of the above has been found
#
# Typical usage:
#    find_package(lxqt-globalkeys)
#    add_executable(use-lxqt-globalkeys main.cpp)
#    target_link_libraries(use-lxqt-globalkeys lxqt-globalkeys)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was lxqt_globalkeys-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)

set(LXQT_GLOBALKEYS_MAJOR_VERSION 0)
set(LXQT_GLOBALKEYS_MINOR_VERSION 12)
set(LXQT_GLOBALKEYS_PATCH_VERSION 0)
set(LXQT_GLOBALKEYS_VERSION 0.12.0)

find_dependency(Qt5Widgets)
find_dependency(Qt5DBus)

if (CMAKE_VERSION VERSION_GREATER 2.8.12)
    cmake_policy(SET CMP0024 OLD)
endif()
include("${CMAKE_CURRENT_LIST_DIR}/lxqt-globalkeys-targets.cmake")
