# encoding: UTF-8

class Vulnerability
  module Urls
    # @return [ String ] The url to the metasploit module page
    def url_metasploit(module_path)
      # remove leading slash
      module_path = module_path.sub(/^\//, '')
      "https://www.rapid7.com/db/modules/#{module_path}"
    end

    def url_url(url)
      url
    end

    def url_cve(id)
      "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-#{id}"
    end

    def url_osvdb(id)
      "http://osvdb.org/show/osvdb/#{id}"
    end

    def url_secunia(id)
      "https://secunia.com/advisories/#{id}/"
    end

    def url_exploitdb(id)
      "https://www.exploit-db.com/exploits/#{id}/"
    end

    def url_id(id)
      "https://wpvulndb.com/vulnerabilities/#{id}"
    end

    def url_packetstorm(id)
      "http://packetstormsecurity.com/files/#{id}/"
    end

    def url_securityfocus(id)
      "http://www.securityfocus.com/bid/#{id}/"
    end
  end
end
