/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.CellEditor;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.openide.explorer.PropertyPanelBridge;
import org.netbeans.modules.openide.explorer.TTVEnvBridge;
import org.openide.explorer.propertysheet.CustomEditorDisplayer;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.EditablePropertyDisplayer;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.ModelProperty;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyDialogManager;
import org.openide.explorer.propertysheet.PropertyDisplayer;
import org.openide.explorer.propertysheet.PropertyDisplayer_Editable;
import org.openide.explorer.propertysheet.PropertyDisplayer_Inline;
import org.openide.explorer.propertysheet.PropertyDisplayer_Mutable;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.RendererPropertyDisplayer;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.explorer.propertysheet.ReusablePropertyModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PropertyPanel
extends JComponent
implements Accessible {
    public static final int PREF_READ_ONLY = 1;
    public static final int PREF_CUSTOM_EDITOR = 2;
    public static final int PREF_INPUT_STATE = 4;
    public static final int PREF_TABLEUI = 8;
    public static final String PROP_PREFERENCES = "preferences";
    public static final String PROP_MODEL = "model";
    @Deprecated
    public static final String PROP_PROPERTY_EDITOR = "propertyEditor";
    public static final String PROP_STATE = "state";
    private int preferences;
    private PropertyModel model;
    private boolean changeImmediate = true;
    Component inner = null;
    private Listener listener = null;
    private Node.Property prop;
    private boolean settingModel = false;
    private boolean initializing = false;
    private PropertyDisplayer displayer = null;
    Object[] beans = null;
    private ReusablePropertyEnv reusableEnv = new ReusablePropertyEnv();
    private ReusablePropertyModel reusableModel = new ReusablePropertyModel(this.reusableEnv);
    private final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID()) || UIManager.getLookAndFeel().getClass().getSuperclass().getName().indexOf("Synth") != -1;

    public PropertyPanel() {
        this(ModelProperty.toProperty(null), 0, null);
    }

    public PropertyPanel(Object object, String string, int n) {
        this(ModelProperty.toProperty(new DefaultPropertyModel(object, string)), n, new DefaultPropertyModel(object, string));
    }

    public PropertyPanel(PropertyModel propertyModel, int n) {
        this(null, n, propertyModel);
    }

    public PropertyPanel(Node.Property property, int n) {
        this(property, n, null);
    }

    public PropertyPanel(Node.Property property) {
        this(property, 0, null);
    }

    PropertyPanel(Node[] nodeArray, String string) throws ClassCastException, NullPointerException {
        this(nodeArray.length == 1 ? ModelProperty.findProperty(nodeArray[0], string) : ModelProperty.toProperty(nodeArray, string));
    }

    private PropertyPanel(Node.Property property, int n, PropertyModel propertyModel) {
        this.prop = property == null ? ModelProperty.toProperty(propertyModel) : property;
        this.preferences = n;
        this.initializing = true;
        this.setModel(propertyModel);
        this.initializing = false;
        this.setOpaque(true);
        if (!GraphicsEnvironment.isHeadless()) {
            this.getInputMap(1).put(KeyStroke.getKeyStroke(46, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "dump");
        }
        this.getActionMap().put("dump", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.err.println("");
                System.err.println(PropertyPanel.this);
                System.err.println("");
            }
        });
        this.getActionMap().put("invokeCustomEditor", new CustomEditorProxyAction());
        PropertyPanelBridge.register(this, new BridgeAccessor(this));
    }

    @Override
    public void setBackground(Color color) {
        if (this.inner != null) {
            this.inner.setBackground(color);
        }
        super.setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        if (this.inner != null) {
            this.inner.setForeground(color);
        }
        super.setForeground(color);
    }

    private PropertyDisplayer findPropertyDisplayer() {
        boolean bl;
        PropertyDisplayer propertyDisplayer;
        Node.Property property = this.getProperty();
        if (!((this.preferences & 2) != 0 || (this.preferences & 1) == 0 && this.isEnabled())) {
            return this.getRendererComponent(property);
        }
        switch (this.preferences) {
            case 1: 
            case 9: {
                propertyDisplayer = this.getRendererComponent(property);
                break;
            }
            case 2: 
            case 10: {
                propertyDisplayer = new CustomEditorDisplayer(property, this.model);
                break;
            }
            case 3: 
            case 11: {
                propertyDisplayer = new CustomEditorDisplayer(property, this.model);
                break;
            }
            case 4: 
            case 12: {
                propertyDisplayer = new EditablePropertyDisplayer(property, this.model);
                break;
            }
            case 5: 
            case 13: {
                propertyDisplayer = this.getRendererComponent(property);
                break;
            }
            case 6: 
            case 14: {
                propertyDisplayer = new CustomEditorDisplayer(property, this.model);
                break;
            }
            case 7: 
            case 15: {
                propertyDisplayer = new CustomEditorDisplayer(property, this.model);
                break;
            }
            default: {
                propertyDisplayer = new EditablePropertyDisplayer(property, this.model);
            }
        }
        if (propertyDisplayer instanceof PropertyDisplayer_Inline) {
            PropertyDisplayer_Inline propertyDisplayer_Inline = propertyDisplayer;
            boolean bl2 = (this.preferences & 8) != 0 || Boolean.TRUE.equals(this.getClientProperty("flat"));
            propertyDisplayer_Inline.setTableUI(bl2);
            if (propertyDisplayer_Inline.isTableUI()) {
                propertyDisplayer_Inline.setUseLabels(!bl2);
            }
        }
        boolean bl3 = bl = (this.preferences & 8) != 0;
        if (propertyDisplayer instanceof CustomEditorDisplayer) {
            ((PropertyDisplayer_Editable)propertyDisplayer).setUpdatePolicy(this.changeImmediate ? 1 : 2);
        } else if (propertyDisplayer instanceof PropertyDisplayer_Editable) {
            ((PropertyDisplayer_Editable)propertyDisplayer).setUpdatePolicy(bl ? 0 : 1);
        }
        if ((this.preferences & 1) != 0 && propertyDisplayer instanceof CustomEditorDisplayer) {
            ((CustomEditorDisplayer)propertyDisplayer).setEnabled(false);
        } else if (propertyDisplayer instanceof PropertyDisplayer_Editable && !this.isEnabled()) {
            ((PropertyDisplayer_Editable)propertyDisplayer).setEnabled(this.isEnabled());
        }
        return propertyDisplayer;
    }

    private RendererPropertyDisplayer getRendererComponent(Node.Property property) {
        RendererPropertyDisplayer rendererPropertyDisplayer;
        if (this.inner instanceof RendererPropertyDisplayer) {
            ((RendererPropertyDisplayer)this.inner).setProperty(property);
            rendererPropertyDisplayer = (RendererPropertyDisplayer)this.inner;
        } else {
            rendererPropertyDisplayer = new RendererPropertyDisplayer(property);
        }
        return rendererPropertyDisplayer;
    }

    private PropertyDisplayer getPropertyDisplayer() {
        if (this.displayer == null) {
            this.setDisplayer(this.findPropertyDisplayer());
        }
        return this.displayer;
    }

    private boolean commit() {
        if (this.displayer instanceof PropertyDisplayer_Editable) {
            try {
                return ((PropertyDisplayer_Editable)this.displayer).commit();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                PropertyDialogManager.notify(illegalArgumentException);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installDisplayerComponent() {
        Object object;
        boolean bl;
        PropertyDisplayer propertyDisplayer = this.getPropertyDisplayer();
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean bl2 = bl = component == this || this.isAncestorOf(component);
        if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        }
        Component component2 = propertyDisplayer.getComponent();
        if (!(propertyDisplayer instanceof PropertyDisplayer_Editable)) {
            component2.setEnabled(this.isEnabled() && this.getProperty().canWrite());
        }
        component2.setForeground(this.getForeground());
        component2.setBackground(this.getBackground());
        if (component2 != this.inner) {
            object = this.getTreeLock();
            synchronized (object) {
                if (this.inner != null) {
                    this.remove(this.inner);
                }
                if (component2 != null) {
                    this.add(component2);
                    component2.invalidate();
                    this.inner = component2;
                }
            }
        }
        if (this.isShowing() && !(this.getParent() instanceof CellRendererPane)) {
            this.validate();
        }
        if (bl && this.isEnabled() && (this.preferences & 1) == 0) {
            this.requestFocus();
        }
        if ((!this.isEnabled() || (this.preferences & 1) != 0) && ((object = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == this.inner || this.inner instanceof Container && ((Container)this.inner).isAncestorOf((Component)object))) {
            this.transferFocusUpCycle();
        }
    }

    @Override
    public void doLayout() {
        this.layout();
    }

    @Override
    public void layout() {
        if (this.inner != null) {
            this.inner.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = !this.isDisplayable() && (this.preferences & 2) == 0 ? this.getRendererComponent(this.getProperty()).getComponent().getPreferredSize() : (this.inner != null ? this.inner.getPreferredSize() : PropUtils.getMinimumPanelSize());
        return dimension;
    }

    private void setDisplayer(PropertyDisplayer propertyDisplayer) {
        if (this.displayer != null) {
            this.detachFromDisplayer(this.displayer);
        }
        this.displayer = propertyDisplayer;
        if (propertyDisplayer != null) {
            this.attachToDisplayer(this.displayer);
        }
    }

    private void attachToDisplayer(PropertyDisplayer propertyDisplayer) {
        if (propertyDisplayer instanceof PropertyDisplayer_Inline) {
            this.updateDisplayerFromClientProps();
        }
        if (propertyDisplayer instanceof CustomEditorDisplayer) {
            ((CustomEditorDisplayer)propertyDisplayer).setRemoteEnvListener(this.getListener());
            ((CustomEditorDisplayer)propertyDisplayer).setRemoteEnvVetoListener(this.getListener());
        }
        if (propertyDisplayer instanceof EditablePropertyDisplayer) {
            ((EditablePropertyDisplayer)propertyDisplayer).setRemoteEnvListener(this.getListener());
            ((EditablePropertyDisplayer)propertyDisplayer).setRemoteEnvVetoListener(this.getListener());
            ((EditablePropertyDisplayer)propertyDisplayer).addActionListener(this.getListener());
            PropertyEnv propertyEnv = ((EditablePropertyDisplayer)propertyDisplayer).getPropertyEnv();
            if (propertyEnv != null) {
                propertyEnv.setFeatureDescriptor((FeatureDescriptor)this.getProperty());
            }
        }
    }

    private void detachFromDisplayer(PropertyDisplayer propertyDisplayer) {
        if (propertyDisplayer instanceof CustomEditorDisplayer) {
            ((CustomEditorDisplayer)propertyDisplayer).setRemoteEnvVetoListener(null);
        }
        if (propertyDisplayer instanceof EditablePropertyDisplayer) {
            ((EditablePropertyDisplayer)propertyDisplayer).setRemoteEnvVetoListener(null);
            ((EditablePropertyDisplayer)propertyDisplayer).removeActionListener(this.getListener());
        }
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (("flat".equals(string) || "radioButtonMax".equals(string) || "suppressCustomEditor".equals(string) || "useLabels".equals(string)) && this.displayer != null && this.displayer instanceof PropertyDisplayer_Inline) {
            this.updateDisplayerFromClientProp(string, object2);
        }
        super.firePropertyChange(string, object, object2);
    }

    private void updateDisplayerFromClientProp(String string, Object object) {
        PropertyDisplayer propertyDisplayer = this.getPropertyDisplayer();
        if (propertyDisplayer instanceof PropertyDisplayer_Inline) {
            PropertyDisplayer_Inline propertyDisplayer_Inline = (PropertyDisplayer_Inline)propertyDisplayer;
            if ("flat".equals(string)) {
                propertyDisplayer_Inline.setTableUI(Boolean.TRUE.equals(object));
                if (Boolean.TRUE.equals(object)) {
                    propertyDisplayer_Inline.setUseLabels(false);
                } else if (Boolean.FALSE.equals(object) && this.getClientProperty("useLabels") == null) {
                    propertyDisplayer_Inline.setUseLabels(true);
                }
            } else if ("radioButtonMax".equals(string)) {
                int n = object instanceof Integer ? (Integer)object : 0;
                propertyDisplayer_Inline.setRadioButtonMax(n);
            } else if ("suppressCustomEditor".equals(string)) {
                propertyDisplayer_Inline.setShowCustomEditorButton(!Boolean.TRUE.equals(object));
            } else if ("useLabels".equals(string)) {
                propertyDisplayer_Inline.setUseLabels(Boolean.TRUE.equals(object));
            }
        }
    }

    @Override
    public boolean isFocusable() {
        return super.isFocusable() && this.isEnabled() && (this.preferences & 1) == 0;
    }

    @Override
    public void requestFocus() {
        if (!this.isEnabled() || (this.preferences & 1) != 0) {
            return;
        }
        if (this.inner != null && this.inner.isEnabled()) {
            super.requestFocus();
            this.inner.requestFocus();
        }
    }

    private void updateDisplayerFromClientProps() {
        String[] stringArray = new String[]{"flat", "radioButtonMax", "suppressCustomEditor", "useLabels"};
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.getClientProperty(stringArray[i]);
            if (object == null) continue;
            this.updateDisplayerFromClientProp(stringArray[i], object);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004 && this.inner != null && this.inner.isEnabled() && this.inner.isFocusTraversable()) {
            this.inner.requestFocus();
        }
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    @Override
    public void addNotify() {
        this.attachToModel();
        if (this.displayer != null) {
            this.attachToDisplayer(this.displayer);
        }
        if (this.inner == null) {
            this.installDisplayerComponent();
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.detachFromModel();
        if (this.displayer != null && !(this.displayer instanceof RendererPropertyDisplayer)) {
            this.detachFromDisplayer(this.displayer);
            this.displayer = null;
        }
        if (null != this.inner && !(this.inner instanceof RendererPropertyDisplayer)) {
            this.remove(this.inner);
            this.inner = null;
        }
    }

    public int getPreferences() {
        return this.preferences;
    }

    public void setPreferences(int n) {
        if (n != this.preferences) {
            int n2 = this.preferences;
            this.preferences = n;
            this.hardReset();
            this.firePropertyChange(PROP_PREFERENCES, n2, n);
        }
    }

    public PropertyModel getModel() {
        if (this.model == null) {
            return new NodePropertyModel(this.getProperty(), null);
        }
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(PropertyModel propertyModel) {
        if (propertyModel != this.model) {
            this.settingModel = true;
            if (this.model != null && this.listener != null) {
                this.detachFromModel();
            }
            try {
                if (!this.initializing) {
                    this.setProperty(ModelProperty.toProperty(propertyModel));
                    this.model = propertyModel;
                    if (propertyModel != null && this.isDisplayable()) {
                        this.attachToModel();
                    }
                } else {
                    this.model = propertyModel;
                    this.attachToModel();
                }
            }
            finally {
                this.settingModel = false;
            }
        }
    }

    private final void attachToModel() {
        if (this.model != null) {
            this.model.addPropertyChangeListener(this.getListener());
        }
    }

    private final void detachFromModel() {
        if (this.model != null) {
            this.model.removePropertyChangeListener(this.getListener());
        }
    }

    Object[] getBeans() {
        return this.beans;
    }

    public final void setProperty(Node.Property property) {
        TTVEnvBridge tTVEnvBridge;
        Object object = this.getClientProperty("beanBridgeIdentifier");
        if (object != null && (tTVEnvBridge = TTVEnvBridge.findInstance(object)) != null) {
            this.beans = tTVEnvBridge.getCurrentBeans();
            tTVEnvBridge.clear();
        }
        if (property != this.prop) {
            this.prop = property;
            if (!this.settingModel) {
                this.model = null;
            }
            if (this.displayer != null) {
                if (this.displayer instanceof PropertyDisplayer_Mutable) {
                    ((PropertyDisplayer_Mutable)this.displayer).setProperty(property);
                } else {
                    this.hardReset();
                }
            }
        }
    }

    final void reset() {
        if ((this.preferences & 2) != 0) {
            this.getPropertyDisplayer().refresh();
        } else {
            this.hardReset();
        }
    }

    final void hardReset() {
        this.setDisplayer(this.findPropertyDisplayer());
        if (this.isDisplayable()) {
            this.installDisplayerComponent();
        }
    }

    public final Node.Property getProperty() {
        if (this.prop == null && this.model != null) {
            this.prop = ModelProperty.toProperty(this.model);
        }
        return this.prop;
    }

    public final Object getState() {
        if (this.displayer != null && this.displayer instanceof PropertyDisplayer_Editable) {
            return ((PropertyDisplayer_Editable)this.displayer).getPropertyEnv().getState();
        }
        PropertyEditor propertyEditor = this.propertyEditor();
        if (propertyEditor instanceof ExPropertyEditor) {
            ReusablePropertyEnv reusablePropertyEnv = this.reusableEnv;
            this.reusableModel.setProperty(this.prop);
            ((ExPropertyEditor)propertyEditor).attachEnv(reusablePropertyEnv);
            return reusablePropertyEnv.getState();
        }
        return PropertyEnv.STATE_VALID;
    }

    public void updateValue() {
        if (this.displayer != null && this.displayer instanceof PropertyDisplayer_Editable) {
            PropertyEnv propertyEnv = ((PropertyDisplayer_Editable)this.displayer).getPropertyEnv();
            if (PropertyEnv.STATE_NEEDS_VALIDATION.equals(propertyEnv.getState())) {
                propertyEnv.setState(PropertyEnv.STATE_VALID);
            }
            if (!this.changeImmediate) {
                this.commit();
            }
        }
    }

    @Deprecated
    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor();
    }

    private PropertyEditor propertyEditor() {
        PropertyEditor propertyEditor = null;
        if (this.displayer != null) {
            if (this.displayer instanceof CustomEditorDisplayer) {
                propertyEditor = ((CustomEditorDisplayer)this.displayer).getPropertyEditor();
            } else if (this.displayer instanceof EditablePropertyDisplayer) {
                propertyEditor = ((EditablePropertyDisplayer)this.displayer).getPropertyEditor();
            }
        }
        if (propertyEditor == null) {
            propertyEditor = PropUtils.getPropertyEditor(this.getProperty());
        }
        return propertyEditor;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.inner != null) {
            PropertyDisplayer propertyDisplayer = this.getPropertyDisplayer();
            if (propertyDisplayer instanceof PropertyDisplayer_Editable) {
                ((PropertyDisplayer_Editable)propertyDisplayer).setEnabled(bl);
            } else {
                this.hardReset();
            }
        }
    }

    public boolean isChangeImmediate() {
        return this.changeImmediate;
    }

    public void setChangeImmediate(boolean bl) {
        PropertyDisplayer propertyDisplayer;
        if (this.changeImmediate == bl) {
            return;
        }
        this.changeImmediate = bl;
        if (this.isShowing() && (propertyDisplayer = this.getPropertyDisplayer()) instanceof PropertyDisplayer_Editable) {
            ((PropertyDisplayer_Editable)propertyDisplayer).setUpdatePolicy(bl ? 1 : 2);
        }
        this.firePropertyChange("changeImmediate", bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public String toString() {
        if ((this.preferences & 2) != 0) {
            return super.toString() + " - " + PropertyPanel.prefsToString(this.getPreferences());
        }
        return this.getClass().getName() + System.identityHashCode(this) + PropertyPanel.prefsToString(this.getPreferences()) + " propertyRenderer: " + (this.inner == null ? " null " : this.inner.toString());
    }

    private static String prefsToString(int n) {
        StringBuffer stringBuffer = new StringBuffer(" prefs:");
        int[] nArray = new int[]{2, 4, 1};
        String[] stringArray = new String[]{"PREF_CUSTOM_EDITOR", "PREF_INPUT_STATE", "PREF_READ_ONLY"};
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & n) != 0) {
                stringBuffer.append(stringArray[i]);
            }
            if (bl && i != nArray.length - 1) {
                stringBuffer.append(",");
            }
            bl = true;
        }
        return stringBuffer.toString();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isGtk) {
            Color color = this.getBackground();
            if (color == null) {
                color = UIManager.getColor("control");
            }
            if (color == null) {
                color = Color.LIGHT_GRAY;
            }
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(graphics);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePropertyPanel();
        }
        return this.accessibleContext;
    }

    private static final class BridgeAccessor
    implements PropertyPanelBridge.Accessor {
        private final Reference<PropertyPanel> panelRef;

        public BridgeAccessor(PropertyPanel propertyPanel) {
            this.panelRef = new WeakReference<PropertyPanel>(propertyPanel);
        }

        @Override
        public boolean commit() {
            PropertyPanel propertyPanel = this.panelRef.get();
            if (propertyPanel != null) {
                return propertyPanel.commit();
            }
            return false;
        }
    }

    private class Listener
    implements PropertyChangeListener,
    VetoableChangeListener,
    ChangeListener,
    ActionListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof PropertyEnv) {
                PropertyPanel.this.firePropertyChange(PropertyPanel.PROP_STATE, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
            if (propertyChangeEvent.getSource() instanceof PropertyModel) {
                if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() == null) {
                    PropertyPanel.this.hardReset();
                } else {
                    PropertyPanel.this.reset();
                }
            }
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (PropertyPanel.this.inner == actionEvent.getSource() && "enterPressed".equals(actionEvent.getActionCommand()) && null != (object = PropertyPanel.this.getClientProperty("beanBridgeIdentifier")) && object instanceof CellEditor) {
                ((CellEditor)object).stopCellEditing();
            }
        }
    }

    private class AccessiblePropertyPanel
    extends JComponent.AccessibleJComponent {
        AccessiblePropertyPanel() {
            super(PropertyPanel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        @Override
        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null && PropertyPanel.this.model instanceof ExPropertyModel) {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)PropertyPanel.this.model).getFeatureDescriptor();
                string = NbBundle.getMessage(PropertyPanel.class, (String)"ACS_PropertyPanel", (Object)featureDescriptor.getDisplayName());
            }
            return string;
        }

        @Override
        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null && PropertyPanel.this.model instanceof ExPropertyModel) {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)PropertyPanel.this.model).getFeatureDescriptor();
                string = NbBundle.getMessage(PropertyPanel.class, (String)"ACSD_PropertyPanel", (Object)featureDescriptor.getShortDescription());
            }
            return string;
        }
    }

    private class CustomEditorProxyAction
    extends AbstractAction {
        private CustomEditorProxyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Action action = this.getWrapped();
            if (action != null) {
                action.actionPerformed(actionEvent);
            } else {
                Utilities.disabledActionBeep();
            }
        }

        private Action getWrapped() {
            Node.Property property = PropertyPanel.this.getProperty();
            EditablePropertyDisplayer editablePropertyDisplayer = PropertyPanel.this.getPropertyDisplayer() instanceof EditablePropertyDisplayer ? (EditablePropertyDisplayer)PropertyPanel.this.getPropertyDisplayer() : new EditablePropertyDisplayer(property);
            return editablePropertyDisplayer.getCustomEditorAction();
        }

        @Override
        public boolean isEnabled() {
            Action action = this.getWrapped();
            if (action != null) {
                return action.isEnabled();
            }
            return PropertyPanel.this.getProperty() != null;
        }
    }
}

