/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.MailEvent;

public abstract class Service {
    protected Session session;
    protected URLName url;
    protected boolean debug;
    private boolean connected = false;
    private ArrayList connectionListeners = null;

    protected Service(Session session, URLName url) {
        this.session = session;
        this.url = url;
        this.debug = session.getDebug();
    }

    public void connect() throws MessagingException {
        this.connect(null, null, null);
    }

    public void connect(String user, String password) throws MessagingException {
        this.connect(null, user, password);
    }

    public void connect(String host, String user, String password) throws MessagingException {
        this.connect(host, -1, user, password);
    }

    public void connect(String host, int port, String user, String password) throws MessagingException {
        String file;
        String protocol;
        boolean authenticated;
        boolean success;
        block31: {
            if (this.isConnected()) {
                throw new MessagingException("already connected");
            }
            success = false;
            authenticated = false;
            protocol = null;
            file = null;
            if (this.url != null) {
                protocol = this.url.getProtocol();
                if (host == null) {
                    host = this.url.getHost();
                }
                if (port == -1) {
                    port = this.url.getPort();
                }
                if (user == null) {
                    user = this.url.getUsername();
                    if (password == null) {
                        password = this.url.getPassword();
                    }
                } else if (password == null && user.equals(this.url.getUsername())) {
                    password = this.url.getPassword();
                }
                file = this.url.getFile();
            }
            if (protocol != null) {
                if (host == null) {
                    host = this.session.getProperty("mail." + protocol + ".host");
                }
                if (user == null) {
                    user = this.session.getProperty("mail." + protocol + ".user");
                }
            }
            if (host == null) {
                host = this.session.getProperty("mail.host");
            }
            if (user == null) {
                user = this.session.getProperty("mail.user");
            }
            if (user == null) {
                try {
                    user = System.getProperty("user.name");
                }
                catch (SecurityException e) {
                    if (!this.debug) break block31;
                    e.printStackTrace();
                }
            }
        }
        if (password == null && this.url != null) {
            this.setURLName(new URLName(protocol, host, port, file, user, password));
            PasswordAuthentication auth = this.session.getPasswordAuthentication(this.getURLName());
            if (auth != null) {
                if (user == null) {
                    user = auth.getUserName();
                    password = auth.getPassword();
                } else if (user.equals(auth.getUserName())) {
                    password = auth.getPassword();
                }
            } else {
                authenticated = true;
            }
        }
        AuthenticationFailedException afex = null;
        try {
            success = this.protocolConnect(host, port, user, password);
        }
        catch (AuthenticationFailedException afex2) {
            afex = afex2;
        }
        if (!success) {
            InetAddress address = null;
            try {
                address = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            PasswordAuthentication auth = this.session.requestPasswordAuthentication(address, port, protocol, null, user);
            if (auth != null) {
                user = auth.getUserName();
                password = auth.getPassword();
                success = this.protocolConnect(host, port, user, password);
            }
        }
        if (!success) {
            if (afex != null) {
                throw afex;
            }
            throw new AuthenticationFailedException();
        }
        this.setURLName(new URLName(protocol, host, port, file, user, password));
        if (authenticated) {
            PasswordAuthentication auth = new PasswordAuthentication(user, password);
            this.session.setPasswordAuthentication(this.getURLName(), auth);
        }
        this.setConnected(true);
        this.notifyConnectionListeners(1);
    }

    protected boolean protocolConnect(String host, int port, String user, String password) throws MessagingException {
        return false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected void setConnected(boolean connected) {
        this.connected = connected;
    }

    public synchronized void close() throws MessagingException {
        this.setConnected(false);
        this.notifyConnectionListeners(3);
    }

    public URLName getURLName() {
        if (this.url != null && (this.url.getPassword() != null || this.url.getFile() != null)) {
            return new URLName(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), null, this.url.getUsername(), null);
        }
        return this.url;
    }

    protected void setURLName(URLName url) {
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener l) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new ArrayList();
        }
        ArrayList arrayList = this.connectionListeners;
        synchronized (arrayList) {
            this.connectionListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener l) {
        if (this.connectionListeners != null) {
            ArrayList arrayList = this.connectionListeners;
            synchronized (arrayList) {
                this.connectionListeners.remove(l);
            }
        }
    }

    protected void notifyConnectionListeners(int type) {
        ConnectionEvent event = new ConnectionEvent(this, type);
        switch (type) {
            case 1: {
                this.fireOpened(event);
                break;
            }
            case 2: {
                this.fireDisconnected(event);
                break;
            }
            case 3: {
                this.fireClosed(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireOpened(ConnectionEvent event) {
        if (this.connectionListeners != null) {
            ConnectionListener[] l = null;
            ArrayList arrayList = this.connectionListeners;
            synchronized (arrayList) {
                l = new ConnectionListener[this.connectionListeners.size()];
                this.connectionListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].opened(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireDisconnected(ConnectionEvent event) {
        if (this.connectionListeners != null) {
            ConnectionListener[] l = null;
            ArrayList arrayList = this.connectionListeners;
            synchronized (arrayList) {
                l = new ConnectionListener[this.connectionListeners.size()];
                this.connectionListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].disconnected(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireClosed(ConnectionEvent event) {
        if (this.connectionListeners != null) {
            ConnectionListener[] l = null;
            ArrayList arrayList = this.connectionListeners;
            synchronized (arrayList) {
                l = new ConnectionListener[this.connectionListeners.size()];
                this.connectionListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].closed(event);
            }
        }
    }

    public String toString() {
        URLName urlName = this.getURLName();
        return urlName != null ? urlName.toString() : super.toString();
    }

    protected void queueEvent(MailEvent event, Vector vector) {
        Iterator i = vector.iterator();
        while (i.hasNext()) {
            event.dispatch(i.next());
        }
    }
}

