/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Random;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;

final class IsoShapeReader
extends VolumeDataReader {
    private int psi_n = 2;
    private int psi_l = 1;
    private int psi_m = 1;
    private float psi_Znuc = 1.0f;
    private float sphere_radiusAngstroms;
    private int monteCarloCount;
    private Random random;
    private boolean allowNegative = true;
    private double[] rfactor = new double[10];
    private double[] pfactor = new double[10];
    private static final double A0 = 0.52918;
    private static final double ROOT2 = 1.414214;
    private static final float ATOMIC_ORBITAL_ZERO_CUT_OFF = 1.0E-7f;
    private float radius;
    private final P3 ptPsi = new P3();
    private static final float[] fact = new float[20];
    private double psi_normalization = 1.0 / (2.0 * Math.sqrt(Math.PI));
    private double aoMax;
    private double aoMax2;
    private double angMax2;
    private V3 planeU;
    private V3 planeV;
    private P3 planeCenter;
    private float planeRadius;
    private double rnl;
    private boolean surfaceDone;
    private int nTries;

    IsoShapeReader() {
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initVDR(sg);
        Object o = sg.getReaderData();
        if (o instanceof Float) {
            this.sphere_radiusAngstroms = ((Float)o).floatValue();
        } else {
            this.sphere_radiusAngstroms = 0.0f;
            float[] data = (float[])o;
            this.psi_n = (int)data[0];
            this.psi_l = (int)data[1];
            this.psi_m = (int)data[2];
            this.psi_Znuc = data[3];
            this.monteCarloCount = (int)data[4];
        }
    }

    @Override
    protected void setup(boolean isMapData) {
        this.volumeData.sr = this;
        this.precalculateVoxelData = false;
        this.isQuiet = true;
        if (Float.isNaN(this.center.x)) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
        String type = "sphere";
        switch (this.dataType) {
            case 1294: {
                this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
                this.autoScaleOrbital();
                this.ptsPerAngstrom = 5.0f;
                this.maxGrid = 40;
                type = "hydrogen-like orbital";
                if (this.monteCarloCount > 0) {
                    this.vertexDataOnly = true;
                    this.random = new Random(this.params.randomSeed);
                    break;
                }
                this.isQuiet = false;
                break;
            }
            case 70: 
            case 71: {
                type = "lp";
                this.vertexDataOnly = true;
                this.radius = 0.0f;
                this.ptsPerAngstrom = 1.0f;
                this.maxGrid = 1;
                break;
            }
            case 68: {
                this.allowNegative = false;
                this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
                this.psi_normalization = 1.0;
                this.radius = 1.1f * this.eccentricityRatio * this.eccentricityScale;
                if (this.eccentricityScale > 0.0f && this.eccentricityScale < 1.0f) {
                    this.radius /= this.eccentricityScale;
                }
                this.ptsPerAngstrom = 10.0f;
                this.maxGrid = 21;
                type = "lobe";
                break;
            }
            case 67: {
                type = "ellipsoid(thermal)";
                this.radius = 3.0f * this.sphere_radiusAngstroms;
                this.ptsPerAngstrom = 10.0f;
                this.maxGrid = 22;
                break;
            }
            case 74: {
                if (!isMapData && this.monteCarloCount == 0) break;
                type = "geodesic";
            }
            case 66: {
                if (type.equals("sphere")) {
                    type = "ellipsoid";
                }
            }
            default: {
                this.radius = 1.2f * this.sphere_radiusAngstroms * this.eccentricityScale;
                this.ptsPerAngstrom = 10.0f;
                this.maxGrid = 22;
            }
        }
        if (this.monteCarloCount == 0) {
            this.setVolumeData();
        }
        this.setHeader(type + "\n");
    }

    @Override
    protected void setVolumeData() {
        this.setVoxelRange(0, -this.radius, this.radius, this.ptsPerAngstrom, this.maxGrid, 0.0f);
        this.setVoxelRange(1, -this.radius, this.radius, this.ptsPerAngstrom, this.maxGrid, 0.0f);
        if (this.allowNegative) {
            this.setVoxelRange(2, -this.radius, this.radius, this.ptsPerAngstrom, this.maxGrid, 0.0f);
        } else {
            this.setVoxelRange(2, 0.0f, this.radius / this.eccentricityRatio, this.ptsPerAngstrom, this.maxGrid, 0.0f);
        }
    }

    @Override
    public float getValue(int x, int y, int z, int ptyz) {
        this.volumeData.voxelPtToXYZ(x, y, z, (T3)this.ptPsi);
        return this.getValueAtPoint((T3)this.ptPsi, false);
    }

    @Override
    public float getValueAtPoint(T3 pt, boolean getSource) {
        this.ptTemp.sub2(pt, (T3)this.center);
        if (this.isEccentric) {
            this.eccentricityMatrixInverse.rotate((T3)this.ptTemp);
        }
        if (this.isAnisotropic) {
            this.ptTemp.x /= this.anisotropy[0];
            this.ptTemp.y /= this.anisotropy[1];
            this.ptTemp.z /= this.anisotropy[2];
        }
        if (this.sphere_radiusAngstroms > 0.0f) {
            if (this.params.anisoB != null) {
                return this.sphere_radiusAngstroms - (float)Math.sqrt(this.ptTemp.x * this.ptTemp.x + this.ptTemp.y * this.ptTemp.y + this.ptTemp.z * this.ptTemp.z) / (float)Math.sqrt(this.params.anisoB[0] * this.ptTemp.x * this.ptTemp.x + this.params.anisoB[1] * this.ptTemp.y * this.ptTemp.y + this.params.anisoB[2] * this.ptTemp.z * this.ptTemp.z + this.params.anisoB[3] * this.ptTemp.x * this.ptTemp.y + this.params.anisoB[4] * this.ptTemp.x * this.ptTemp.z + this.params.anisoB[5] * this.ptTemp.y * this.ptTemp.z);
            }
            return this.sphere_radiusAngstroms - (float)Math.sqrt(this.ptTemp.x * this.ptTemp.x + this.ptTemp.y * this.ptTemp.y + this.ptTemp.z * this.ptTemp.z);
        }
        float value = (float)this.hydrogenAtomPsi(this.ptTemp);
        if (Math.abs(value) < 1.0E-7f) {
            value = 0.0f;
        }
        return this.allowNegative || value >= 0.0f ? value : 0.0f;
    }

    private void setHeader(String line1) {
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append(line1);
        if (this.sphere_radiusAngstroms > 0.0f) {
            this.jvxlFileHeaderBuffer.append(" rad=").appendF(this.sphere_radiusAngstroms);
        } else {
            this.jvxlFileHeaderBuffer.append(" n=").appendI(this.psi_n).append(", l=").appendI(this.psi_l).append(", m=").appendI(this.psi_m).append(" Znuc=").appendF(this.psi_Znuc).append(" res=").appendF(this.ptsPerAngstrom).append(" rad=").appendF(this.radius);
        }
        this.jvxlFileHeaderBuffer.append(this.isAnisotropic ? " anisotropy=(" + this.anisotropy[0] + "," + this.anisotropy[1] + "," + this.anisotropy[2] + ")\n" : "\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    private void calcFactors(int n, int el, int m) {
        int p;
        int abm = Math.abs(m);
        double NnlLnl = Math.pow((double)(2.0f * this.psi_Znuc / (float)n) / 0.52918, 1.5) * Math.sqrt(fact[n - el - 1] * fact[n + el] / 2.0f / (float)n);
        double Plm = Math.pow(2.0, -el) * (double)fact[el] * (double)fact[el + abm] * Math.sqrt((float)(2 * el + 1) * fact[el - abm] / 2.0f / fact[el + abm]);
        for (p = 0; p <= n - el - 1; ++p) {
            this.rfactor[p] = NnlLnl / (double)fact[p] / (double)fact[n - el - p - 1] / (double)fact[2 * el + p + 1];
        }
        for (p = abm; p <= el; ++p) {
            this.pfactor[p] = Math.pow(-1.0, el - p) * Plm / (double)fact[p] / (double)fact[el + abm - p] / (double)fact[el - p] / (double)fact[p - abm];
        }
    }

    private void autoScaleOrbital() {
        double min;
        double d;
        this.aoMax = 0.0;
        float rmax = 0.0f;
        this.aoMax2 = 0.0;
        float rmax2 = 0.0f;
        if (this.params.distance == 0.0f) {
            for (int ir = 0; ir < 1000; ++ir) {
                float r = (float)ir / 10.0f;
                d = Math.abs(this.radialPart(r));
                if (Logger.debugging) {
                    Logger.debug((String)("R\t" + r + "\t" + d));
                }
                if (d >= this.aoMax) {
                    rmax = r;
                    this.aoMax = d;
                }
                if (!((d *= d * (double)r * (double)r) >= this.aoMax2)) continue;
                rmax2 = r;
                this.aoMax2 = d;
            }
        } else {
            this.aoMax = Math.abs(this.radialPart(this.params.distance));
            this.aoMax2 = this.aoMax * this.aoMax * (double)this.params.distance * (double)this.params.distance;
            rmax = rmax2 = this.params.distance;
        }
        Logger.info((String)("Atomic Orbital radial max = " + this.aoMax + " at " + rmax));
        Logger.info((String)("Atomic Orbital r2R2 max = " + this.aoMax2 + " at " + rmax2));
        if (this.monteCarloCount >= 0) {
            this.angMax2 = 0.0;
            for (float ang = 0.0f; ang < 180.0f; ang += 1.0f) {
                double th = (double)ang / (Math.PI * 2);
                d = Math.abs(this.angularPart(th, 0.0, 0));
                if (Logger.debugging) {
                    Logger.debug((String)("A\t" + ang + "\t" + d));
                }
                if (!(d > this.angMax2)) continue;
                this.angMax2 = d;
            }
            this.angMax2 *= this.angMax2;
            if (this.psi_m != 0) {
                this.angMax2 *= 2.0;
            }
            Logger.info((String)("Atomic Orbital phi^2theta^2 max = " + this.angMax2));
        }
        if (this.params.cutoff == 0.0f) {
            min = this.monteCarloCount > 0 ? this.aoMax * (double)0.01f : (double)0.01f;
        } else if (this.monteCarloCount > 0) {
            this.aoMax = Math.abs(this.params.cutoff);
            min = this.aoMax * (double)0.01f;
        } else {
            min = Math.abs(this.params.cutoff / 2.0f);
            if (this.params.isSquared) {
                min = Math.sqrt(min / 2.0);
            }
        }
        float r0 = 0.0f;
        int ir = 1000;
        while (--ir >= 0) {
            float r = (float)ir / 10.0f;
            d = Math.abs(this.radialPart(r));
            if (d >= min) {
                r0 = r;
                break;
            }
            --ir;
        }
        this.radius = r0 + (float)(this.monteCarloCount == 0 ? 1 : 0);
        if (this.isAnisotropic) {
            float aMax = 0.0f;
            int i = 3;
            while (--i >= 0) {
                if (!(this.anisotropy[i] > aMax)) continue;
                aMax = this.anisotropy[i];
            }
            this.radius *= aMax;
        }
        Logger.info((String)("Atomic Orbital radial extent set to " + this.radius + " for cutoff " + this.params.cutoff));
        if (this.params.thePlane != null && this.monteCarloCount > 0) {
            this.planeCenter = new P3();
            this.planeU = new V3();
            Measure.getPlaneProjection((P3)this.center, (P4)this.params.thePlane, (P3)this.planeCenter, (V3)this.planeU);
            this.planeU.set(this.params.thePlane.x, this.params.thePlane.y, this.params.thePlane.z);
            this.planeU.normalize();
            this.planeV = V3.new3((float)1.0f, (float)0.0f, (float)0.0f);
            if (Math.abs(this.planeU.dot((T3)this.planeV)) > 0.5f) {
                this.planeV.set(0.0f, 1.0f, 0.0f);
            }
            this.planeV.cross((T3)this.planeU, (T3)this.planeV);
            this.planeU.cross((T3)this.planeU, (T3)this.planeV);
            this.aoMax2 = 0.0;
            d = this.center.distance((T3)this.planeCenter);
            if (d < (double)this.radius) {
                this.planeRadius = (float)Math.sqrt((double)(this.radius * this.radius) - d * d);
                ir = (int)(this.planeRadius * 10.0f);
                for (int ix = -ir; ix <= ir; ++ix) {
                    for (int iy = -ir; iy <= ir; ++iy) {
                        this.ptPsi.setT((T3)this.planeU);
                        this.ptPsi.scale((float)ix / 10.0f);
                        this.ptPsi.scaleAdd2((float)iy / 10.0f, (T3)this.planeV, (T3)this.ptPsi);
                        d = this.hydrogenAtomPsi(this.ptPsi);
                        d = Math.abs(this.hydrogenAtomPsi(this.ptPsi));
                        if (!(d > this.aoMax2)) continue;
                        this.aoMax2 = d;
                    }
                }
                this.aoMax2 = this.aoMax2 < (double)0.001f ? 0.0 : (this.aoMax2 *= this.aoMax2);
            }
        }
    }

    private double radialPart(double r) {
        double rho = 2.0 * (double)this.psi_Znuc * r / (double)this.psi_n / 0.52918;
        double sum = 0.0;
        for (int p = 0; p <= this.psi_n - this.psi_l - 1; ++p) {
            sum += Math.pow(-rho, p) * this.rfactor[p];
        }
        return Math.exp(-rho / 2.0) * Math.pow(rho, this.psi_l) * sum;
    }

    private double hydrogenAtomPsi(P3 pt) {
        double x2y2 = pt.x * pt.x + pt.y * pt.y;
        this.rnl = this.radialPart(Math.sqrt(x2y2 + (double)(pt.z * pt.z)));
        double ph = Math.atan2(pt.y, pt.x);
        double th = Math.atan2(Math.sqrt(x2y2), pt.z);
        double theta_lm_phi_m = this.angularPart(th, ph, this.psi_m);
        return this.rnl * theta_lm_phi_m;
    }

    private double angularPart(double th, double ph, int m) {
        double theta_lm;
        double cth = Math.cos(th);
        double sth = Math.sin(th);
        boolean isS = m == 0 && this.psi_l == 0;
        int abm = Math.abs(m);
        double sum = 0.0;
        if (isS) {
            sum = this.pfactor[0];
        } else {
            for (int p = abm; p <= this.psi_l; ++p) {
                sum += (p == abm ? 1.0 : Math.pow(1.0 + cth, p - abm)) * (p == this.psi_l ? 1.0 : Math.pow(1.0 - cth, this.psi_l - p)) * this.pfactor[p];
            }
        }
        double d = theta_lm = abm == 0 ? sum : Math.abs(Math.pow(sth, abm)) * sum;
        double phi_m = m == 0 ? 1.0 : (m > 0 ? Math.cos((double)m * ph) * 1.414214 : Math.sin((double)m * ph) * 1.414214);
        return Math.abs(phi_m) < 1.0E-10 ? 0.0 : theta_lm * phi_m * this.psi_normalization;
    }

    private void createMonteCarloOrbital() {
        if (this.surfaceDone || this.aoMax2 == 0.0 || this.params.distance > this.radius) {
            return;
        }
        boolean isS = this.psi_m == 0 && this.psi_l == 0;
        this.surfaceDone = true;
        float rave = 0.0f;
        this.nTries = 0;
        int i = 0;
        while (i < this.monteCarloCount) {
            block9: {
                float value;
                block10: {
                    block6: {
                        double phi;
                        double ap;
                        double r;
                        block8: {
                            block7: {
                                if (this.params.thePlane != null) break block6;
                                if (this.params.distance != 0.0f) break block7;
                                r = this.random.nextDouble() * (double)this.radius;
                                double rp = r * this.radialPart(r);
                                if (!(rp * rp <= this.aoMax2 * this.random.nextDouble())) break block8;
                                break block9;
                            }
                            r = this.params.distance;
                        }
                        double u = this.random.nextDouble();
                        double v = this.random.nextDouble();
                        double theta = Math.PI * 2 * u;
                        double cosPhi = 2.0 * v - 1.0;
                        if (!isS && (ap = this.angularPart(phi = Math.acos(cosPhi), theta, this.psi_m)) * ap <= this.angMax2 * this.random.nextDouble()) break block9;
                        double sinPhi = Math.sin(Math.acos(cosPhi));
                        double x = r * Math.cos(theta) * sinPhi;
                        double y = r * Math.sin(theta) * sinPhi;
                        double z = r * cosPhi;
                        this.ptPsi.set((float)x, (float)y, (float)z);
                        this.ptPsi.add((T3)this.center);
                        value = this.getValueAtPoint((T3)this.ptPsi, false);
                        break block10;
                    }
                    this.ptPsi.setT((T3)this.planeU);
                    this.ptPsi.scale(this.random.nextFloat() * this.planeRadius * 2.0f - this.planeRadius);
                    this.ptPsi.scaleAdd2(this.random.nextFloat() * this.planeRadius * 2.0f - this.planeRadius, (T3)this.planeV, (T3)this.ptPsi);
                    this.ptPsi.add((T3)this.planeCenter);
                    value = this.getValueAtPoint((T3)this.ptPsi, false);
                    if ((double)(value * value) <= this.aoMax2 * (double)this.random.nextFloat()) break block9;
                }
                rave += this.ptPsi.distance((T3)this.center);
                this.addVC((T3)this.ptPsi, value, 0, true);
                ++i;
            }
            ++this.nTries;
        }
        if (this.params.distance == 0.0f) {
            Logger.info((String)("Atomic Orbital mean radius = " + rave / (float)this.monteCarloCount + " for " + this.monteCarloCount + " points (" + this.nTries + " tries)"));
        }
    }

    @Override
    protected void readSurfaceData(boolean isMapData) throws Exception {
        switch (this.params.dataType) {
            case 1294: {
                if (this.monteCarloCount <= 0) break;
                this.createMonteCarloOrbital();
                return;
            }
            case 70: 
            case 71: {
                this.ptPsi.set(0.0f, 0.0f, this.eccentricityScale / 2.0f);
                this.eccentricityMatrixInverse.rotate((T3)this.ptPsi);
                this.ptPsi.add((T3)this.center);
                this.addVC((T3)this.center, 0.0f, 0, true);
                this.addVC((T3)this.ptPsi, 0.0f, 0, true);
                this.addTriangleCheck(0, 0, 0, 0, 0, false, 0);
                return;
            }
            case 74: {
                if (isMapData) break;
                this.createGeodesic();
                return;
            }
        }
        this.readSurfaceDataVDR(isMapData);
    }

    private void createGeodesic() {
        MeshSurface ms = MeshSurface.getSphereData((int)4);
        T3[] pts = ms.altVertices;
        for (int i = 0; i < pts.length; ++i) {
            P3 pt = P3.newP((T3)pts[i]);
            pt.scale(this.params.distance);
            pt.add((T3)this.center);
            this.addVC((T3)pt, 0.0f, i, false);
        }
        int[][] faces = ms.pis;
        for (int i = 0; i < faces.length; ++i) {
            int[] face = faces[i];
            this.addTriangleCheck(face[0], face[1], face[2], 7, 7, false, 0);
        }
    }

    static {
        IsoShapeReader.fact[0] = 1.0f;
        for (int i = 1; i < 20; ++i) {
            IsoShapeReader.fact[i] = fact[i - 1] * (float)i;
        }
    }
}

