/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.server;

import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegistryKeepAliveRunner
implements Runnable {
    private static final Log log = LogFactory.getLog(RegistryKeepAliveRunner.class);
    private String namingURL;
    private int registryPort;
    private ICacheEventLogger cacheEventLogger;

    public RegistryKeepAliveRunner(String registryHost, int registryPort, String serviceName) {
        this.namingURL = RemoteUtils.getNamingURL(registryHost, registryPort, serviceName);
        this.registryPort = registryPort;
    }

    @Override
    public void run() {
        this.checkAndRestoreIfNeeded();
    }

    protected void checkAndRestoreIfNeeded() {
        if (log.isDebugEnabled()) {
            log.debug("looking up server " + this.namingURL);
        }
        try {
            Remote obj = Naming.lookup(this.namingURL);
            String message = "RMI registry looks fine.  Found [" + obj + "] in registry [" + this.namingURL + "]";
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "Naming.lookup", message);
            }
            if (log.isDebugEnabled()) {
                log.debug(message);
            }
        }
        catch (Exception ex) {
            String message = "Problem finding server at [" + this.namingURL + "].  Will attempt to start registry and rebind.";
            log.error(message, ex);
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "Naming.lookup", message + ":" + ex.getMessage());
            }
            this.createAndRegister(this.namingURL);
        }
    }

    protected void createAndRegister(String registry) {
        this.createReqistry(registry);
        this.registerServer(registry);
    }

    protected void createReqistry(String registry) {
        Registry reg = RemoteUtils.createRegistry(this.registryPort);
        if (this.cacheEventLogger != null) {
            if (reg != null) {
                this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "createRegistry", "Successfully created registry [" + registry + "].");
            } else {
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "createRegistry", "Could not start registry [" + registry + "].");
            }
        }
    }

    protected void registerServer(String registry) {
        block4: {
            try {
                RemoteCacheServerFactory.registerServer(registry, RemoteCacheServerFactory.getRemoteCacheServer());
                String message = "Successfully rebound server to registry [" + registry + "].";
                if (this.cacheEventLogger != null) {
                    this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "registerServer", message);
                }
                if (log.isInfoEnabled()) {
                    log.info(message);
                }
            }
            catch (RemoteException e) {
                String message = "Could not rebind server to registry [" + registry + "].";
                log.error(message, e);
                if (this.cacheEventLogger == null) break block4;
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "registerServer", message + ":" + e.getMessage());
            }
        }
    }

    public void setCacheEventLogger(ICacheEventLogger cacheEventLogger) {
        this.cacheEventLogger = cacheEventLogger;
    }
}

