/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public final class AboutAction
extends JosmAction {
    public AboutAction() {
        super(I18n.tr("About", new Object[0]), "logo", I18n.tr("Display the about screen.", new Object[0]), Shortcut.registerShortcut("system:about", I18n.tr("About", new Object[0]), 112, 5005), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTabbedPane about = new JTabbedPane();
        Version version = Version.getInstance();
        JosmTextArea readme = new JosmTextArea();
        readme.setFont(GuiHelper.getMonospacedFont(readme));
        readme.setEditable(false);
        this.setTextFromResourceFile(readme, "/README");
        readme.setCaretPosition(0);
        JosmTextArea revision = new JosmTextArea();
        revision.setFont(GuiHelper.getMonospacedFont(revision));
        revision.setEditable(false);
        revision.setText(version.getReleaseAttributes());
        revision.setCaretPosition(0);
        JosmTextArea contribution = new JosmTextArea();
        contribution.setEditable(false);
        this.setTextFromResourceFile(contribution, "/CONTRIBUTION");
        contribution.setCaretPosition(0);
        JosmTextArea license = new JosmTextArea();
        license.setEditable(false);
        this.setTextFromResourceFile(license, "/LICENSE");
        license.setCaretPosition(0);
        JPanel info = new JPanel(new GridBagLayout());
        JMultilineLabel label = new JMultilineLabel("<html><h1>JOSM \u2013 " + I18n.tr("Java OpenStreetMap Editor", new Object[0]) + "</h1><p style='font-size:75%'></p><p>" + I18n.tr("Version {0}", version.getVersionString()) + "</p><p style='font-size:50%'></p><p>" + I18n.tr("Last change at {0}", version.getTime()) + "</p><p style='font-size:50%'></p><p>" + I18n.tr("Java Version {0}", System.getProperty("java.version")) + "</p><p style='font-size:50%'></p></html>");
        info.add((Component)label, GBC.eol().fill(2).insets(10, 0, 0, 0));
        info.add((Component)new JLabel(I18n.tr("Homepage", new Object[0])), GBC.std().insets(10, 0, 10, 0));
        info.add((Component)new UrlLabel(Main.getJOSMWebsite(), 2), GBC.eol().fill(2));
        info.add(GBC.glue(0, 5), GBC.eol());
        about.addTab(I18n.tr("Info", new Object[0]), info);
        about.addTab(I18n.tr("Readme", new Object[0]), AboutAction.createScrollPane(readme));
        about.addTab(I18n.tr("Revision", new Object[0]), AboutAction.createScrollPane(revision));
        about.addTab(I18n.tr("Contribution", new Object[0]), AboutAction.createScrollPane(contribution));
        about.addTab(I18n.tr("License", new Object[0]), AboutAction.createScrollPane(license));
        about.addTab(I18n.tr("Plugins", new Object[0]), new JScrollPane(PluginHandler.getInfoPanel()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setPreferredSize(new Dimension(890, 300));
        panel.add((Component)new JLabel("", ImageProvider.get("logo.svg", ImageProvider.ImageSizes.ABOUT_LOGO), 0), GBC.std().insets(0, 5, 0, 0));
        panel.add((Component)about, GBC.std().fill());
        GuiHelper.prepareResizeableOptionPane(panel, panel.getPreferredSize());
        int ret = new ExtendedDialog(Main.parent, I18n.tr("About JOSM...", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Report bug", new Object[0])).setButtonIcons("ok", "bug").setContent(panel, false).showDialog().getValue();
        if (2 == ret) {
            MainApplication.getMenu().reportbug.actionPerformed(null);
        }
    }

    private void setTextFromResourceFile(JTextArea ta, String filePath) {
        InputStream is = this.getClass().getResourceAsStream(filePath);
        if (is == null) {
            AboutAction.displayErrorMessage(ta, I18n.tr("Failed to locate resource ''{0}''.", filePath));
        } else {
            try (InputStreamReader reader = new InputStreamReader(is, "UTF-8");
                 BufferedReader br = new BufferedReader(reader);){
                String line;
                while ((line = br.readLine()) != null) {
                    ta.append(line + '\n');
                }
            }
            catch (IOException e) {
                Logging.warn(e);
                AboutAction.displayErrorMessage(ta, I18n.tr("Failed to load resource ''{0}'', error is {1}.", filePath, e.toString()));
            }
        }
    }

    private static void displayErrorMessage(JTextArea ta, String msg) {
        Logging.warn(msg);
        ta.setForeground(new Color(200, 0, 0));
        ta.setText(msg);
    }

    private static JScrollPane createScrollPane(JosmTextArea area) {
        area.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        area.setOpaque(false);
        JScrollPane sp = new JScrollPane(area);
        sp.setBorder(null);
        sp.setOpaque(false);
        return sp;
    }
}

