/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public abstract class OsmPrimitive
extends AbstractPrimitive
implements Comparable<OsmPrimitive>,
TemplateEngineDataProvider {
    private static final String SPECIAL_VALUE_ID = "id";
    private static final String SPECIAL_VALUE_LOCAL_NAME = "localname";
    static volatile SearchCompiler.Match directionKeys;
    private static volatile SearchCompiler.Match reversedDirectionKeys;
    public StyleCache mappaintStyle;
    private short mappaintCacheIdx;
    private DataSet dataSet;
    private static volatile Collection<String> workinprogress;
    private static volatile Collection<String> uninteresting;
    private static volatile Collection<String> discardable;
    private Object referrers;

    public static <T extends OsmPrimitive> List<T> getFilteredList(Collection<OsmPrimitive> list, Class<T> type) {
        if (list == null) {
            return Collections.emptyList();
        }
        LinkedList<OsmPrimitive> ret = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive p : list) {
            if (!type.isInstance(p)) continue;
            ret.add((OsmPrimitive)type.cast(p));
        }
        return ret;
    }

    public static <T extends OsmPrimitive> Set<T> getFilteredSet(Collection<OsmPrimitive> set, Class<T> type) {
        LinkedHashSet<OsmPrimitive> ret = new LinkedHashSet<OsmPrimitive>();
        if (set != null) {
            for (OsmPrimitive p : set) {
                if (!type.isInstance(p)) continue;
                ret.add((OsmPrimitive)type.cast(p));
            }
        }
        return ret;
    }

    public static Set<OsmPrimitive> getReferrer(Collection<? extends OsmPrimitive> primitives) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        if (primitives == null || primitives.isEmpty()) {
            return ret;
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            ret.addAll(osmPrimitive.getReferrers());
        }
        return ret;
    }

    protected OsmPrimitive(long id, boolean allowNegativeId) {
        if (allowNegativeId) {
            this.id = id;
        } else {
            if (id < 0L) {
                throw new IllegalArgumentException(MessageFormat.format("Expected ID >= 0. Got {0}.", id));
            }
            this.id = id == 0L ? OsmPrimitive.generateUniqueId() : id;
        }
        this.version = 0;
        this.setIncomplete(id > 0L);
    }

    protected OsmPrimitive(long id, int version, boolean allowNegativeId) {
        this(id, allowNegativeId);
        this.version = id > 0L ? version : 0;
        this.setIncomplete(id > 0L && version == 0);
    }

    public void clearCachedStyle() {
        this.mappaintStyle = null;
    }

    public final boolean isCachedStyleUpToDate() {
        return this.mappaintStyle != null && this.mappaintCacheIdx == this.dataSet.getMappaintCacheIndex();
    }

    public final void declareCachedStyleUpToDate() {
        this.mappaintCacheIdx = this.dataSet.getMappaintCacheIndex();
    }

    @Deprecated
    public final short getMappaintCacheIdx() {
        return this.mappaintCacheIdx;
    }

    @Deprecated
    public final void setMappaintCacheIdx(short mappaintCacheIdx) {
        this.mappaintCacheIdx = mappaintCacheIdx;
    }

    void setDataset(DataSet dataSet) {
        if (this.dataSet != null && dataSet != null && this.dataSet != dataSet) {
            throw new DataIntegrityProblemException("Primitive cannot be included in more than one Dataset");
        }
        this.dataSet = dataSet;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void checkDataset() {
        if (this.dataSet == null) {
            throw new DataIntegrityProblemException("Primitive must be part of the dataset: " + this.toString());
        }
    }

    protected final void checkDatasetNotReadOnly() {
        if (this.dataSet != null && this.dataSet.isLocked()) {
            throw new DataIntegrityProblemException("Primitive cannot be modified in read-only dataset: " + this.toString());
        }
    }

    protected boolean writeLock() {
        if (this.dataSet != null) {
            this.dataSet.beginUpdate();
            return true;
        }
        return false;
    }

    protected void writeUnlock(boolean locked) {
        if (locked) {
            this.dataSet.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOsmId(long id, int version) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            if (id <= 0L) {
                throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", id));
            }
            if (version <= 0) {
                throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", version));
            }
            if (this.dataSet != null && id != this.id) {
                DataSet datasetCopy = this.dataSet;
                datasetCopy.removePrimitive(this);
                this.id = id;
                datasetCopy.addPrimitive(this);
            }
            super.setOsmId(id, version);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public void clearOsmMetadata() {
        if (this.dataSet != null) {
            throw new DataIntegrityProblemException("Method cannot be called after primitive was added to the dataset");
        }
        super.clearOsmMetadata();
    }

    @Override
    public void setUser(User user) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setUser(user);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChangesetId(int changesetId) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            int old = this.changesetId;
            super.setChangesetId(changesetId);
            if (this.dataSet != null) {
                this.dataSet.fireChangesetIdChanged(this, old, changesetId);
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public void setTimestamp(Date timestamp) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setTimestamp(timestamp);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    private void updateFlagsNoLock(short flag, boolean value) {
        super.updateFlags(flag, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateFlags(short flag, boolean value) {
        boolean locked = this.writeLock();
        try {
            this.updateFlagsNoLock(flag, value);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDisabledState(boolean hidden) {
        boolean locked = this.writeLock();
        try {
            short oldFlags = this.flags;
            this.updateFlagsNoLock((short)16, true);
            this.updateFlagsNoLock((short)32, hidden);
            boolean bl = oldFlags != this.flags;
            return bl;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsetDisabledState() {
        boolean locked = this.writeLock();
        try {
            short oldFlags = this.flags;
            this.updateFlagsNoLock((short)16, false);
            this.updateFlagsNoLock((short)32, false);
            boolean bl = oldFlags != this.flags;
            return bl;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public void setDisabledType(boolean isExplicit) {
        this.updateFlags((short)64, isExplicit);
    }

    public void setHiddenType(boolean isExplicit) {
        this.updateFlags((short)128, isExplicit);
    }

    public void setPreserved(boolean isPreserved) {
        this.updateFlags((short)8192, isPreserved);
    }

    public boolean isDisabled() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isDisabledAndHidden() {
        return (this.flags & 0x10) != 0 && (this.flags & 0x20) != 0;
    }

    public boolean getHiddenType() {
        return (this.flags & 0x80) != 0;
    }

    public boolean getDisabledType() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isPreserved() {
        return (this.flags & 0x2000) != 0;
    }

    public boolean isSelectable() {
        return !this.isDisabled() && this.isDrawable() && !this.isDisabled();
    }

    public boolean isDrawable() {
        return (this.flags & 0x2C) == 0;
    }

    @Override
    public void setModified(boolean modified) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setModified(modified);
            if (this.dataSet != null) {
                this.dataSet.firePrimitiveFlagsChanged(this);
            }
            this.clearCachedStyle();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setVisible(visible);
            this.clearCachedStyle();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setDeleted(deleted);
            if (this.dataSet != null) {
                if (deleted) {
                    this.dataSet.firePrimitivesRemoved(Collections.singleton(this), false);
                } else {
                    this.dataSet.firePrimitivesAdded(Collections.singleton(this), false);
                }
            }
            this.clearCachedStyle();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    protected final void setIncomplete(boolean incomplete) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            if (this.dataSet != null && incomplete != this.isIncomplete()) {
                if (incomplete) {
                    this.dataSet.firePrimitivesRemoved(Collections.singletonList(this), true);
                } else {
                    this.dataSet.firePrimitivesAdded(Collections.singletonList(this), true);
                }
            }
            super.setIncomplete(incomplete);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public boolean isSelected() {
        return this.dataSet != null && this.dataSet.isSelected(this);
    }

    public boolean isMemberOfSelected() {
        if (this.referrers == null) {
            return false;
        }
        if (this.referrers instanceof OsmPrimitive) {
            return this.referrers instanceof Relation && ((OsmPrimitive)this.referrers).isSelected();
        }
        for (OsmPrimitive ref : (OsmPrimitive[])this.referrers) {
            if (!(ref instanceof Relation) || !ref.isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean isOuterMemberOfSelected() {
        if (this.referrers == null) {
            return false;
        }
        if (this.referrers instanceof OsmPrimitive) {
            return this.isOuterMemberOfMultipolygon((OsmPrimitive)this.referrers);
        }
        for (OsmPrimitive ref : (OsmPrimitive[])this.referrers) {
            if (!this.isOuterMemberOfMultipolygon(ref)) continue;
            return true;
        }
        return false;
    }

    private boolean isOuterMemberOfMultipolygon(OsmPrimitive ref) {
        if (ref instanceof Relation && ref.isSelected() && ((Relation)ref).isMultipolygon()) {
            for (RelationMember rm : ((Relation)ref).getMembersFor(Collections.singleton(this))) {
                if (!"outer".equals(rm.getRole())) continue;
                return true;
            }
        }
        return false;
    }

    public void setHighlighted(boolean highlighted) {
        if (this.isHighlighted() != highlighted) {
            this.updateFlags((short)2048, highlighted);
            if (this.dataSet != null) {
                this.dataSet.fireHighlightingChanged();
            }
        }
    }

    public boolean isHighlighted() {
        return (this.flags & 0x800) != 0;
    }

    public static Collection<String> getUninterestingKeys() {
        if (uninteresting == null) {
            LinkedList<String> l = new LinkedList<String>(Arrays.asList("source", "source_ref", "source:", "comment", "watch", "watch:", "description", "attribution"));
            l.addAll(OsmPrimitive.getDiscardableKeys());
            l.addAll(OsmPrimitive.getWorkInProgressKeys());
            uninteresting = new HashSet<String>(Config.getPref().getList("tags.uninteresting", l));
        }
        return uninteresting;
    }

    public static Collection<String> getDiscardableKeys() {
        if (discardable == null) {
            discardable = new HashSet<String>(Config.getPref().getList("tags.discardable", Arrays.asList("created_by", "converted_by", "geobase:datasetName", "geobase:uuid", "KSJ2:ADS", "KSJ2:ARE", "KSJ2:AdminArea", "KSJ2:COP_label", "KSJ2:DFD", "KSJ2:INT", "KSJ2:INT_label", "KSJ2:LOC", "KSJ2:LPN", "KSJ2:OPC", "KSJ2:PubFacAdmin", "KSJ2:RAC", "KSJ2:RAC_label", "KSJ2:RIC", "KSJ2:RIN", "KSJ2:WSC", "KSJ2:coordinate", "KSJ2:curve_id", "KSJ2:curve_type", "KSJ2:filename", "KSJ2:lake_id", "KSJ2:lat", "KSJ2:long", "KSJ2:river_id", "odbl", "odbl:note", "SK53_bulk:load", "sub_sea:type", "tiger:source", "tiger:separated", "tiger:tlid", "tiger:upload_uuid", "yh:LINE_NAME", "yh:LINE_NUM", "yh:STRUCTURE", "yh:TOTYUMONO", "yh:TYPE", "yh:WIDTH", "yh:WIDTH_RANK")));
        }
        return discardable;
    }

    public static Collection<String> getWorkInProgressKeys() {
        if (workinprogress == null) {
            workinprogress = new HashSet<String>(Config.getPref().getList("tags.workinprogress", Arrays.asList("note", "fixme", "FIXME")));
        }
        return workinprogress;
    }

    public static boolean isUninterestingKey(String key) {
        OsmPrimitive.getUninterestingKeys();
        if (uninteresting.contains(key)) {
            return true;
        }
        int pos = key.indexOf(58);
        if (pos > 0) {
            return uninteresting.contains(key.substring(0, pos + 1));
        }
        return false;
    }

    public Map<String, String> getInterestingTags() {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] keys = this.keys;
        if (keys != null) {
            for (int i = 0; i < keys.length; i += 2) {
                if (OsmPrimitive.isUninterestingKey(keys[i])) continue;
                result.put(keys[i], keys[i + 1]);
            }
        }
        return result;
    }

    private static SearchCompiler.Match compileDirectionKeys(String prefName, String defaultValue) throws AssertionError {
        try {
            return SearchCompiler.compile(Config.getPref().get(prefName, defaultValue));
        }
        catch (SearchParseError e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to compile pattern for " + prefName + ", trying default pattern:", e);
            try {
                return SearchCompiler.compile(defaultValue);
            }
            catch (SearchParseError e2) {
                throw new AssertionError("Unable to compile default pattern for direction keys: " + e2.getMessage(), e2);
            }
        }
    }

    private void updateTagged() {
        for (String key : this.keySet()) {
            if (OsmPrimitive.isUninterestingKey(key) || "area".equals(key)) continue;
            this.updateFlagsNoLock((short)512, true);
            return;
        }
        this.updateFlagsNoLock((short)512, false);
    }

    private void updateAnnotated() {
        for (String key : this.keySet()) {
            if (!OsmPrimitive.getWorkInProgressKeys().contains(key)) continue;
            this.updateFlagsNoLock((short)4096, true);
            return;
        }
        this.updateFlagsNoLock((short)4096, false);
    }

    public boolean isTagged() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isAnnotated() {
        return (this.flags & 0x1000) != 0;
    }

    private void updateDirectionFlags() {
        boolean hasDirections = false;
        boolean directionReversed = false;
        if (reversedDirectionKeys.match(this)) {
            hasDirections = true;
            directionReversed = true;
        }
        if (directionKeys.match(this)) {
            hasDirections = true;
        }
        this.updateFlagsNoLock((short)1024, directionReversed);
        this.updateFlagsNoLock((short)256, hasDirections);
    }

    public boolean hasDirectionKeys() {
        return (this.flags & 0x100) != 0;
    }

    public boolean reversedDirection() {
        return (this.flags & 0x400) != 0;
    }

    @Override
    public final void setKeys(TagMap keys) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setKeys(keys);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public final void setKeys(Map<String, String> keys) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setKeys(keys);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(String key, String value) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.put(key, value);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public final void remove(String key) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.remove(key);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public final void removeAll() {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.removeAll();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    protected void keysChangedImpl(Map<String, String> originalKeys) {
        this.clearCachedStyle();
        if (this.dataSet != null) {
            for (OsmPrimitive ref : this.getReferrers()) {
                ref.clearCachedStyle();
            }
        }
        this.updateDirectionFlags();
        this.updateTagged();
        this.updateAnnotated();
        if (this.dataSet != null) {
            this.dataSet.fireTagsChanged(this, originalKeys);
        }
    }

    protected void addReferrer(OsmPrimitive referrer) {
        this.checkDatasetNotReadOnly();
        if (this.referrers == null) {
            this.referrers = referrer;
        } else if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers != referrer) {
                this.referrers = new OsmPrimitive[]{(OsmPrimitive)this.referrers, referrer};
            }
        } else {
            for (OsmPrimitive primitive : (OsmPrimitive[])this.referrers) {
                if (primitive != referrer) continue;
                return;
            }
            this.referrers = Utils.addInArrayCopy((OsmPrimitive[])this.referrers, referrer);
        }
    }

    protected void removeReferrer(OsmPrimitive referrer) {
        this.checkDatasetNotReadOnly();
        if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers == referrer) {
                this.referrers = null;
            }
        } else if (this.referrers instanceof OsmPrimitive[]) {
            OsmPrimitive[] orig = (OsmPrimitive[])this.referrers;
            int idx = -1;
            for (int i = 0; i < orig.length; ++i) {
                if (orig[i] != referrer) continue;
                idx = i;
                break;
            }
            if (idx == -1) {
                return;
            }
            if (orig.length == 2) {
                this.referrers = orig[1 - idx];
            } else {
                OsmPrimitive[] smaller = new OsmPrimitive[orig.length - 1];
                System.arraycopy(orig, 0, smaller, 0, idx);
                System.arraycopy(orig, idx + 1, smaller, idx, smaller.length - idx);
                this.referrers = smaller;
            }
        }
    }

    public final List<OsmPrimitive> getReferrers(boolean allowWithoutDataset) {
        if (this.dataSet == null && allowWithoutDataset) {
            return Collections.emptyList();
        }
        this.checkDataset();
        Object referrers = this.referrers;
        ArrayList<OsmPrimitive> result = new ArrayList<OsmPrimitive>();
        if (referrers != null) {
            if (referrers instanceof OsmPrimitive) {
                OsmPrimitive ref = (OsmPrimitive)referrers;
                if (ref.dataSet == this.dataSet) {
                    result.add(ref);
                }
            } else {
                for (OsmPrimitive o : (OsmPrimitive[])referrers) {
                    if (this.dataSet != o.dataSet) continue;
                    result.add(o);
                }
            }
        }
        return result;
    }

    public final List<OsmPrimitive> getReferrers() {
        return this.getReferrers(false);
    }

    public void visitReferrers(OsmPrimitiveVisitor visitor) {
        if (visitor == null) {
            return;
        }
        if (this.referrers == null) {
            return;
        }
        if (this.referrers instanceof OsmPrimitive) {
            OsmPrimitive ref = (OsmPrimitive)this.referrers;
            if (ref.dataSet == this.dataSet) {
                ref.accept(visitor);
            }
        } else if (this.referrers instanceof OsmPrimitive[]) {
            OsmPrimitive[] refs;
            for (OsmPrimitive ref : refs = (OsmPrimitive[])this.referrers) {
                if (ref.dataSet != this.dataSet) continue;
                ref.accept(visitor);
            }
        }
    }

    public final boolean isReferredByWays(int n) {
        Object referrers = this.referrers;
        if (referrers == null) {
            return false;
        }
        this.checkDataset();
        if (referrers instanceof OsmPrimitive) {
            return n <= 1 && referrers instanceof Way && ((OsmPrimitive)referrers).dataSet == this.dataSet;
        }
        int counter = 0;
        for (OsmPrimitive o : (OsmPrimitive[])referrers) {
            if (this.dataSet != o.dataSet || !(o instanceof Way) || ++counter < n) continue;
            return true;
        }
        return false;
    }

    public abstract void accept(OsmPrimitiveVisitor var1);

    public void cloneFrom(OsmPrimitive other) {
        if (this.id != other.id && this.dataSet != null) {
            throw new DataIntegrityProblemException("Osm id cannot be changed after primitive was added to the dataset");
        }
        super.cloneFrom(other);
        this.clearCachedStyle();
    }

    public void mergeFrom(OsmPrimitive other) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            CheckParameterUtil.ensureParameterNotNull(other, "other");
            if (other.isNew() ^ this.isNew()) {
                throw new DataIntegrityProblemException(I18n.tr("Cannot merge because either of the participating primitives is new and the other is not", new Object[0]));
            }
            if (!other.isNew() && other.getId() != this.id) {
                throw new DataIntegrityProblemException(I18n.tr("Cannot merge primitives with different ids. This id is {0}, the other is {1}", this.id, other.getId()));
            }
            this.setKeys(other.hasKeys() ? other.getKeys() : null);
            this.timestamp = other.timestamp;
            this.version = other.version;
            this.setIncomplete(other.isIncomplete());
            this.flags = other.flags;
            this.user = other.user;
            this.changesetId = other.changesetId;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public boolean hasSameInterestingTags(OsmPrimitive other) {
        return this.keys == null && other.keys == null || this.getInterestingTags().equals(other.getInterestingTags());
    }

    public final boolean hasEqualSemanticAttributes(OsmPrimitive other) {
        return this.hasEqualSemanticAttributes(other, true);
    }

    boolean hasEqualSemanticFlags(OsmPrimitive other) {
        if (!this.isNew() && this.id != other.id) {
            return false;
        }
        return !(this.isIncomplete() ^ other.isIncomplete());
    }

    boolean hasEqualSemanticAttributes(OsmPrimitive other, boolean testInterestingTagsOnly) {
        return this.hasEqualSemanticFlags(other) && (testInterestingTagsOnly ? this.hasSameInterestingTags(other) : this.getKeys().equals(other.getKeys()));
    }

    public boolean hasEqualTechnicalAttributes(OsmPrimitive other) {
        return other != null && this.timestamp == other.timestamp && this.version == other.version && this.changesetId == other.changesetId && this.isDeleted() == other.isDeleted() && this.isModified() == other.isModified() && this.isVisible() == other.isVisible() && Objects.equals(this.user, other.user);
    }

    public void load(PrimitiveData data) {
        this.checkDatasetNotReadOnly();
        this.setKeys(data.hasKeys() ? data.getKeys() : null);
        this.setRawTimestamp(data.getRawTimestamp());
        this.user = data.getUser();
        this.setChangesetId(data.getChangesetId());
        this.setDeleted(data.isDeleted());
        this.setModified(data.isModified());
        this.setVisible(data.isVisible());
        this.setIncomplete(data.isIncomplete());
        this.version = data.getVersion();
    }

    public abstract PrimitiveData save();

    protected void saveCommonAttributes(PrimitiveData data) {
        data.setId(this.id);
        data.setKeys(this.hasKeys() ? this.getKeys() : null);
        data.setRawTimestamp(this.getRawTimestamp());
        data.setUser(this.user);
        data.setDeleted(this.isDeleted());
        data.setModified(this.isModified());
        data.setVisible(this.isVisible());
        data.setIncomplete(this.isIncomplete());
        data.setChangesetId(this.changesetId);
        data.setVersion(this.version);
    }

    public abstract BBox getBBox();

    public abstract void updatePosition();

    @Override
    protected String getFlagsAsString() {
        StringBuilder builder = new StringBuilder(super.getFlagsAsString());
        if (this.isDisabled()) {
            if (this.isDisabledAndHidden()) {
                builder.append('h');
            } else {
                builder.append('d');
            }
        }
        if (this.isTagged()) {
            builder.append('T');
        }
        if (this.hasDirectionKeys()) {
            if (this.reversedDirection()) {
                builder.append('<');
            } else {
                builder.append('>');
            }
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OsmPrimitive that = (OsmPrimitive)obj;
        return this.id == that.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    @Override
    public Collection<String> getTemplateKeys() {
        Collection<String> keySet = this.keySet();
        ArrayList<String> result = new ArrayList<String>(keySet.size() + 2);
        result.add(SPECIAL_VALUE_ID);
        result.add(SPECIAL_VALUE_LOCAL_NAME);
        result.addAll(keySet);
        return result;
    }

    @Override
    public Object getTemplateValue(String name, boolean special) {
        if (special) {
            String lc = name.toLowerCase(Locale.ENGLISH);
            if (SPECIAL_VALUE_ID.equals(lc)) {
                return this.getId();
            }
            if (SPECIAL_VALUE_LOCAL_NAME.equals(lc)) {
                return this.getLocalName();
            }
            return null;
        }
        return this.getIgnoreCase(name);
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match condition) {
        return condition.match(this);
    }

    public static Set<Relation> getParentRelations(Collection<? extends OsmPrimitive> primitives) {
        HashSet<Relation> ret = new HashSet<Relation>();
        for (OsmPrimitive osmPrimitive : primitives) {
            ret.addAll(OsmPrimitive.getFilteredList(osmPrimitive.getReferrers(), Relation.class));
        }
        return ret;
    }

    public final boolean hasAreaTags() {
        return this.hasKey("landuse", "amenity", "building", "building:part") || this.hasTag("area", "yes") || this.hasTag("waterway", "riverbank") || this.hasTagDifferent("leisure", "picnic_table", "slipway", "firepit") || this.hasTag("natural", "water", "wood", "scrub", "wetland", "grassland", "heath", "rock", "bare_rock", "sand", "beach", "scree", "bay", "glacier", "shingle", "fell", "reef", "stone", "mud", "landslide", "sinkhole", "crevasse", "desert");
    }

    public abstract boolean concernsArea();

    public abstract boolean isOutsideDownloadArea();

    public boolean isMultipolygon() {
        return false;
    }

    protected abstract void addToBBox(BBox var1, Set<PrimitiveId> var2);

    static {
        String reversedDirectionDefault = "oneway=\"-1\"";
        String directionDefault = "oneway? | (aerialway=chair_lift & -oneway=no) | (aerialway=rope_tow & -oneway=no) | (aerialway=magic_carpet & -oneway=no) | (aerialway=zip_line & -oneway=no) | (aerialway=drag_lift & -oneway=no) | (aerialway=t-bar & -oneway=no) | (aerialway=j-bar & -oneway=no) | (aerialway=platter & -oneway=no) | waterway=stream | waterway=river | waterway=ditch | waterway=drain | (\"piste:type\"=downhill & -area=yes) | (\"piste:type\"=sled & -area=yes) | (man_made=\"piste:halfpipe\" & -area=yes) | junction=roundabout | (highway=motorway & -oneway=no & -oneway=reversible) | (highway=motorway_link & -oneway=no & -oneway=reversible)";
        reversedDirectionKeys = OsmPrimitive.compileDirectionKeys("tags.reversed_direction", reversedDirectionDefault);
        directionKeys = OsmPrimitive.compileDirectionKeys("tags.direction", directionDefault);
    }
}

