/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;

public class MemberRoleCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final AutoCompletingTextField editor;
    private final transient DataSet ds;
    private final transient Relation relation;
    private final AutoCompletionList autoCompletionList;

    public MemberRoleCellEditor(DataSet ds, Relation relation) {
        this.ds = ds;
        this.relation = relation;
        this.editor = new AutoCompletingTextField(0, false);
        this.editor.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.autoCompletionList = new AutoCompletionList();
        this.editor.setAutoCompletionList(this.autoCompletionList);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String role = (String)value;
        this.editor.setText(role);
        this.autoCompletionList.clear();
        AutoCompletionManager.of(this.ds).populateWithMemberRoles(this.autoCompletionList, this.relation);
        return this.editor;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getText();
    }

    public AutoCompletingTextField getEditor() {
        return this.editor;
    }
}

