/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.download.AbstractDownloadSourcePanel;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSettings;
import org.openstreetmap.josm.gui.download.DownloadSource;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public class OSMDownloadSource
implements DownloadSource<OSMDownloadData> {
    public static final String SIMPLE_NAME = "osmdownloadpanel";

    @Override
    public AbstractDownloadSourcePanel<OSMDownloadData> createPanel(DownloadDialog dialog) {
        return new OSMDownloadSourcePanel(this, dialog);
    }

    @Override
    public void doDownload(OSMDownloadData data, DownloadSettings settings) {
        Future<?> future;
        AbstractDownloadTask task;
        Bounds bbox = settings.getDownloadBounds().orElseThrow(() -> new IllegalArgumentException("OSM downloads requires bounds"));
        boolean zoom = settings.zoomToData();
        boolean newLayer = settings.asNewLayer();
        ArrayList tasks = new ArrayList();
        if (data.isDownloadOSMData()) {
            task = new DownloadOsmTask();
            task.setZoomAfterDownload(zoom && !data.isDownloadGPX() && !data.isDownloadNotes());
            future = ((DownloadOsmTask)task).download(newLayer, bbox, null);
            MainApplication.worker.submit(new PostDownloadHandler(task, future));
            if (zoom) {
                tasks.add(new Pair(task, future));
            }
        }
        if (data.isDownloadGPX()) {
            task = new DownloadGpsTask();
            task.setZoomAfterDownload(zoom && !data.isDownloadOSMData() && !data.isDownloadNotes());
            future = ((DownloadGpsTask)task).download(newLayer, bbox, null);
            MainApplication.worker.submit(new PostDownloadHandler(task, future));
            if (zoom) {
                tasks.add(new Pair(task, future));
            }
        }
        if (data.isDownloadNotes()) {
            task = new DownloadNotesTask();
            task.setZoomAfterDownload(zoom && !data.isDownloadOSMData() && !data.isDownloadGPX());
            future = ((DownloadNotesTask)task).download(false, bbox, null);
            MainApplication.worker.submit(new PostDownloadHandler(task, future));
            if (zoom) {
                tasks.add(new Pair(task, future));
            }
        }
        if (zoom && tasks.size() > 1) {
            MainApplication.worker.submit(() -> {
                ProjectionBounds bounds = null;
                for (Pair p : tasks) {
                    try {
                        ((Future)p.b).get();
                        ProjectionBounds b = ((AbstractDownloadTask)p.a).getDownloadProjectionBounds();
                        if (bounds == null) {
                            bounds = b;
                            continue;
                        }
                        if (b == null) continue;
                        bounds.extend(b);
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Logging.warn(ex);
                    }
                }
                MapFrame map = MainApplication.getMap();
                if (map != null && bounds != null) {
                    ProjectionBounds pb = bounds;
                    GuiHelper.runInEDTAndWait(() -> map.mapView.zoomTo(new ViewportData(pb)));
                }
            });
        }
    }

    @Override
    public String getLabel() {
        return I18n.tr("Download from OSM", new Object[0]);
    }

    @Override
    public boolean onlyExpert() {
        return false;
    }

    static class OSMDownloadData {
        private final boolean downloadOSMData;
        private final boolean downloadNotes;
        private final boolean downloadGPX;

        OSMDownloadData(boolean downloadOSMData, boolean downloadNotes, boolean downloadGPX) {
            this.downloadOSMData = downloadOSMData;
            this.downloadNotes = downloadNotes;
            this.downloadGPX = downloadGPX;
        }

        boolean isDownloadOSMData() {
            return this.downloadOSMData;
        }

        boolean isDownloadNotes() {
            return this.downloadNotes;
        }

        boolean isDownloadGPX() {
            return this.downloadGPX;
        }
    }

    public static class OSMDownloadSourcePanel
    extends AbstractDownloadSourcePanel<OSMDownloadData> {
        private final JCheckBox cbDownloadOsmData;
        private final JCheckBox cbDownloadGpxData;
        private final JCheckBox cbDownloadNotes;
        private final JLabel sizeCheck = new JLabel();
        private static final BooleanProperty DOWNLOAD_OSM = new BooleanProperty("download.osm.data", true);
        private static final BooleanProperty DOWNLOAD_GPS = new BooleanProperty("download.osm.gps", false);
        private static final BooleanProperty DOWNLOAD_NOTES = new BooleanProperty("download.osm.notes", false);

        public OSMDownloadSourcePanel(OSMDownloadSource ds, DownloadDialog dialog) {
            super(ds);
            this.setLayout(new GridBagLayout());
            ChangeListener checkboxChangeListener = e -> dialog.getSelectedDownloadArea().ifPresent(this::updateSizeCheck);
            this.add((Component)new JLabel(I18n.tr("Data Sources and Types:", new Object[0])), GBC.std().insets(5, 5, 1, 5).anchor(10));
            this.cbDownloadOsmData = new JCheckBox(I18n.tr("OpenStreetMap data", new Object[0]), true);
            this.cbDownloadOsmData.setToolTipText(I18n.tr("Select to download OSM data in the selected download area.", new Object[0]));
            this.cbDownloadOsmData.getModel().addChangeListener(checkboxChangeListener);
            this.cbDownloadGpxData = new JCheckBox(I18n.tr("Raw GPS data", new Object[0]));
            this.cbDownloadGpxData.setToolTipText(I18n.tr("Select to download GPS traces in the selected download area.", new Object[0]));
            this.cbDownloadGpxData.getModel().addChangeListener(checkboxChangeListener);
            this.cbDownloadNotes = new JCheckBox(I18n.tr("Notes", new Object[0]));
            this.cbDownloadNotes.setToolTipText(I18n.tr("Select to download notes in the selected download area.", new Object[0]));
            this.cbDownloadNotes.getModel().addChangeListener(checkboxChangeListener);
            Font labelFont = this.sizeCheck.getFont();
            this.sizeCheck.setFont(labelFont.deriveFont(0, labelFont.getSize()));
            this.add((Component)this.cbDownloadOsmData, GBC.std().insets(1, 5, 1, 5));
            this.add((Component)this.cbDownloadGpxData, GBC.std().insets(1, 5, 1, 5));
            this.add((Component)this.cbDownloadNotes, GBC.eol().insets(1, 5, 1, 5));
            this.add((Component)this.sizeCheck, GBC.eol().anchor(13).insets(5, 5, 5, 2));
            this.setMinimumSize(new Dimension(450, 115));
        }

        @Override
        public OSMDownloadData getData() {
            return new OSMDownloadData(this.isDownloadOsmData(), this.isDownloadNotes(), this.isDownloadGpxData());
        }

        @Override
        public void rememberSettings() {
            DOWNLOAD_OSM.put(this.isDownloadOsmData());
            DOWNLOAD_GPS.put(this.isDownloadGpxData());
            DOWNLOAD_NOTES.put(this.isDownloadNotes());
        }

        @Override
        public void restoreSettings() {
            this.cbDownloadOsmData.setSelected(DOWNLOAD_OSM.get());
            this.cbDownloadGpxData.setSelected(DOWNLOAD_GPS.get());
            this.cbDownloadNotes.setSelected(DOWNLOAD_NOTES.get());
        }

        @Override
        public boolean checkDownload(DownloadSettings settings) {
            if (!settings.getDownloadBounds().isPresent()) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Please select a download area first.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                return false;
            }
            if (!(this.isDownloadOsmData() || this.isDownloadGpxData() || this.isDownloadNotes())) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("<html>Neither <strong>{0}</strong> nor <strong>{1}</strong> nor <strong>{2}</strong> is enabled.<br>Please choose to either download OSM data, or GPX data, or Notes, or all.</html>", this.cbDownloadOsmData.getText(), this.cbDownloadGpxData.getText(), this.cbDownloadNotes.getText()), I18n.tr("Error", new Object[0]), 0);
                return false;
            }
            this.rememberSettings();
            return true;
        }

        public boolean isDownloadOsmData() {
            return this.cbDownloadOsmData.isSelected();
        }

        public boolean isDownloadGpxData() {
            return this.cbDownloadGpxData.isSelected();
        }

        public boolean isDownloadNotes() {
            return this.cbDownloadNotes.isSelected();
        }

        @Override
        public Icon getIcon() {
            return ImageProvider.get("download");
        }

        @Override
        public void boundingBoxChanged(Bounds bbox) {
            this.updateSizeCheck(bbox);
        }

        @Override
        public String getSimpleName() {
            return OSMDownloadSource.SIMPLE_NAME;
        }

        private void updateSizeCheck(Bounds bbox) {
            if (bbox == null) {
                this.sizeCheck.setText(I18n.tr("No area selected yet", new Object[0]));
                this.sizeCheck.setForeground(Color.darkGray);
                return;
            }
            boolean isAreaTooLarge = false;
            isAreaTooLarge = !this.isDownloadNotes() && !this.isDownloadOsmData() && !this.isDownloadGpxData() ? false : (this.isDownloadNotes() && !this.isDownloadOsmData() && !this.isDownloadGpxData() ? bbox.getArea() > Config.getPref().getDouble("osm-server.max-request-area-notes", 25.0) : bbox.getArea() > Config.getPref().getDouble("osm-server.max-request-area", 0.25));
            this.displaySizeCheckResult(isAreaTooLarge);
        }

        private void displaySizeCheckResult(boolean isAreaTooLarge) {
            if (isAreaTooLarge) {
                this.sizeCheck.setText(I18n.tr("Download area too large; will probably be rejected by server", new Object[0]));
                this.sizeCheck.setForeground(Color.red);
            } else {
                this.sizeCheck.setText(I18n.tr("Download area ok, size probably acceptable to server", new Object[0]));
                this.sizeCheck.setForeground(Color.darkGray);
            }
        }
    }
}

