/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public class GeoJSONWriter {
    private final DataSet data;
    private final Projection projection;
    private static final boolean SKIP_EMPTY_NODES = true;

    public GeoJSONWriter(DataSet ds) {
        this.data = ds;
        this.projection = Projections.getProjectionByCode("EPSG:4326");
    }

    public String write() {
        return this.write(true);
    }

    public String write(boolean pretty) {
        StringWriter stringWriter = new StringWriter();
        HashMap<String, Boolean> config = new HashMap<String, Boolean>(1);
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", pretty);
        try (JsonWriter writer = Json.createWriterFactory(config).createWriter(stringWriter);){
            JsonObjectBuilder object = Json.createObjectBuilder().add("type", "FeatureCollection").add("generator", "JOSM");
            this.appendLayerBounds(this.data, object);
            this.appendLayerFeatures(this.data, object);
            writer.writeObject(object.build());
            String string = stringWriter.toString();
            return string;
        }
    }

    private JsonArrayBuilder getCoorArray(JsonArrayBuilder builder, LatLon c) {
        return GeoJSONWriter.getCoorArray(builder, this.projection.latlon2eastNorth(c));
    }

    private static JsonArrayBuilder getCoorArray(JsonArrayBuilder builder, EastNorth c) {
        return builder != null ? builder : Json.createArrayBuilder().add(BigDecimal.valueOf(c.getX()).setScale(11, RoundingMode.HALF_UP)).add(BigDecimal.valueOf(c.getY()).setScale(11, RoundingMode.HALF_UP));
    }

    private JsonArrayBuilder getCoorsArray(Iterable<Node> nodes) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Node n : nodes) {
            LatLon ll = n.getCoor();
            if (ll == null) continue;
            builder.add(this.getCoorArray(null, ll));
        }
        return builder;
    }

    protected void appendPrimitive(OsmPrimitive p, JsonArrayBuilder array) {
        if (p.isIncomplete()) {
            return;
        }
        if (p instanceof Node && p.getKeys().isEmpty()) {
            return;
        }
        JsonObjectBuilder propObj = Json.createObjectBuilder();
        for (Map.Entry<String, String> t : p.getKeys().entrySet()) {
            propObj.add(t.getKey(), t.getValue());
        }
        JsonObjectBuilder geomObj = Json.createObjectBuilder();
        p.accept(new GeometryPrimitiveVisitor(geomObj));
        array.add(Json.createObjectBuilder().add("type", "Feature").add("properties", propObj).add("geometry", geomObj));
    }

    protected void appendLayerBounds(DataSet ds, JsonObjectBuilder object) {
        Iterator<Bounds> it;
        if (ds != null && (it = ds.getDataSourceBounds().iterator()).hasNext()) {
            Bounds b = new Bounds(it.next());
            while (it.hasNext()) {
                b.extend(it.next());
            }
            this.appendBounds(b, object);
        }
    }

    protected void appendBounds(Bounds b, JsonObjectBuilder object) {
        if (b != null) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            this.getCoorArray(builder, b.getMin());
            this.getCoorArray(builder, b.getMax());
            object.add("bbox", builder);
        }
    }

    protected void appendLayerFeatures(DataSet ds, JsonObjectBuilder object) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        if (ds != null) {
            ds.allNonDeletedPrimitives().forEach(p -> this.appendPrimitive((OsmPrimitive)p, array));
        }
        object.add("features", array);
    }

    private class GeometryPrimitiveVisitor
    implements OsmPrimitiveVisitor {
        private final JsonObjectBuilder geomObj;

        GeometryPrimitiveVisitor(JsonObjectBuilder geomObj) {
            this.geomObj = geomObj;
        }

        @Override
        public void visit(Node n) {
            this.geomObj.add("type", "Point");
            LatLon ll = n.getCoor();
            if (ll != null) {
                this.geomObj.add("coordinates", GeoJSONWriter.this.getCoorArray(null, n.getCoor()));
            }
        }

        @Override
        public void visit(Way w) {
            if (w != null) {
                JsonArrayBuilder array = GeoJSONWriter.this.getCoorsArray(w.getNodes());
                if (w.isClosed() && ElemStyles.hasAreaElemStyle(w, false)) {
                    JsonArrayBuilder container = Json.createArrayBuilder().add(array);
                    this.geomObj.add("type", "Polygon");
                    this.geomObj.add("coordinates", container);
                } else {
                    this.geomObj.add("type", "LineString");
                    this.geomObj.add("coordinates", array);
                }
            }
        }

        @Override
        public void visit(Relation r) {
            if (r == null || !r.isMultipolygon() || r.hasIncompleteMembers()) {
                return;
            }
            try {
                Pair<List<MultipolygonBuilder.JoinedPolygon>, List<MultipolygonBuilder.JoinedPolygon>> mp = MultipolygonBuilder.joinWays(r);
                JsonArrayBuilder polygon = Json.createArrayBuilder();
                Stream.concat(((List)mp.a).stream(), ((List)mp.b).stream()).map(p -> GeoJSONWriter.this.getCoorsArray(p.getNodes()).add(GeoJSONWriter.this.getCoorArray(null, p.getNodes().get(0).getCoor()))).forEach(polygon::add);
                this.geomObj.add("type", "MultiPolygon");
                JsonArrayBuilder multiPolygon = Json.createArrayBuilder().add(polygon);
                this.geomObj.add("coordinates", multiPolygon);
            }
            catch (MultipolygonBuilder.JoinedPolygonCreationException ex) {
                Logging.warn("GeoJSON: Failed to export multipolygon {0}", r.getUniqueId());
                Logging.warn(ex);
            }
        }
    }
}

