/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.openstreetmap.josm.tools.Logging;

public class PluginClassLoader
extends URLClassLoader {
    private final Collection<PluginClassLoader> dependencies;

    public PluginClassLoader(URL[] urls, ClassLoader parent, Collection<PluginClassLoader> dependencies) {
        super(urls, parent);
        this.dependencies = dependencies == null ? new ArrayList<PluginClassLoader>() : new ArrayList<PluginClassLoader>(dependencies);
    }

    public boolean addDependency(PluginClassLoader dependency) {
        boolean result;
        boolean bl = result = !this.dependencies.contains(Objects.requireNonNull(dependency, "dependency")) && !this.dependencies.stream().anyMatch(pcl -> pcl.dependencies.contains(dependency)) && this.dependencies.add(dependency);
        if (result) {
            this.dependencies.removeIf(pcl -> pcl.dependencies.isEmpty() && dependency.dependencies.contains(pcl));
        }
        return result;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            for (PluginClassLoader dep : this.dependencies) {
                try {
                    result = dep.loadClass(name, resolve);
                    if (result == null) continue;
                    return result;
                }
                catch (ClassNotFoundException e) {
                    Logging.trace("Plugin class not found in {0}: {1}", dep, e.getMessage());
                }
            }
            result = super.loadClass(name, resolve);
        }
        if (result != null) {
            return result;
        }
        throw new ClassNotFoundException(name);
    }

    public String toString() {
        return "PluginClassLoader [urls=" + Arrays.toString(this.getURLs()) + (this.dependencies.isEmpty() ? "" : ", dependencies=" + this.dependencies) + ']';
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

