#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: options
version: 1.2.1.1
id: options-1.2.1.1-38ZYPRuihX1Fh9IdUi6nBd
key: options-1.2.1.1-38ZYPRuihX1Fh9IdUi6nBd
license: MIT
maintainer: John Millikin <john@john-millikin.com>
stability: stable
homepage: https://john-millikin.com/software/haskell-options/
synopsis: A powerful and easy-to-use command-line option parser.
description:
    The @options@ package lets library and application developers easily work
    with command-line options.
    .
    The following example is a full program that can accept two options,
    @--message@ and @--quiet@:
    .
    @
    import Control.Applicative
    import Options
    .
    data MainOptions = MainOptions
    &#x20;   &#x7b; optMessage :: String
    &#x20;   , optQuiet :: Bool
    &#x20;   &#x7d;
    .
    instance '\''Options'\'' MainOptions where
    &#x20;   defineOptions = pure MainOptions
    &#x20;       \<*\> simpleOption \"message\" \"Hello world!\"
    &#x20;           \"A message to show the user.\"
    &#x20;       \<*\> simpleOption \"quiet\" False
    &#x20;           \"Whether to be quiet.\"
    .
    main :: IO ()
    main = runCommand $ \\opts args -> do
    &#x20;   if optQuiet opts
    &#x20;       then return ()
    &#x20;       else putStrLn (optMessage opts)
    @
    .
    >$ ./hello
    >Hello world!
    >$ ./hello --message='\''ciao mondo'\''
    >ciao mondo
    >$ ./hello --quiet
    >$
    .
    In addition, this library will automatically create documentation options
    such as @--help@ and @--help-all@:
    .
    >$ ./hello --help
    >Help Options:
    >  -h, --help
    >    Show option summary.
    >  --help-all
    >    Show all help options.
    >
    >Application Options:
    >  --message :: text
    >    A message to show the user.
    >    default: "Hello world!"
    >  --quiet :: bool
    >    Whether to be quiet.
    >    default: false
category: Console
author: John Millikin <john@john-millikin.com>
exposed: True
indefinite: False
exposed-modules:
    Options
hidden-modules: Options.Help Options.Tokenize Options.Types
                Options.Util
abi: e59f884bdcf8a4cef829fbff81db8a71
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/options-1.2.1.1
library-dirs: /usr/lib/ghc-8.2.2/site-local/options-1.2.1.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/options-1.2.1.1
hs-libraries: HSoptions-1.2.1.1-38ZYPRuihX1Fh9IdUi6nBd
depends:
    base-4.10.1.0 containers-0.5.10.2
    monads-tf-0.1.0.3-1scKDck1nyF3hHYXqW7mNz transformers-0.5.2.0
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             monads-tf-0.1.0.3-1scKDck1nyF3hHYXqW7mNz=0c9b66ce3d9f82342ac301838c6515b5
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
haddock-interfaces: /usr/share/doc/haskell-options/html/options.haddock
haddock-html: /usr/share/doc/haskell-options/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

