#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 2.1.3
id: pandoc-2.1.3-8vph3qmTKQQAKitdx9QFil
key: pandoc-2.1.3-8vph3qmTKQQAKitdx9QFil
license: GPL-2
copyright: (c) 2006-2018 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: https://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook, JATS,
    MediaWiki markup, TWiki markup, TikiWiki markup, Creole 1.0,
    Haddock markup, OPML, Emacs Org-Mode, Emacs Muse, txt2tags,
    Vimwiki, Word Docx, ODT, and Textile, and it can write
    Markdown, reStructuredText, XHTML, HTML 5, LaTeX, ConTeXt,
    DocBook, JATS, OPML, TEI, OpenDocument, ODT, Word docx,
    RTF, MediaWiki, DokuWiki, ZimWiki, Textile, groff man,
    groff ms, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign
    ICML, Muse, LaTeX beamer slides, PowerPoint, and several
    kinds of HTML/JavaScript slide shows (S5, Slidy, Slideous,
    DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
author: John MacFarlane <jgm@berkeley.edu>
exposed: True
indefinite: False
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.BCP47
    Text.Pandoc.Class Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Highlighting
    Text.Pandoc.ImageSize Text.Pandoc.Logging Text.Pandoc.Lua
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Pretty
    Text.Pandoc.Process Text.Pandoc.Readers
    Text.Pandoc.Readers.CommonMark Text.Pandoc.Readers.Creole
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.JATS
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.LaTeX.Types
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.Odt
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RST
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Vimwiki Text.Pandoc.SelfContained
    Text.Pandoc.Shared Text.Pandoc.Templates Text.Pandoc.UTF8
    Text.Pandoc.Writers Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.XML
hidden-modules: Text.Pandoc.Filter Text.Pandoc.Filter.JSON
                Text.Pandoc.Filter.Lua Text.Pandoc.Filter.Path
                Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
                Text.Pandoc.Readers.Docx.Parse Text.Pandoc.Readers.Docx.Util
                Text.Pandoc.Readers.Docx.StyleMap Text.Pandoc.Readers.Docx.Fields
                Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.DocumentTree
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared
                Text.Pandoc.Writers.Powerpoint.Presentation
                Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Lua.Filter
                Text.Pandoc.Lua.Init Text.Pandoc.Lua.Module.MediaBag
                Text.Pandoc.Lua.Module.Pandoc Text.Pandoc.Lua.Module.Utils
                Text.Pandoc.Lua.Packages Text.Pandoc.Lua.StackInstances
                Text.Pandoc.Lua.Util Text.Pandoc.CSS Text.Pandoc.CSV
                Text.Pandoc.UUID Text.Pandoc.Translations Text.Pandoc.Slides
                Paths_pandoc Prelude
abi: 52e67ed16a71c8f4d68d8357cb6812b7
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/pandoc-2.1.3
library-dirs: /usr/lib/ghc-8.2.2/site-local/pandoc-2.1.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-2.1.3-8vph3qmTKQQAKitdx9QFil
depends:
    base-4.10.1.0 syb-0.7-3Lq8MQxmYP07qktjI1jxu0 containers-0.5.10.2
    unordered-containers-0.2.9.0-AIQ8bV884oMFcq0To2pA1G
    parsec-3.1.13.0-F9Bf3y6KXh0ILPjymhJoOp
    mtl-2.2.2-8XubxMJDT8QLsstvlNotkc
    exceptions-0.8.3-FtqgxeR4VUg9hGcIqYr2bq filepath-1.4.1.2
    process-1.6.1.0 directory-1.3.0.2 bytestring-0.10.8.2
    text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz time-1.8.0.2
    safe-0.3.15-EroU33EYnr02fGSZYGiX97
    zip-archive-0.3.2.4-1FiEK2C8QoDBrVcZXFgSdU
    HTTP-4000.3.11-EoFLllqDrb46ptSX3CXziO
    texmath-0.10.1.1-9Zx4JWEIgSVB9h0jUzFl5z
    xml-1.3.14-1QOvnW05iRMh383OQN419
    split-0.2.3.3-BN2ylJ9hXZBIaY8HiUVge7
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We
    pandoc-types-1.17.4.2-79YMs3n1NuC3mtTyFjtgwq
    aeson-1.2.4.0-IxpmF2XxtfM2bzjPAR2gMF
    aeson-pretty-0.8.7-2n9vyxhNKA4Dfn1oVLbYjX
    tagsoup-0.14.6-EpRlmpegpADxmAsmqZBMq
    base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be
    zlib-0.6.2-FRkEyCRDCMJ4V7FViKOnGY
    skylighting-0.6-5rXah3L0LBkoCuD4sRI6x
    data-default-0.7.1.1-AA4CT1Ft3yBIiqFbrFdPSr
    temporary-1.2.1.1-C4Oi7my6bSWB1kyblmdgo2
    blaze-html-0.9.0.1-LSl5YsnAOxGGQxRTreTaG0
    blaze-markup-0.8.2.1-EXmhw0576TBGsUq0laKKM2
    yaml-0.8.29-Gi97Aw1KAGcEf1oVOFvTtA
    scientific-0.3.5.3-4Af2QhuNyMzGatzrYjrxpI
    vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA
    hslua-0.9.5.1-AJpVJcWY1SoFraVMW4JyFb
    hslua-module-text-0.1.2.1-6wmDRG2QO6H8lOanTrtA7m binary-0.8.5.1
    SHA-1.6.4.4-1zvOUgVKaQx7KvqAhOzZXy
    haddock-library-1.4.5-uQdrVGi1uKLD22IlKGc6n deepseq-1.4.3.0
    JuicyPixels-3.2.9.5-ASGnSU2nyj8KgOo9KfthVh
    Glob-0.9.2-K64U7op4fSqGlrID7DNxX9
    cmark-gfm-0.1.3-9JIYiVDhJ65KYe2mtb4tmu
    doctemplates-0.2.2.1-J7wFnl5zEoJ9med3x6WkdK
    http-client-0.5.12.1-EHwF2iEaTTE8A2hDhlPUXu
    http-client-tls-0.3.5.3-CTxAeTaqjos41KPcFoCAV0
    http-types-0.9.1-I5VXdG5r7Fv5gm7UD4yo3B
    case-insensitive-1.2.0.11-6moQBu1HxUPLo5Vi55MiZR
    base-compat-0.9.3-915GC5pH10BBmcMnCvMsPA unix-2.7.2.2
    network-uri-2.6.1.0-6DCcjXT6KQAGJ7ruji2glJ
    network-2.6.3.5-BVJHDRdh5LJ4pgucNKJkuJ
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             syb-0.7-3Lq8MQxmYP07qktjI1jxu0=f985ea42a9fa578e0f67572a93e19b5d
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             unordered-containers-0.2.9.0-AIQ8bV884oMFcq0To2pA1G=5c8877e146af6c27c44eb74d4cb22e80
             parsec-3.1.13.0-F9Bf3y6KXh0ILPjymhJoOp=b942a04aec0a266706b2e8e67bd137e3
             mtl-2.2.2-8XubxMJDT8QLsstvlNotkc=9d788b97813db77c2d48570ade6e04a9
             exceptions-0.8.3-FtqgxeR4VUg9hGcIqYr2bq=349f1b5172af08123dc6c444b05979b3
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz=29872508833c96394f0471371217bab0
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             safe-0.3.15-EroU33EYnr02fGSZYGiX97=604c7b7c109a34b58d71795df287548a
             zip-archive-0.3.2.4-1FiEK2C8QoDBrVcZXFgSdU=f39c0255893d57bf82756d47e0ccf927
             HTTP-4000.3.11-EoFLllqDrb46ptSX3CXziO=8c298ba8d341e54003858cb7a6112fdd
             texmath-0.10.1.1-9Zx4JWEIgSVB9h0jUzFl5z=746f749f7a8545b42f9079e687b31e5b
             xml-1.3.14-1QOvnW05iRMh383OQN419=a7056b3de174482244e4897529e3aaf7
             split-0.2.3.3-BN2ylJ9hXZBIaY8HiUVge7=b6b8499789ca23888d2f286cbdde6707
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=368a9f817c8c1b290191231dd0d81d85
             pandoc-types-1.17.4.2-79YMs3n1NuC3mtTyFjtgwq=62cd641315374be896ea89dd6c5ecef2
             aeson-1.2.4.0-IxpmF2XxtfM2bzjPAR2gMF=117e2ccb320a02562b7dab8dac8cab03
             aeson-pretty-0.8.7-2n9vyxhNKA4Dfn1oVLbYjX=ce99f4ed93ff2ced722cba3594297e8e
             tagsoup-0.14.6-EpRlmpegpADxmAsmqZBMq=9b9175fd900a6ae25e03eceb85425b3c
             base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be=fd5db0dc9688093c1ac2c3223371478e
             zlib-0.6.2-FRkEyCRDCMJ4V7FViKOnGY=a5f6b4f0b968fa7b1bee7784729ec9b2
             skylighting-0.6-5rXah3L0LBkoCuD4sRI6x=7d58e3703962610f83a82b6309627b90
             data-default-0.7.1.1-AA4CT1Ft3yBIiqFbrFdPSr=0186e0f4b96bc201d2baef8ade597d90
             temporary-1.2.1.1-C4Oi7my6bSWB1kyblmdgo2=0ece841d14e2532f171448f112ccf0bd
             blaze-html-0.9.0.1-LSl5YsnAOxGGQxRTreTaG0=49a468374da15ee6981f2dc0c5ca6996
             blaze-markup-0.8.2.1-EXmhw0576TBGsUq0laKKM2=2957175f80d486950ba665dd719601e4
             yaml-0.8.29-Gi97Aw1KAGcEf1oVOFvTtA=1b9144eaf61cd2dfe095378b706474e8
             scientific-0.3.5.3-4Af2QhuNyMzGatzrYjrxpI=a27ded325e5d5959c97ff2a5817450bc
             vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA=137c9db50bf637e10c6e6dd9e685ce59
             hslua-0.9.5.1-AJpVJcWY1SoFraVMW4JyFb=cb89fbdb48d51a72266011132528c966
             hslua-module-text-0.1.2.1-6wmDRG2QO6H8lOanTrtA7m=91d964d033e49574aa1c64c5821b59ed
             binary-0.8.5.1=33c677d3ced9a5afbc7b354509494653
             SHA-1.6.4.4-1zvOUgVKaQx7KvqAhOzZXy=e2a015fdc5d143c2552d0192c0b893ff
             haddock-library-1.4.5-uQdrVGi1uKLD22IlKGc6n=6190889e581e299524df9ddefc6f117b
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             JuicyPixels-3.2.9.5-ASGnSU2nyj8KgOo9KfthVh=f684dd48218258b0799e18e42331ec77
             Glob-0.9.2-K64U7op4fSqGlrID7DNxX9=a6d0e6ecd9ada669906944dcb25dcbeb
             cmark-gfm-0.1.3-9JIYiVDhJ65KYe2mtb4tmu=d22d75de2ab8c0680d26bbc3f3b0f946
             doctemplates-0.2.2.1-J7wFnl5zEoJ9med3x6WkdK=9e1ea6a610236a14ca72d3d1b0bcb6f1
             http-client-0.5.12.1-EHwF2iEaTTE8A2hDhlPUXu=a2b55c6a81a557cf248167fc421f9eaa
             http-client-tls-0.3.5.3-CTxAeTaqjos41KPcFoCAV0=1dae43f13347f99c0d91c48f0c53785a
             http-types-0.9.1-I5VXdG5r7Fv5gm7UD4yo3B=1fabab8f133df5a739212b62b9cfb522
             case-insensitive-1.2.0.11-6moQBu1HxUPLo5Vi55MiZR=1c6594e3192e08eeeeb5e70e5d90ad4f
             base-compat-0.9.3-915GC5pH10BBmcMnCvMsPA=b23a246a62afd271167dd1ea1b77583b
             unix-2.7.2.2=3df01ca0d7640dab598065ff1b1cffeb
             network-uri-2.6.1.0-6DCcjXT6KQAGJ7ruji2glJ=17ff77631878cfceba90438df04f39d6
             network-2.6.3.5-BVJHDRdh5LJ4pgucNKJkuJ=82fe21e10301e2e4d8701392ba21a740
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

