/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Arrays;
import javax.management.Descriptor;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;

public class OpenMBeanConstructorInfoSupport
extends MBeanConstructorInfo
implements OpenMBeanConstructorInfo {
    static final long serialVersionUID = -4400441579007477003L;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public OpenMBeanConstructorInfoSupport(String name, String description, OpenMBeanParameterInfo[] signature) {
        this(name, description, signature, (Descriptor)null);
    }

    public OpenMBeanConstructorInfoSupport(String name, String description, OpenMBeanParameterInfo[] signature, Descriptor descriptor) {
        super(name, description, OpenMBeanConstructorInfoSupport.arrayCopyCast(signature), descriptor);
        if (name == null || name.trim().equals("")) {
            throw new IllegalArgumentException("Argument name cannot be null or empty");
        }
        if (description == null || description.trim().equals("")) {
            throw new IllegalArgumentException("Argument description cannot be null or empty");
        }
    }

    private static MBeanParameterInfo[] arrayCopyCast(OpenMBeanParameterInfo[] src) {
        if (src == null) {
            return null;
        }
        MBeanParameterInfo[] dst = new MBeanParameterInfo[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Override
    public boolean equals(Object obj) {
        OpenMBeanConstructorInfo other;
        if (obj == null) {
            return false;
        }
        try {
            other = (OpenMBeanConstructorInfo)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return Arrays.equals(this.getSignature(), other.getSignature());
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            int value = 0;
            value += this.getName().hashCode();
            this.myHashCode = value += Arrays.asList(this.getSignature()).hashCode();
        }
        return this.myHashCode;
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            this.myToString = this.getClass().getName() + "(name=" + this.getName() + ",signature=" + Arrays.asList(this.getSignature()).toString() + ",descriptor=" + this.getDescriptor() + ")";
        }
        return this.myToString;
    }
}

