/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MergeTranslations {
    public static void main(String[] args) throws Exception {
        String[] sourceFiles;
        File targetDirectory;
        File sourceDirectory = new File(args[0]);
        if (!sourceDirectory.isDirectory()) {
            System.exit(1);
        }
        if (!(targetDirectory = new File(args[1])).isDirectory()) {
            System.exit(1);
        }
        final String localeKey = args.length > 2 ? args[2] : "";
        for (String name : sourceFiles = sourceDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("FreeColMessages_" + localeKey + ".*\\.properties");
            }
        })) {
            FileWriter out;
            System.out.println("Processing source file: " + name);
            File sourceFile = new File(sourceDirectory, name);
            Map<String, String> sourceProperties = MergeTranslations.readFile(sourceFile);
            File targetFile = new File(targetDirectory, name);
            if (targetFile.exists()) {
                Map<String, String> targetProperties = MergeTranslations.readFile(targetFile);
                List missingProperties = sourceProperties.entrySet().stream().filter(e -> !targetProperties.containsKey(e.getKey())).collect(Collectors.toList());
                if (missingProperties.isEmpty()) continue;
                try (FileWriter out2 = new FileWriter(targetFile, true);){
                    out2.write("### Merged from trunk on " + DateFormat.getDateTimeInstance().format(new Date()) + " ###\n");
                    for (Map.Entry entry : missingProperties) {
                        out2.write((String)entry.getKey());
                        out2.write("=");
                        out2.write((String)entry.getValue());
                        out2.write("\n");
                    }
                    continue;
                }
            }
            System.out.println("Copying " + name + " from trunk.");
            try (FileReader in = new FileReader(sourceFile);){
                int c;
                out = new FileWriter(targetFile);
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
            }
            out.close();
        }
    }

    private static Map<String, String> readFile(File file) {
        HashMap<String, String> result = new HashMap<String, String>();
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line = bufferedReader.readLine();
            while (line != null) {
                int index = line.indexOf(61);
                if (index >= 0) {
                    result.put(line.substring(0, index), line.substring(index + 1));
                }
                line = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

