// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `FileInfo.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IcePatch2;

/**
 * Basic information about a single file.
 *
 **/
public class FileInfo implements java.lang.Cloneable,
                                 java.io.Serializable
{
    /**
     * The pathname.
     **/
    public String path;

    /**
     * The SHA-1 checksum of the file.
     **/
    public byte[] checksum;

    /**
     * The size of the compressed file in number of bytes.
     **/
    public int size;

    /**
     * The executable flag.
     **/
    public boolean executable;

    public FileInfo()
    {
        this.path = "";
    }

    public FileInfo(String path, byte[] checksum, int size, boolean executable)
    {
        this.path = path;
        this.checksum = checksum;
        this.size = size;
        this.executable = executable;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        FileInfo r = null;
        if(rhs instanceof FileInfo)
        {
            r = (FileInfo)rhs;
        }

        if(r != null)
        {
            if(this.path != r.path)
            {
                if(this.path == null || r.path == null || !this.path.equals(r.path))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(this.checksum, r.checksum))
            {
                return false;
            }
            if(this.size != r.size)
            {
                return false;
            }
            if(this.executable != r.executable)
            {
                return false;
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int h_ = 5381;
        h_ = IceInternal.HashUtil.hashAdd(h_, "::IcePatch2::FileInfo");
        h_ = IceInternal.HashUtil.hashAdd(h_, path);
        h_ = IceInternal.HashUtil.hashAdd(h_, checksum);
        h_ = IceInternal.HashUtil.hashAdd(h_, size);
        h_ = IceInternal.HashUtil.hashAdd(h_, executable);
        return h_;
    }

    public FileInfo
    clone()
    {
        FileInfo c = null;
        try
        {
            c = (FileInfo)super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return c;
    }

    public void
    ice_writeMembers(Ice.OutputStream ostr)
    {
        ostr.writeString(this.path);
        Ice.ByteSeqHelper.write(ostr, this.checksum);
        ostr.writeInt(this.size);
        ostr.writeBool(this.executable);
    }

    public void
    ice_readMembers(Ice.InputStream istr)
    {
        this.path = istr.readString();
        this.checksum = Ice.ByteSeqHelper.read(istr);
        this.size = istr.readInt();
        this.executable = istr.readBool();
    }

    static public void
    ice_write(Ice.OutputStream ostr, FileInfo v)
    {
        if(v == null)
        {
            _nullMarshalValue.ice_writeMembers(ostr);
        }
        else
        {
            v.ice_writeMembers(ostr);
        }
    }

    static public FileInfo
    ice_read(Ice.InputStream istr)
    {
        FileInfo v = new FileInfo();
        v.ice_readMembers(istr);
        return v;
    }

    private static final FileInfo _nullMarshalValue = new FileInfo();

    public static final long serialVersionUID = -1649021243L;
}
