/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javajs.util.BS;
import javax.swing.filechooser.FileSystemView;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.webexport.LogPanel;

class JmolInstance {
    String name;
    String javaname;
    String script;
    int width;
    int height;
    int bgColor;
    boolean spinOn;
    String pictFile;
    BS whichWidgets;
    boolean pictIsScratchFile;
    JmolViewer vwr;

    public static JmolInstance getInstance(JmolViewer vwr, String name, int width, int height, int widgets) {
        JmolInstance ji = new JmolInstance(vwr, name, width, height, widgets);
        return ji.script == null ? null : ji;
    }

    private JmolInstance(JmolViewer vwr, String name, int width, int height, int nWidgets) {
        boolean made_scratchdir;
        this.vwr = vwr;
        this.name = name;
        this.width = width;
        this.height = height;
        this.script = vwr.getStateInfo();
        this.spinOn = vwr.getBooleanProperty("_spinning");
        if (this.script == null) {
            LogPanel.log("Error trying to get Jmol State when saving view/instance.");
            return;
        }
        this.bgColor = vwr.getBackgroundArgb();
        this.javaname = name.replaceAll("[^a-zA-Z_0-9-]", "_");
        this.whichWidgets = BS.newN(nWidgets);
        FileSystemView Directories = FileSystemView.getFileSystemView();
        File homedir = Directories.getHomeDirectory();
        String homedirpath = homedir.getPath();
        String scratchpath = homedirpath + "/.jmol_WPM";
        File scratchfile = new File(scratchpath);
        if (!scratchfile.exists() && !(made_scratchdir = scratchfile.mkdir())) {
            LogPanel.log(GT._("Attempt to make scratch directory failed."));
        }
        this.pictFile = scratchpath + "/" + this.javaname + ".png";
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        params.put("fileName", this.pictFile);
        params.put("type", "PNG");
        params.put("quality", 2);
        params.put("width", width);
        params.put("height", height);
        vwr.outputToFile(params);
        this.pictIsScratchFile = true;
    }

    boolean movepict(String dirpath) throws IOException {
        String imagename = dirpath + "/" + this.javaname + ".png";
        if (this.pictFile.equals(imagename)) {
            return false;
        }
        FileInputStream is = null;
        is = new FileInputStream(this.pictFile);
        FileOutputStream os = null;
        os = new FileOutputStream(imagename);
        int pngbyteint = is.read();
        while (pngbyteint != -1) {
            os.write(pngbyteint);
            pngbyteint = is.read();
        }
        os.flush();
        os.close();
        is.close();
        return true;
    }

    boolean delete() throws IOException {
        File scratchToErase = new File(this.pictFile);
        if (scratchToErase.exists() && !scratchToErase.delete()) {
            throw new IOException("Failed to delete scratch file " + this.pictFile + ".");
        }
        return true;
    }

    boolean addWidget(int widgetID) {
        if (widgetID > this.whichWidgets.size()) {
            return false;
        }
        if (widgetID < 0) {
            return false;
        }
        this.whichWidgets.set(widgetID);
        return true;
    }

    boolean deleteWidget(int widgetID) {
        if (widgetID > this.whichWidgets.size()) {
            return false;
        }
        if (widgetID < 0) {
            return false;
        }
        this.whichWidgets.clear(widgetID);
        return true;
    }
}

