/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Map;
import javajs.util.PT;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.undo.UndoManager;
import org.jmol.api.JmolDropEditor;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.awt.FileDropper;
import org.jmol.console.JmolConsole;
import org.jmol.i18n.GT;
import org.jmol.script.ScriptContext;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.PreferencesDialog;

public final class ScriptEditor
extends JDialog
implements JmolScriptEditorInterface,
ActionListener,
WindowListener {
    protected EditorTextPane editor;
    private JButton openButton;
    private JButton closeButton;
    private JButton loadButton;
    private JButton topButton;
    private JButton fontButton;
    private JButton checkButton;
    private JButton runButton;
    private JButton pauseButton;
    private JButton saveButton;
    private JButton saveAsButton;
    private JButton haltButton;
    private JButton clearButton;
    private JButton stateButton;
    private JButton consoleButton;
    protected JButton stepButton;
    protected JButton resumeButton;
    private Viewer vwr;
    private JmolConsole jmolConsole;
    protected String title;
    protected String parsedData = "";
    protected ScriptContext parsedContext;
    protected SimpleAttributeSet attHighlight;
    protected SimpleAttributeSet attEcho;
    protected SimpleAttributeSet attError;
    private JPanel buttonPanel = new JPanel();
    protected String filename;
    private Map<String, Object> map;
    private int fontSize;
    private String zipFileName;
    private static String[] lastOpened = new String[]{"?.spt", null};

    public ScriptEditor() {
    }

    ScriptEditor(Viewer vwr, JFrame frame, JmolConsole jmolConsole) {
        super(frame, null, false);
        this.setAttributes();
        this.title = GT._((String)"Jmol Script Editor");
        this.setTitle(this.title);
        this.vwr = vwr;
        this.jmolConsole = jmolConsole;
        this.layoutWindow(this.getContentPane());
        this.setSize(745, 400);
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        }
    }

    private void setAttributes() {
        this.attHighlight = new SimpleAttributeSet();
        StyleConstants.setBackground(this.attHighlight, Color.LIGHT_GRAY);
        StyleConstants.setForeground(this.attHighlight, Color.blue);
        StyleConstants.setBold(this.attHighlight, true);
        this.attEcho = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attEcho, Color.blue);
        StyleConstants.setBold(this.attEcho, true);
        this.attError = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attError, Color.red);
        StyleConstants.setBold(this.attError, true);
    }

    void layoutWindow(Container container) {
        this.editor = new EditorTextPane();
        this.editor.setDragEnabled(true);
        this.editor.setDropTarget(new DropTarget(this.editor, (DropTargetListener)new FileDropper(null, this.vwr, (JmolDropEditor)this)));
        JScrollPane editorPane = new JScrollPane(this.editor);
        this.updateFontSize();
        this.consoleButton = this.setButton(GT._((String)"Console"));
        if (!this.vwr.isApplet || this.vwr.getBooleanProperty("_signedApplet")) {
            this.openButton = this.setButton(GT._((String)"Open"));
        }
        this.fontButton = this.setButton(GT._((String)"Font"));
        this.loadButton = this.setButton(GT._((String)"Script"));
        this.checkButton = this.setButton(GT._((String)"Check"));
        this.topButton = this.setButton(PT.split((String)GT._((String)"Top[as in \"go to the top\" - (translators: remove this bracketed part]"), (String)"[")[0]);
        this.stepButton = this.setButton(GT._((String)"Step"));
        this.runButton = this.setButton(GT._((String)"Run"));
        this.pauseButton = this.setButton(GT._((String)"Pause"));
        this.pauseButton.setEnabled(true);
        this.resumeButton = this.setButton(GT._((String)"Resume"));
        this.resumeButton.setEnabled(false);
        this.haltButton = this.setButton(GT._((String)"Halt"));
        this.haltButton.setEnabled(false);
        this.clearButton = this.setButton(GT._((String)"Clear"));
        this.closeButton = this.setButton(GT._((String)"Close"));
        this.saveButton = this.setButton(GT._((String)"Save"));
        this.saveButton.setEnabled(false);
        this.saveAsButton = this.setButton(PT.rep((String)GT._((String)"&Save As..."), (String)"&", (String)""));
        this.saveAsButton.setEnabled(false);
        JPanel buttonPanelWrapper = new JPanel();
        buttonPanelWrapper.setLayout(new BorderLayout());
        buttonPanelWrapper.add((Component)this.buttonPanel, "Center");
        JSplitPane spane = new JSplitPane(0, editorPane, buttonPanelWrapper);
        editorPane.setMinimumSize(new Dimension(300, 300));
        editorPane.setPreferredSize(new Dimension(5000, 5000));
        buttonPanelWrapper.setMinimumSize(new Dimension(60, 60));
        buttonPanelWrapper.setMaximumSize(new Dimension(1000, 60));
        buttonPanelWrapper.setPreferredSize(new Dimension(60, 60));
        spane.setDividerSize(0);
        spane.setResizeWeight(0.95);
        container.add(spane);
    }

    private JButton setButton(String s) {
        JButton b = new JButton(s);
        b.addActionListener(this);
        this.buttonPanel.add(b);
        return b;
    }

    public void notifyScriptStart() {
        this.runButton.setEnabled(false);
        this.resumeButton.setEnabled(false);
        this.haltButton.setEnabled(true);
        this.pauseButton.setEnabled(true);
    }

    public void notifyScriptTermination() {
        this.runButton.setEnabled(true);
        this.pauseButton.setEnabled(false);
        this.resumeButton.setEnabled(false);
        this.haltButton.setEnabled(false);
        this.editor.editorDoc.clearHighlight();
        this.editor.setCaretPosition(this.editor.editorDoc.getLength());
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.vwr.getProperty("DATA_API", "scriptEditorState", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
        if (b) {
            this.editor.grabFocus();
        }
    }

    public String getText() {
        return this.editor.getText();
    }

    public void output(String message) {
        this.setSaveEnabled(null);
        this.editor.clearContent(message);
    }

    private void setSaveEnabled(String zipName) {
        this.saveButton.setEnabled(zipName != null);
        this.saveAsButton.setEnabled(zipName != null);
        this.zipFileName = zipName;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void notifyContext(ScriptContext context, Object[] data) {
        this.haltButton.setEnabled(context.errorMessage == null);
        this.pauseButton.setEnabled(context.errorMessage == null);
        this.resumeButton.setEnabled(false);
        if (context.errorMessage == null) {
            this.setContext(context);
        }
    }

    private synchronized void setContext(ScriptContext context) {
        this.pauseButton.setEnabled(this.vwr.isScriptExecuting());
        if (context.script.indexOf("\u0001## EDITOR_IGNORE ##") >= 0) {
            return;
        }
        this.parsedContext = context;
        this.filename = context.scriptFileName;
        this.setTitle(this.title + this.parsedContext.contextPath);
        if (this.filename == null && context.functionName != null) {
            this.filename = "function " + context.functionName;
        }
        this.parsedData = this.editor.editorDoc.outputEcho(context.script);
        boolean isPaused = context.executionPaused || context.executionStepping;
        this.pauseButton.setEnabled(!isPaused && this.vwr.isScriptExecuting());
        this.resumeButton.setEnabled(isPaused);
        this.gotoCommand(context.pc, isPaused, this.attHighlight);
    }

    private void gotoCommand(int pt, boolean isPaused, SimpleAttributeSet attr) {
        ScriptContext context = this.parsedContext;
        try {
            try {
                int pt2;
                int pt1;
                this.setVisible(true);
                if (pt < 0) {
                    pt1 = 0;
                    pt2 = this.editor.getDocument().getLength();
                } else if (context == null || context.getTokenCount() < 0) {
                    pt2 = 0;
                    pt1 = 0;
                } else if (pt < context.getTokenCount()) {
                    pt1 = context.lineIndices[pt][0];
                    pt2 = context.lineIndices[pt][1];
                } else {
                    pt1 = pt2 = this.editor.getDocument().getLength();
                }
                if (isPaused) {
                    this.editor.setCaretPosition(pt1);
                    this.editor.editorDoc.doHighlight(pt1, pt2, attr);
                }
            }
            catch (Exception e) {
                this.editor.setCaretPosition(0);
            }
        }
        catch (Error er) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.checkAction(e);
    }

    private synchronized void checkAction(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.consoleButton) {
            this.jmolConsole.setVisible(true);
            return;
        }
        if (source == this.openButton) {
            this.doOpen();
            return;
        }
        if (source == this.closeButton) {
            this.setVisible(false);
            return;
        }
        if (source == this.loadButton) {
            this.setContext(this.vwr.getScriptContext("SE loadButton"));
            return;
        }
        if (source == this.topButton) {
            this.gotoTop();
            return;
        }
        if (source == this.fontButton) {
            PreferencesDialog d = (PreferencesDialog)this.vwr.getProperty("DATA_API", "getPreference", null);
            if (d != null) {
                d.setFontScale(-1);
            }
            this.updateFontSize();
            return;
        }
        if (source == this.checkButton) {
            this.checkScript();
            return;
        }
        if (source == this.runButton) {
            this.notifyScriptStart();
            String s = this.editor.getText();
            this.jmolConsole.execute(s + "\u0001##");
            return;
        }
        if (source == this.pauseButton) {
            this.jmolConsole.execute("!pause\u0001##");
            return;
        }
        if (source == this.resumeButton) {
            this.doResume();
            return;
        }
        if (source == this.stepButton) {
            this.doStep();
            return;
        }
        if (source == this.clearButton) {
            this.editor.clearContent();
            return;
        }
        if (source == this.stateButton) {
            this.editor.clearContent(this.vwr.getStateInfo());
            return;
        }
        if (source == this.haltButton) {
            this.vwr.haltScriptExecution();
            return;
        }
        if (source == this.saveButton) {
            this.saveZip(false);
            return;
        }
        if (source == this.saveAsButton) {
            this.saveZip(true);
            return;
        }
    }

    private void saveZip(boolean isAs) {
        if (!isAs) {
            String script = this.editor.getText().trim();
            if (script.startsWith("load ")) {
                script = script.substring(script.indexOf(";") + 1);
            }
            this.map = this.vwr.fm.getFileAsMap(this.zipFileName, null);
            if (this.map == null) {
                return;
            }
            this.map.put("movie.spt", script);
        }
    }

    public void updateFontSize() {
        int scale = PT.parseInt((String)("" + (String)this.vwr.getProperty("DATA_API", "getPreference", (Object)"consoleFontScale")));
        scale = (scale < 0 ? 1 : scale) % 5;
        this.fontSize = scale * 4 + 12;
        if (this.editor != null) {
            this.editor.setFont(new Font("dialog", 0, this.fontSize));
        }
    }

    private void doOpen() {
        this.vwr.fm.getFileDataAsString(lastOpened, -1, false, false, true);
        this.editor.clearContent(lastOpened[1]);
        ScriptEditor.lastOpened[1] = null;
    }

    public void gotoTop() {
        this.editor.setCaretPosition(0);
        this.editor.grabFocus();
        this.gotoPosition(0, 0);
    }

    public void checkScript() {
        this.parsedContext = null;
        this.parseScript(this.editor.getText());
    }

    protected void parseScript(String text) {
        if (text == null || text.length() == 0) {
            this.parsedContext = null;
            this.parsedData = "";
            this.setTitle(this.title);
            return;
        }
        if (this.parsedContext == null || !text.equals(this.parsedData)) {
            this.parsedData = text;
            this.parsedContext = (ScriptContext)this.vwr.getProperty("DATA_API", "scriptCheck", (Object)text);
        }
        this.gotoParsedLine();
    }

    private void gotoParsedLine() {
        this.setTitle(this.title + " " + this.parsedContext.contextPath + " -- " + (this.parsedContext.getTokenCount() < 0 ? "" : this.parsedContext.getTokenCount() + " commands ") + (this.parsedContext.iCommandError < 0 ? "" : " ERROR: " + this.parsedContext.errorType));
        boolean isError = this.parsedContext.iCommandError >= 0;
        this.gotoCommand(isError ? this.parsedContext.iCommandError : 0, true, isError ? this.attError : this.attHighlight);
    }

    public void doStep() {
        boolean isPaused = this.vwr.getBooleanProperty("executionPaused");
        this.jmolConsole.execute(isPaused ? "!step\u0001##" : this.editor.getText() + "\u0001##SCRIPT_STEP\n##SCRIPT_START=" + this.editor.getCaretPosition());
    }

    protected void doResume() {
        this.editor.clearContent();
        this.jmolConsole.execute("!resume\u0001##");
    }

    private void gotoPosition(int i, int j) {
        this.editor.scrollRectToVisible(new Rectangle(i, j));
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void show(String[] fileText) {
        if (fileText == null) {
            fileText = new String[]{null, null};
        }
        if (fileText[1] == null) {
            fileText[1] = "#no data#";
        }
        String filename = fileText[0];
        String msg = fileText[1];
        if (msg != null) {
            this.setFilename(filename);
            this.output(FileManager.getEmbeddedScript((String)msg));
        }
        this.setVisible(true);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.updateFontSize();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void loadContent(String script) {
        System.out.println("SCRIPT is " + script);
    }

    public void loadFile(String fileName) {
        System.out.println(fileName);
        if (!(fileName.endsWith("png") || fileName.endsWith("pngj") || fileName.endsWith("jmol") || fileName.endsWith("zip"))) {
            return;
        }
        try {
            this.setSaveEnabled(fileName);
            this.output(this.vwr.fm.getEmbeddedFileState(fileName, false, "movie.spt"));
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            String data = this.vwr.fm.getEmbeddedFileState(fileName, false, "state.spt");
            if (data.indexOf("preferredWidthHeight") >= 0) {
                this.vwr.sm.resizeInnerPanelString(data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.vwr.openFileAsyncSpecial(fileName, 11);
    }

    class EditorDocument
    extends DefaultStyledDocument {
        EditorTextPane EditorTextPane;
        protected UndoManager undo = new UndoManager();

        EditorDocument() {
            this.putProperty("__EndOfLine__", "\n");
            this.addUndoableEditListener(new MyUndoableEditListener());
        }

        void setEditorTextPane(EditorTextPane EditorTextPane2) {
            this.EditorTextPane = EditorTextPane2;
        }

        void doHighlight(int from, int to, SimpleAttributeSet attr) {
            this.clearHighlight();
            if (from >= to) {
                return;
            }
            this.setCharacterAttributes(from, to - from, attr, true);
            ScriptEditor.this.editor.select(from, to);
            ScriptEditor.this.editor.setSelectedTextColor(attr == ScriptEditor.this.attError ? Color.RED : Color.black);
        }

        void clearHighlight() {
            this.setCharacterAttributes(0, ScriptEditor.this.editor.editorDoc.getLength(), ScriptEditor.this.attEcho, true);
        }

        protected void undo() {
            try {
                this.undo.undo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void redo() {
            try {
                this.undo.redo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void clearContent() {
            try {
                super.remove(0, this.getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        String outputEcho(String text) {
            this.clearContent();
            if (text == null) {
                return "";
            }
            int pt = text.indexOf(1);
            if (pt >= 0) {
                text = text.substring(0, pt).trim();
            }
            if (!text.endsWith("\n")) {
                text = text + "\n";
            }
            try {
                super.insertString(0, text, ScriptEditor.this.attEcho);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return text;
        }

        protected class MyUndoableEditListener
        implements UndoableEditListener {
            protected MyUndoableEditListener() {
            }

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                EditorDocument.this.undo.addEdit(e.getEdit());
            }
        }
    }

    class EditorTextPane
    extends JTextPane {
        EditorDocument editorDoc;
        boolean checking;

        EditorTextPane() {
            super(new EditorDocument());
            this.checking = false;
            this.editorDoc = (EditorDocument)this.getDocument();
            this.editorDoc.setEditorTextPane(this);
        }

        public void clearContent() {
            ScriptEditor.this.filename = null;
            this.clearContent(null);
        }

        public synchronized void clearContent(String text) {
            this.editorDoc.outputEcho(text);
            ScriptEditor.this.parseScript(text);
        }

        @Override
        protected void processKeyEvent(KeyEvent ke) {
            int kcode = ke.getKeyCode();
            int kid = ke.getID();
            if (kid == 401) {
                switch (kcode) {
                    case 90: {
                        if (!ke.isControlDown()) break;
                        if (ke.isShiftDown()) {
                            ScriptEditor.this.editor.editorDoc.redo();
                        } else {
                            ScriptEditor.this.editor.editorDoc.undo();
                        }
                        return;
                    }
                    case 89: {
                        if (!ke.isControlDown()) break;
                        ScriptEditor.this.editor.editorDoc.redo();
                        return;
                    }
                    case 116: {
                        if (ScriptEditor.this.stepButton.isEnabled()) {
                            ScriptEditor.this.doStep();
                        }
                        return;
                    }
                    case 119: {
                        if (ScriptEditor.this.resumeButton.isEnabled()) {
                            ScriptEditor.this.doResume();
                        }
                        return;
                    }
                }
            }
            super.processKeyEvent(ke);
        }
    }
}

