/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyClass;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.PutInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;

public class PutFieldInstr
extends PutInstr
implements FixedArityInstr {
    private transient VariableAccessor accessor = VariableAccessor.DUMMY_ACCESSOR;

    public PutFieldInstr(Operand obj, String fieldName, Operand value2) {
        super(Operation.PUT_FIELD, obj, fieldName, value2);
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new PutFieldInstr(this.getTarget().cloneForInlining(ii), this.ref, this.getValue().cloneForInlining(ii));
    }

    public VariableAccessor getAccessor(IRubyObject o) {
        RubyClass cls = o.getMetaClass().getRealClass();
        VariableAccessor localAccessor = this.accessor;
        if (localAccessor.getClassId() != cls.hashCode()) {
            this.accessor = localAccessor = cls.getVariableAccessorForWrite(this.getRef());
        }
        return localAccessor;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject object = (IRubyObject)this.getTarget().retrieve(context, self2, currScope, currDynScope, temp);
        VariableAccessor a = this.getAccessor(object);
        Object value2 = this.getValue().retrieve(context, self2, currScope, currDynScope, temp);
        a.set(object, value2);
        return null;
    }

    public static PutFieldInstr decode(IRReaderDecoder d) {
        return new PutFieldInstr(d.decodeOperand(), d.decodeString(), d.decodeOperand());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.PutFieldInstr(this);
    }
}

