/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.colorchooser.ColorSelectionModel;

public abstract class AbstractColorChooserPanel
extends JPanel {
    private final PropertyChangeListener enabledListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof Boolean) {
                AbstractColorChooserPanel.this.setEnabled((Boolean)object);
            }
        }
    };
    private JColorChooser chooser;

    public abstract void updateChooser();

    protected abstract void buildChooser();

    public abstract String getDisplayName();

    public int getMnemonic() {
        return 0;
    }

    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    public abstract Icon getSmallDisplayIcon();

    public abstract Icon getLargeDisplayIcon();

    public void installChooserPanel(JColorChooser jColorChooser) {
        if (this.chooser != null) {
            throw new RuntimeException("This chooser panel is already installed");
        }
        this.chooser = jColorChooser;
        this.chooser.addPropertyChangeListener("enabled", this.enabledListener);
        this.setEnabled(this.chooser.isEnabled());
        this.buildChooser();
        this.updateChooser();
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        this.chooser.removePropertyChangeListener("enabled", this.enabledListener);
        this.chooser = null;
    }

    public ColorSelectionModel getColorSelectionModel() {
        return this.chooser != null ? this.chooser.getSelectionModel() : null;
    }

    protected Color getColorFromModel() {
        ColorSelectionModel colorSelectionModel = this.getColorSelectionModel();
        return colorSelectionModel != null ? colorSelectionModel.getSelectedColor() : null;
    }

    void setSelectedColor(Color color) {
        ColorSelectionModel colorSelectionModel = this.getColorSelectionModel();
        if (colorSelectionModel != null) {
            colorSelectionModel.setSelectedColor(color);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    int getInt(Object object, int n) {
        Object object2 = UIManager.get(object, this.getLocale());
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            try {
                return Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }
}

