/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.painless.Compiler;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.GenericElasticsearchScript;
import org.elasticsearch.painless.ScriptImpl;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.SSource;
import org.elasticsearch.painless.spi.Whitelist;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.SearchScript;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class PainlessScriptEngine
extends AbstractComponent
implements ScriptEngine {
    public static final String NAME = "painless";
    private static final AccessControlContext COMPILATION_CONTEXT;
    private final CompilerSettings defaultCompilerSettings = new CompilerSettings();
    private final Map<ScriptContext<?>, Compiler> contextsToCompilers;
    static final String INLINE_NAME = "<inline>";

    public PainlessScriptEngine(Settings settings, Map<ScriptContext<?>, List<Whitelist>> contexts) {
        super(settings);
        this.defaultCompilerSettings.setRegexesEnabled((Boolean)CompilerSettings.REGEX_ENABLED.get(settings));
        HashMap contextsToCompilers = new HashMap();
        for (Map.Entry<ScriptContext<?>, List<Whitelist>> entry : contexts.entrySet()) {
            ScriptContext<?> context = entry.getKey();
            if (context.instanceClazz.equals(SearchScript.class) || context.instanceClazz.equals(ExecutableScript.class)) {
                contextsToCompilers.put(context, new Compiler(GenericElasticsearchScript.class, new Definition(entry.getValue())));
                continue;
            }
            contextsToCompilers.put(context, new Compiler(context.instanceClazz, new Definition(entry.getValue())));
        }
        this.contextsToCompilers = Collections.unmodifiableMap(contextsToCompilers);
    }

    public String getType() {
        return NAME;
    }

    public <T> T compile(String scriptName, String scriptSource, ScriptContext<T> context, Map<String, String> params) {
        final Compiler compiler = this.contextsToCompilers.get(context);
        if (context.instanceClazz.equals(SearchScript.class)) {
            final GenericElasticsearchScript painlessScript = (GenericElasticsearchScript)this.compile(compiler, scriptName, scriptSource, params, new Object[0]);
            SearchScript.Factory factory = (p, lookup) -> new SearchScript.LeafFactory(){

                public SearchScript newInstance(LeafReaderContext context) {
                    return new ScriptImpl(painlessScript, p, lookup, context);
                }

                public boolean needs_score() {
                    return painlessScript.needs_score();
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ExecutableScript.class)) {
            GenericElasticsearchScript painlessScript = (GenericElasticsearchScript)this.compile(compiler, scriptName, scriptSource, params, new Object[0]);
            ExecutableScript.Factory factory = p -> new ScriptImpl(painlessScript, p, null, null);
            return context.factoryClazz.cast(factory);
        }
        SpecialPermission.check();
        Compiler.Loader loader = AccessController.doPrivileged(new PrivilegedAction<Compiler.Loader>(){

            @Override
            public Compiler.Loader run() {
                return compiler.createLoader(this.getClass().getClassLoader());
            }
        });
        SSource.MainMethodReserved reserved = new SSource.MainMethodReserved();
        this.compile(this.contextsToCompilers.get(context), loader, reserved, scriptName, scriptSource, params);
        if (context.statefulFactoryClazz != null) {
            return this.generateFactory(loader, context, reserved, this.generateStatefulFactory(loader, context, reserved));
        }
        return this.generateFactory(loader, context, reserved, WriterConstants.CLASS_TYPE);
    }

    private <T> Type generateStatefulFactory(Compiler.Loader loader, ScriptContext<T> context, SSource.MainMethodReserved reserved) {
        int classFrames = 3;
        int classAccess = 49;
        String interfaceBase = Type.getType((Class)context.statefulFactoryClazz).getInternalName();
        String className = interfaceBase + "$StatefulFactory";
        String[] classInterfaces = new String[]{interfaceBase};
        ClassWriter writer = new ClassWriter(classFrames);
        writer.visit(52, classAccess, className, null, WriterConstants.OBJECT_TYPE.getInternalName(), classInterfaces);
        java.lang.reflect.Method newFactory = null;
        for (java.lang.reflect.Method method : context.factoryClazz.getMethods()) {
            if (!"newFactory".equals(method.getName())) continue;
            newFactory = method;
            break;
        }
        for (int count = 0; count < newFactory.getParameterTypes().length; ++count) {
            writer.visitField(18, "$arg" + count, Type.getType(newFactory.getParameterTypes()[count]).getDescriptor(), null, null).visitEnd();
        }
        Method base = new Method("<init>", MethodType.methodType(Void.TYPE).toMethodDescriptorString());
        Method init = new Method("<init>", MethodType.methodType(Void.TYPE, newFactory.getParameterTypes()).toMethodDescriptorString());
        GeneratorAdapter constructor = new GeneratorAdapter(327680, init, writer.visitMethod(1, init.getName(), init.getDescriptor(), null, null));
        constructor.visitCode();
        constructor.loadThis();
        constructor.invokeConstructor(WriterConstants.OBJECT_TYPE, base);
        for (int count = 0; count < newFactory.getParameterTypes().length; ++count) {
            constructor.loadThis();
            constructor.loadArg(count);
            constructor.putField(Type.getType((String)className), "$arg" + count, Type.getType(newFactory.getParameterTypes()[count]));
        }
        constructor.returnValue();
        constructor.endMethod();
        java.lang.reflect.Method newInstance = null;
        for (java.lang.reflect.Method method : context.statefulFactoryClazz.getMethods()) {
            if (!"newInstance".equals(method.getName())) continue;
            newInstance = method;
            break;
        }
        Method instance = new Method(newInstance.getName(), MethodType.methodType(newInstance.getReturnType(), newInstance.getParameterTypes()).toMethodDescriptorString());
        ArrayList parameters = new ArrayList(Arrays.asList(newFactory.getParameterTypes()));
        parameters.addAll(Arrays.asList(newInstance.getParameterTypes()));
        Method constru = new Method("<init>", MethodType.methodType(Void.TYPE, parameters.toArray(new Class[0])).toMethodDescriptorString());
        GeneratorAdapter adapter = new GeneratorAdapter(327680, instance, writer.visitMethod(17, instance.getName(), instance.getDescriptor(), null, null));
        adapter.visitCode();
        adapter.newInstance(WriterConstants.CLASS_TYPE);
        adapter.dup();
        for (int count = 0; count < newFactory.getParameterTypes().length; ++count) {
            adapter.loadThis();
            adapter.getField(Type.getType((String)className), "$arg" + count, Type.getType(newFactory.getParameterTypes()[count]));
        }
        adapter.loadArgs();
        adapter.invokeConstructor(WriterConstants.CLASS_TYPE, constru);
        adapter.returnValue();
        adapter.endMethod();
        this.writeNeedsMethods(context.statefulFactoryClazz, writer, reserved);
        writer.visitEnd();
        loader.defineFactory(className.replace('/', '.'), writer.toByteArray());
        return Type.getType((String)className);
    }

    private <T> T generateFactory(Compiler.Loader loader, ScriptContext<T> context, SSource.MainMethodReserved reserved, Type classType) {
        int classFrames = 3;
        int classAccess = 49;
        String interfaceBase = Type.getType((Class)context.factoryClazz).getInternalName();
        String className = interfaceBase + "$Factory";
        String[] classInterfaces = new String[]{interfaceBase};
        ClassWriter writer = new ClassWriter(classFrames);
        writer.visit(52, classAccess, className, null, WriterConstants.OBJECT_TYPE.getInternalName(), classInterfaces);
        Method init = new Method("<init>", MethodType.methodType(Void.TYPE).toMethodDescriptorString());
        GeneratorAdapter constructor = new GeneratorAdapter(327680, init, writer.visitMethod(1, init.getName(), init.getDescriptor(), null, null));
        constructor.visitCode();
        constructor.loadThis();
        constructor.invokeConstructor(WriterConstants.OBJECT_TYPE, init);
        constructor.returnValue();
        constructor.endMethod();
        java.lang.reflect.Method reflect = null;
        for (java.lang.reflect.Method method : context.factoryClazz.getMethods()) {
            if ("newInstance".equals(method.getName())) {
                reflect = method;
                break;
            }
            if (!"newFactory".equals(method.getName())) continue;
            reflect = method;
            break;
        }
        Method instance = new Method(reflect.getName(), MethodType.methodType(reflect.getReturnType(), reflect.getParameterTypes()).toMethodDescriptorString());
        Method constru = new Method("<init>", MethodType.methodType(Void.TYPE, reflect.getParameterTypes()).toMethodDescriptorString());
        GeneratorAdapter adapter = new GeneratorAdapter(327680, instance, writer.visitMethod(17, instance.getName(), instance.getDescriptor(), null, null));
        adapter.visitCode();
        adapter.newInstance(classType);
        adapter.dup();
        adapter.loadArgs();
        adapter.invokeConstructor(classType, constru);
        adapter.returnValue();
        adapter.endMethod();
        this.writeNeedsMethods(context.factoryClazz, writer, reserved);
        writer.visitEnd();
        Class<?> factory = loader.defineFactory(className.replace('/', '.'), writer.toByteArray());
        try {
            return context.factoryClazz.cast(factory.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception exception) {
            throw new IllegalStateException("An internal error occurred attempting to define the factory class [" + className + "].", exception);
        }
    }

    private void writeNeedsMethods(Class<?> clazz, ClassWriter writer, SSource.MainMethodReserved reserved) {
        for (java.lang.reflect.Method method : clazz.getMethods()) {
            if (!method.getName().startsWith("needs") || !method.getReturnType().equals(Boolean.TYPE) || method.getParameterTypes().length != 0) continue;
            String name = method.getName();
            name = name.substring(5);
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            Method needs = new Method(method.getName(), MethodType.methodType(Boolean.TYPE).toMethodDescriptorString());
            GeneratorAdapter adapter = new GeneratorAdapter(327680, needs, writer.visitMethod(1, needs.getName(), needs.getDescriptor(), null, null));
            adapter.visitCode();
            adapter.push(reserved.getUsedVariables().contains(name));
            adapter.returnValue();
            adapter.endMethod();
        }
    }

    Object compile(final Compiler compiler, final String scriptName, final String source, Map<String, String> params, final Object ... args) {
        CompilerSettings compilerSettings;
        if (params.isEmpty()) {
            compilerSettings = this.defaultCompilerSettings;
        } else {
            compilerSettings = new CompilerSettings();
            compilerSettings.setRegexesEnabled(this.defaultCompilerSettings.areRegexesEnabled());
            HashMap<String, String> copy = new HashMap<String, String>(params);
            String value = (String)copy.remove("max_loop_counter");
            if (value != null) {
                compilerSettings.setMaxLoopCounter(Integer.parseInt(value));
            }
            if ((value = (String)copy.remove("picky")) != null) {
                compilerSettings.setPicky(Boolean.parseBoolean(value));
            }
            if ((value = (String)copy.remove("initialCallSiteDepth")) != null) {
                compilerSettings.setInitialCallSiteDepth(Integer.parseInt(value));
            }
            if ((value = (String)copy.remove(CompilerSettings.REGEX_ENABLED.getKey())) != null) {
                throw new IllegalArgumentException("[painless.regex.enabled] can only be set on node startup.");
            }
            if (!copy.isEmpty()) {
                throw new IllegalArgumentException("Unrecognized compile-time parameter(s): " + copy);
            }
        }
        SpecialPermission.check();
        final Compiler.Loader loader = AccessController.doPrivileged(new PrivilegedAction<Compiler.Loader>(){

            @Override
            public Compiler.Loader run() {
                return compiler.createLoader(this.getClass().getClassLoader());
            }
        });
        try {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    String name = scriptName == null ? PainlessScriptEngine.INLINE_NAME : scriptName;
                    Constructor<?> constructor = compiler.compile(loader, new SSource.MainMethodReserved(), name, source, compilerSettings);
                    try {
                        return constructor.newInstance(args);
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException("An internal error occurred attempting to define the script [" + name + "].", exception);
                    }
                }
            }, COMPILATION_CONTEXT);
        }
        catch (Exception | OutOfMemoryError | StackOverflowError | VerifyError e) {
            throw this.convertToScriptException(scriptName == null ? source : scriptName, source, e);
        }
    }

    void compile(final Compiler compiler, final Compiler.Loader loader, final SSource.MainMethodReserved reserved, final String scriptName, final String source, Map<String, String> params) {
        CompilerSettings compilerSettings;
        if (params.isEmpty()) {
            compilerSettings = this.defaultCompilerSettings;
        } else {
            compilerSettings = new CompilerSettings();
            compilerSettings.setRegexesEnabled(this.defaultCompilerSettings.areRegexesEnabled());
            HashMap<String, String> copy = new HashMap<String, String>(params);
            String value = (String)copy.remove("max_loop_counter");
            if (value != null) {
                compilerSettings.setMaxLoopCounter(Integer.parseInt(value));
            }
            if ((value = (String)copy.remove("picky")) != null) {
                compilerSettings.setPicky(Boolean.parseBoolean(value));
            }
            if ((value = (String)copy.remove("initialCallSiteDepth")) != null) {
                compilerSettings.setInitialCallSiteDepth(Integer.parseInt(value));
            }
            if ((value = (String)copy.remove(CompilerSettings.REGEX_ENABLED.getKey())) != null) {
                throw new IllegalArgumentException("[painless.regex.enabled] can only be set on node startup.");
            }
            if (!copy.isEmpty()) {
                throw new IllegalArgumentException("Unrecognized compile-time parameter(s): " + copy);
            }
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    String name = scriptName == null ? PainlessScriptEngine.INLINE_NAME : scriptName;
                    compiler.compile(loader, reserved, name, source, compilerSettings);
                    return null;
                }
            }, COMPILATION_CONTEXT);
        }
        catch (Exception | OutOfMemoryError | StackOverflowError | VerifyError e) {
            throw this.convertToScriptException(scriptName == null ? source : scriptName, source, e);
        }
    }

    private ScriptException convertToScriptException(String scriptName, String scriptSource, Throwable t) {
        ArrayList<String> scriptStack = new ArrayList<String>();
        for (StackTraceElement element : t.getStackTrace()) {
            if (!WriterConstants.CLASS_NAME.equals(element.getClassName())) continue;
            int offset = element.getLineNumber();
            if (offset == -1) {
                scriptStack.add("<<< unknown portion of script >>>");
                break;
            }
            int startOffset = this.getPreviousStatement(scriptSource, --offset);
            int endOffset = this.getNextStatement(scriptSource, offset);
            StringBuilder snippet = new StringBuilder();
            if (startOffset > 0) {
                snippet.append("... ");
            }
            snippet.append(scriptSource.substring(startOffset, endOffset));
            if (endOffset < scriptSource.length()) {
                snippet.append(" ...");
            }
            scriptStack.add(snippet.toString());
            StringBuilder pointer = new StringBuilder();
            if (startOffset > 0) {
                pointer.append("    ");
            }
            for (int i = startOffset; i < offset; ++i) {
                pointer.append(' ');
            }
            pointer.append("^---- HERE");
            scriptStack.add(pointer.toString());
            break;
        }
        throw new ScriptException("compile error", t, scriptStack, scriptSource, NAME);
    }

    private int getPreviousStatement(String scriptSource, int offset) {
        return Math.max(0, offset - 25);
    }

    private int getNextStatement(String scriptSource, int offset) {
        return Math.min(scriptSource.length(), offset + 25);
    }

    static {
        Permissions none = new Permissions();
        none.setReadOnly();
        COMPILATION_CONTEXT = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, none)});
    }
}

