/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.Hashtable;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.jvxl.readers.PmeshReader;
import org.jmol.jvxl.readers.SurfaceGenerator;

class ObjReader
extends PmeshReader {
    ObjReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2PR(sg, br);
        this.type = "obj";
        this.setHeader();
    }

    @Override
    protected boolean readVertices() throws Exception {
        this.pmeshError = "pmesh ERROR: invalid vertex/face list";
        P3 pt = new P3();
        int color = 0;
        int id = 0;
        int i = 0;
        int nPts = 0;
        Hashtable<String, Integer> htPymol = new Hashtable<String, Integer>();
        Integer ipt = null;
        String spt = null;
        int[] pymolMap = new int[3];
        BS bsOK = new BS();
        while (this.rd() != null) {
            if (this.line.length() < 2 || this.line.charAt(1) != ' ') {
                if (!this.params.readAllData || !this.line.startsWith("usemtl")) continue;
                color = CU.getArgbFromString((String)("[x" + this.line.substring(8) + "]"));
                continue;
            }
            switch (this.line.charAt(0)) {
                case 'v': {
                    this.next[0] = 2;
                    pt.set(PT.parseFloatNext((String)this.line, (int[])this.next), PT.parseFloatNext((String)this.line, (int[])this.next), PT.parseFloatNext((String)this.line, (int[])this.next));
                    boolean addHt = false;
                    if (htPymol == null) {
                        i = this.nVertices;
                    } else {
                        spt = "" + pt;
                        ipt = (Integer)htPymol.get(spt);
                        if (ipt == null) {
                            addHt = true;
                            i = this.nVertices;
                        } else {
                            i = ipt;
                        }
                    }
                    int j = i;
                    if (i == this.nVertices) {
                        if (this.isAnisotropic) {
                            this.setVertexAnisotropy((T3)pt);
                        }
                        if ((j = this.addVertexCopy((T3)pt, 0.0f, this.nVertices++, true)) >= 0) {
                            bsOK.set(i);
                        }
                    }
                    pymolMap[nPts % 3] = j;
                    if (addHt) {
                        htPymol.put(spt, i);
                    }
                    if (htPymol == null || ++nPts <= 3) break;
                    htPymol = null;
                    break;
                }
                case 'f': {
                    int ic;
                    int ib;
                    int ia;
                    if (nPts == 3 && this.line.indexOf("//") < 0) {
                        htPymol = null;
                    }
                    nPts = 0;
                    ++this.nPolygons;
                    String[] tokens = PT.getTokens((String)this.line);
                    int vertexCount = tokens.length - 1;
                    if (vertexCount == 4) {
                        htPymol = null;
                    }
                    if (htPymol == null) {
                        ia = PT.parseInt((String)tokens[1]) - 1;
                        ib = PT.parseInt((String)tokens[2]) - 1;
                        ic = PT.parseInt((String)tokens[3]) - 1;
                        this.pmeshError = " " + ia + " " + ib + " " + ic + " " + this.line;
                        if (!bsOK.get(ia) || !bsOK.get(ib) || !bsOK.get(ic)) break;
                        if (vertexCount == 4) {
                            id = PT.parseInt((String)tokens[4]) - 1;
                            boolean isOK = bsOK.get(id);
                            this.nTriangles = this.addTriangleCheck(ia, ib, ic, isOK ? 3 : 7, 0, false, color);
                            if (!isOK) break;
                            this.nTriangles = this.addTriangleCheck(ia, ic, id, 6, 0, false, color);
                            break;
                        }
                    } else {
                        ia = pymolMap[0];
                        ib = pymolMap[1];
                        ic = pymolMap[2];
                        if (ia < 0 || ib < 0 || ic < 0) break;
                    }
                    this.nTriangles = this.addTriangleCheck(ia, ib, ic, 7, 0, false, color);
                    break;
                }
                case 'g': {
                    htPymol = null;
                    if (!this.params.readAllData) break;
                    try {
                        color = PT.parseIntRadix((String)this.line.substring(3), (int)16);
                        break;
                    }
                    catch (Throwable e) {
                        color = 0;
                    }
                }
            }
        }
        this.pmeshError = null;
        return true;
    }

    @Override
    protected boolean readPolygons() {
        return true;
    }
}

