/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.util.Map;
import javajs.api.GenericImageEncoder;
import javajs.util.OC;

public abstract class ImageEncoder
implements GenericImageEncoder {
    protected OC out;
    protected int width = -1;
    protected int height = -1;
    protected int quality = -1;
    protected String date;
    protected boolean logging;
    protected boolean doClose = true;
    protected int[] pixels;

    @Override
    public boolean createImage(String type, OC out, Map<String, Object> params) throws Exception {
        this.out = out;
        this.logging = Boolean.TRUE == params.get("logging");
        this.width = (Integer)params.get("imageWidth");
        this.height = (Integer)params.get("imageHeight");
        System.out.println("ImageEncoder width height " + this.width + " " + this.height);
        this.pixels = (int[])params.get("imagePixels");
        this.date = (String)params.get("date");
        Integer q = (Integer)params.get("quality");
        this.quality = q == null ? -1 : q;
        this.setParams(params);
        this.generate();
        this.close();
        return this.doClose;
    }

    protected abstract void setParams(Map<String, Object> var1);

    protected abstract void generate() throws Exception;

    protected void putString(String s) {
        byte[] b = s.getBytes();
        this.out.write(b, 0, b.length);
    }

    protected void putByte(int b) {
        this.out.writeByteAsInt(b);
    }

    protected void close() {
    }
}

